<?php
	require_once(GENERAL_CLASSES_DIR.'/table.php');

	class fidelite extends table
	{
		public static $table_name = 'fidelite_mvt';
		public static $unique_id = 'IdFideliteMvt';
		public static $field_list = array('IdFideliteMvtMagasin', 'IdClient', 'IdMagasin', 'IdFideliteMvtType', 'IdTicket', 'DateMvt', 'Valeur', 'Remb_O_N', 'Remb_Date', 'Remb_Heure', 'Remb_IdClient', 'IdFideliteType', 'DateFinValidite', 'Reste', 'HeureMvt', 'TriggerBatchBloque_O_N');


		public static function get($id)
		{
			$db = db::getInstance();

			$req = 'select IdFideliteMvt as id, '.self::liste_champs(self::$table_name, self::$field_list).'
							from '.db::dbname(self::$table_name);
  		if($id > 0)
  			$req.= ' where IdFideliteMvt='.(int)$id;

      $res = $db->query($req);

		if($id != "")
			return $res->fetch_assoc();
		else
			return $res->fetch_all();
		}

		public static function get_by_magasin($id, $id_mag)
		{
			$db = db::getInstance();

			$req = 'select IdFideliteMvt as id, '.self::liste_champs(self::$table_name, self::$field_list).'
							from '.db::dbname(self::$table_name);
  		$req.= ' where IdFideliteMvtMagasin='.(int)$id.' And IdMagasin='.$id_mag;
      $res = $db->query($req);
      return $res->fetch_assoc();
		}

		public static function get_for_client($id_client)
		{
			$db = db::getInstance();

			$req = 'select IdFideliteMvt as id, '.self::liste_champs(self::$table_name, self::$field_list).',
							'.db::dbname('fidelite_mvt_type').'.Libel as LibTypeMvt
							from '.db::dbname(self::$table_name).'
							left join '.db::dbname('fidelite_mvt_type').' on '.db::dbname(self::$table_name).'.IdFideliteMvtType='.db::dbname('fidelite_mvt_type').'.IdFideliteMvtType';
  		$req.= ' where IdClient='.(int)$id_client.'
  							order by DateMvt desc, HeureMvt desc';
  		return $db->query($req);
		}

  	public static function save_from_xml($xml, $id_magasin)
  	{
  		$db = db::getInstance();
  		$id_cloud = self::get_xml_value($xml, 'IdFideliteReseau');
  		$id_local = self::get_xml_value($xml, 'IdFideliteMvt');
  		$fid = false;
  		if($id_cloud > 0)
  			$fid = self::get($id_cloud);
  		else
  			$fid = self::get_by_magasin($id_local, $id_magasin);



  		if(!$fid)// insertion
  			return self::insert_from_xml($xml, $id_magasin);
  		else // modification
  			return self::update_from_xml($fid['id'], $xml, $id_magasin);
  	}

  	protected static function get_cloud_ids($xml, $id_magasin, &$id_client, &$id_client_remb, &$id_ticket)
  	{
  		$id_client = 0;
  		$id_client_remb = 0;
  		$id_client_cloud =  self::get_xml_value($xml, 'IdClientCloud');
  		$id_client_kintpv = self::get_xml_value($xml, 'IdClient');
  		// si le client cloud est précisé c'est lui qu'on prend.
  		if($id_client_cloud > 0)
  			$id_client = $id_client_cloud;
  		else if($id_client_kintpv > 0)
  		{
  			$c = client::get_by_magasin($id_client_kintpv, $id_magasin);
  			if($c)
  				$id_client = $c['id'];
  		}
  		$id_client_remb_kintpv = self::get_xml_value($xml, 'Remb_IdClient');
  		$id_client_cloud_remb_kintpv = self::get_xml_value($xml, 'Remb_IdClientCloud');
  		// si le client cloud est précisé c'est lui qu'on prend.
  		if($id_client_cloud_remb_kintpv > 0)
  			$id_client_remb = $id_client_cloud_remb_kintpv;
  		else if($id_client_remb_kintpv > 0)
  		{
  			$c = client::get_by_magasin($id_client_remb_kintpv, $id_magasin);
  			if($c)
  				$id_client_remb = $c['id'];
  		}

  		$id_ticket = 0;
  		$id_ticket_kintpv = self::get_xml_value($xml, 'IdTicket');
  		if($id_ticket_kintpv > 0)
  		{
	  		$t = ticket::get_by_magasin($id_ticket_kintpv, $id_magasin);
	  		if($t)
	  		{
	  			$id_ticket = $t['id'];
	  		}
	  	}
  	}

  	protected static function insert_from_xml($xml, $id_magasin)
  	{
  		// recherche de l'IdClient cloud correspondant au client Magasin
  		$id_client_cloud = 0;
  		$id_client_remb_cloud = 0;
  		$id_ticket_cloud = 0;
  		self::get_cloud_ids($xml, $id_magasin, $id_client_cloud, $id_client_remb_cloud, $id_ticket_cloud);
  		$id_fidelite = (int)self::get_xml_value($xml, 'IdFideliteReseau');

  		if($id_client_cloud > 0)
  		{
			$dateRemb = Tools::dateIsoToEn(self::get_xml_value($xml, 'Remb_Date'));
			if($dateRemb == "0000-00-00")
				$queryDateRemb = "NULL";
			else
				$queryDateRemb = '"'.$dateRemb.'"';

			$dateFinValidite = Tools::dateIsoToEn(self::get_xml_value($xml, 'DateFinValidite'));
			if($dateFinValidite == "0000-00-00")
				$queryDateFinValidite = "NULL";
			else
				$queryDateFinValidite = '"'.$dateFinValidite.'"';

	  		$query = 'insert into '.db::dbname(self::$table_name).'
	  							(';
	  		if($id_fidelite > 0) $query.= 'IdFideliteMvt, ';
	  		$query.= 'IdFideliteMvtMagasin, 
			IdMagasin, 
			IdClient, 
			IdFideliteMvtType, 
			IdTicket, 
			DateMvt, 
			Valeur, 
			Remb_O_N, 
			Remb_Date,
			Remb_Heure, 
			Remb_IdClient, 
			IdFideliteType, 
			DateFinValidite, 
			Reste, 
			HeureMvt, 
			TriggerBatchBloque_O_N,
			Date_Creation, 
			Date_Modification)
	  		values
	  		(';
			if($id_fidelite > 0) $query.= (int)$id_fidelite.', ';
			  

	  		$query.=	(int)self::get_xml_value($xml, 'IdFideliteMvt').', 
                  '.$id_magasin.',
                   '.(int)$id_client_cloud.', 
                   '.(int)self::get_xml_value($xml, 'IdFideliteMvtType').', 
                   '.(int)$id_ticket_cloud.',
	  				"'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateMvt')).'", 
                   '.db::real(self::get_xml_value($xml, 'Valeur')).',
	  				'.(int)self::get_xml_value($xml, 'Remb_O_N').', 
				   '.$queryDateRemb.',
	  				"'.Tools::dateIsoToTime(self::get_xml_value($xml, 'Remb_Heure')).'", 
                   '.(int)$id_client_remb_cloud.',
	  				'.(int)self::get_xml_value($xml, 'IdFideliteType').', 
                   '.$queryDateFinValidite.',
	  				'.db::real(self::get_xml_value($xml, 'Reste')).',
	  				"'.Tools::dateIsoToTime(self::get_xml_value($xml, 'HeureMvt')).'", 
                   '.(int)self::get_xml_value($xml, 'TriggerBatchBloque_O_N').',
	  				CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)';

	  		$db = db::getInstance();
	  		if($db->query($query))
	  		{
	  			$id = $db->insert_id;
	  			self::new_log_batch($id);

				$file_text = "[Fidélité] Inseràion de la fideléte évec IdFideliteMvtMagasin = '".self::get_xml_value($xml, 'IdFideliteMvt')."' --> Succès \n";
				file_put_contents('logs/log_batch.txt', $file_text, FILE_APPEND);
	  			return $id;
	  		}
  			else
  			{
  				$file_text = "[Fidélité] Inseràion de la fideléte évec IdFideliteMvtMagasin = '".self::get_xml_value($xml, 'IdFideliteMvt')."' --> Erreur (Retour MySQLi : ".$db->error.")\n";
  				$file_text .= "mysqli error : " . $db->error;
  				file_put_contents('logs/log_batch.txt', $file_text, FILE_APPEND);
  			}
	  	}

	  	return false;
  	}

  	protected static function update_from_xml($id_fidelite, $xml, $id_magasin)
  	{
  		// recherche de l'IdClient cloud correspondant au client Magasin
  		$id_client_cloud = 0;
  		$id_client_remb_cloud = 0;
  		$id_ticket_cloud = 0;
  		self::get_cloud_ids($xml, $id_magasin, $id_client_cloud, $id_client_remb_cloud, $id_ticket_cloud);

  		if($id_client_cloud > 0)
  		{
			$dateRemb = Tools::dateIsoToEn(self::get_xml_value($xml, 'Remb_Date'));
			if($dateRemb == "0000-00-00")
				$queryDateRemb = "NULL";
			else
				$queryDateRemb = '"'.$dateRemb.'"';

			$dateFinValidite = Tools::dateIsoToEn(self::get_xml_value($xml, 'DateFinValidite'));
			if($dateFinValidite == "0000-00-00")
				$queryDateFinValidite = "NULL";
			else
				$queryDateFinValidite = '"'.$dateFinValidite.'"';

	  		$query = 'update '.db::dbname(self::$table_name).' set
	  			IdClient='.(int)$id_client_cloud.',	
				IdFideliteMvtType='.(int)self::get_xml_value($xml, 'IdFideliteMvtType').', 
				IdTicket='.(int)$id_ticket_cloud.',
				DateMvt="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateMvt')).'", 
				Valeur='.db::real(self::get_xml_value($xml, 'Valeur')).',
				Remb_O_N='.(int)self::get_xml_value($xml, 'Remb_O_N').', 
				Remb_Date='.$queryDateRemb.',
				Remb_Heure="'.Tools::dateIsoToTime(self::get_xml_value($xml, 'Remb_Heure')).'", 
				Remb_IdClient='.(int)$id_client_remb_cloud.',
				IdFideliteType='.(int)self::get_xml_value($xml, 'IdFideliteType').', 
				DateFinValidite='.$queryDateFinValidite.',
				Reste='.db::real(self::get_xml_value($xml, 'Reste')).',
				HeureMvt="'.Tools::dateIsoToTime(self::get_xml_value($xml, 'HeureMvt')).'", 
				TriggerBatchBloque_O_N='.(int)self::get_xml_value($xml, 'TriggerBatchBloque_O_N').',
				Date_Modification=CURRENT_TIMESTAMP
				Where IdFideliteMvt='.(int)$id_fidelite;
	  		$db = db::getInstance();
	  		if($db->query($query))
	  		{
  	  		self::new_log_batch($id_fidelite);
  				$file_text = "[Fidélité] Mise à jour de la fidélité avec IdFideliteMvtMagasin = '".self::get_xml_value($xml, 'IdFideliteMvt')."' --> Succès\n";
  				file_put_contents('logs/log_batch.txt', $file_text, FILE_APPEND);
  	  		return $id_fidelite;
	  		}
			  else 
        {
  				$file_text = "[Fidélité] Mise à jour de la fidélité avec IdFideliteMvtMagasin = '".self::get_xml_value($xml, 'IdFideliteMvt')."' --> Erreur (Retour MySQLi : ".$db->error.") \n";
  				$file_text .= "mysqli error : " . $db->error . "\n";
  				file_put_contents('logs/log_batch.txt', $file_text, FILE_APPEND);
			  }
	  	}

  		return false;
  	}

  	public static function import_types($xml)
  	{
  		$db = db::getInstance();
  		for($i=0; $i < $xml->length; $i++)
  		{
  			$id = self::get_xml_value($xml->item($i), 'ID');
  			$libel = self::get_xml_value($xml->item($i), 'LIBEL');

  			$t = self::get_type($id);
  			if($t)
  				$q = 'update '.db::dbname('fidelite_type').' set Libel="'.db::esc($libel).'", Date_Modification=CURRENT_TIMESTAMP
  							Where IdFideliteType='.(int)$id;
  			else
  				$q = 'insert into '.db::dbname('fidelite_type').' (IdFideliteType, Libel, Date_Creation, Date_Modification) values (
  							'.(int)$id.', "'.db::esc($libel).'", CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)';
  			$db->query($q);
  		}
  	}

  	public static function import_mvt_types($xml)
  	{
  		$db = db::getInstance();
  		for($i=0; $i < $xml->length; $i++)
  		{
  			$id = self::get_xml_value($xml->item($i), 'ID');
  			$libel = self::get_xml_value($xml->item($i), 'LIBEL');

  			$t = self::get_mvt_type($id);
  			if($t)
  			{
  				$q = 'update '.db::dbname('fidelite_mvt_type').' set Libel="'.db::esc($libel).'", Date_Modification=CURRENT_TIMESTAMP
  							Where IdFideliteMvtType='.(int)$id;
  			}
  			else
  			{
  				$q = 'insert into '.db::dbname('fidelite_mvt_type').' (IdFideliteMvtType, Libel, Date_Creation, Date_Modification) values (
  							'.(int)$id.', "'.db::esc($libel).'", CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)';
  			}
  			$db->query($q);
  		}
  	}

  	public static function get_type($id)
  	{
  		$db = db::getInstance();

			$req = 'select IdFideliteType as id, Libel
							from '.db::dbname('fidelite_type').'
							where IdFideliteType='.(int)$id;
  		return $db->query($req);
  	}

  	public static function get_types()
  	{
  		$db = db::getInstance();

			$req = 'select IdFideliteType as id, Libel
							from '.db::dbname('fidelite_type');
  		return $db->query($req);
  	}

  	public static function get_mvt_type($id)
  	{
  		$db = db::getInstance();

			$req = 'select IdFideliteMvtType as id, Libel
							from '.db::dbname('fidelite_mvt_type').'
							where IdFideliteMvtType='.(int)$id;
  		return $db->query($req);
  	}

  	public static function get_mvts_types()
  	{
  		$db = db::getInstance();

			$req = 'select IdFideliteMvtType as id, Libel
							from '.db::dbname('fidelite_mvt_type');
  		return $db->query($req);
  	}
	}
?>
