<?php
	require_once(GENERAL_CLASSES_DIR.'/table.php');
	
	define('TYPE_PREF_STR', 'STR');
	define('TYPE_PREF_INT', 'INT');
	
	define('PREF_VERSION', 'VERSION');
	
	class cloud_pref extends table
	{
		public static $table_name = 'cloud_pref';
		public static $field_list = array('Cle', 'Valeur_Str', 'Valeur_Int', 'Date_Modification');
		
		public static $config = null;
		protected static $prefs = null;
		
																	
		public static function init()
		{
			if(!self::$config)
			{
				self::$config[PREF_VERSION] = TYPE_PREF_STR;
			}
		}
		
		public static function load($force = false)
		{
			self::init();
			$db = db::getInstance();
			if($force || !self::$prefs)
			{
				self::$prefs = array();
				$req = 'select IdCloudPref as id, '.self::liste_champs(self::$table_name, self::$field_list).'
							from '.db::dbname(self::$table_name);
  			$prefs = $db->query($req);
  			
  			foreach($prefs as $p)
  			{
  				switch(self::$config[$p['Cle']])
  				{
  					case TYPE_PREF_STR:
  						self::$prefs[$p['Cle']] = $p['Valeur_Str'];
  						break;
  					case TYPE_PREF_INT:
  						self::$prefs[$p['Cle']] = $p['Valeur_Int'];
  						break;
  				}
  			}
			}
		}
		
		public static function get($cle)
		{
			self::load();
			$retour = null;
			
			if(isset(self::$prefs[$cle]))
  			$retour = self::$prefs[$cle];
  		
  		return $retour;
		}
	}
	
?>