<?php
	require_once(GENERAL_CLASSES_DIR.'/table.php');

	class ip_block extends table
	{
		public static $table_name = 'ip_block';
		public static $field_list = array('IP', 'Nb_Tentatives', 'Date_Tentative');

		public static function temps_avant_reconnexion()
		{
			$temps = 0;

			$db = db::getInstance();

			$req = 'select CURRENT_TIMESTAMP as local_time, DATE_ADD(Date_Tentative, INTERVAL (15*POW(2, Nb_Tentatives-3))SECOND) as date_reconnexion
							from '.db::dbname(self::$table_name).'
							where IP ="'.db::esc($_SERVER["REMOTE_ADDR"]).'"';
			$res = $db->query($req);

			$result = $res->fetch_array();
			if($result)
			{

				$ts_connexion = date_create_from_format('Y-m-d H:i:s', $result['date_reconnexion']);
				$ts_courant = date_create_from_format('Y-m-d H:i:s', $result['local_time']);

				if($ts_connexion && $ts_courant)
				{
					$temps = $ts_connexion->getTimestamp() - $ts_courant->getTimestamp();

					if($temps < 0) $temps = 0;
					if($temps > 3600) $temps = 3600;
				}
			}
			return $temps;
		}

		public static function get($ip)
		{
			$db = db::getInstance();
			$req = 'select '.self::liste_champs(self::$table_name, self::$field_list).'
							from '.db::dbname(self::$table_name).'
							where IP="'.db::esc($ip).'"';
			return $db->query($req);
		}

		public static function inc_echec()
		{
			$db = db::getInstance();
			$fiche = self::get($_SERVER["REMOTE_ADDR"]);
			if($fiche)
			{
				$req = 'update '.db::dbname(self::$table_name).' set
								Nb_Tentatives = Nb_Tentatives+1,
								Date_Tentative = CURRENT_TIMESTAMP
								Where IP="'.db::esc($_SERVER["REMOTE_ADDR"]).'"';
			}
			else
			{
				$req = 'insert into '.db::dbname(self::$table_name).'
								('.self::liste_champs(self::$table_name, self::$field_list).')
								values("'.db::esc($_SERVER["REMOTE_ADDR"]).'", 1, CURRENT_TIMESTAMP)';
			}
			$db->query($req);
			self::clear();
		}

		public static function ip_clear()
		{
			$db = db::getInstance();
			$db->query('delete from '.db::dbname(self::$table_name).'
									Where IP="'.db::esc($_SERVER["REMOTE_ADDR"]).'"');
		}

		public static function clear()
		{
			$db = db::getInstance();
			$db->query('delete from '.db::dbname(self::$table_name).'
				where Date_Tentative < DATE_SUB(CURRENT_TIMESTAMP, INTERVAL 1 DAY)');
		}
	}
?>
