<?php

define('NB_LIGNES_PAGINATION', 50);
define('NB_BATCH_SEND', 500);

abstract class table
{
	public static $table_name = '';
	public static $field_list = array();
	public static $saved_params = array();

	public static function liste_champs($table_name='', $liste_champs='')
	{
		$cn = get_called_class();
		if($table_name == '') $table_name = $cn::$table_name;
		if($liste_champs == '') $liste_champs = $cn::$field_list;

		return _DB_PREFIX_.$table_name.'.'.implode(','._DB_PREFIX_.$table_name.'.', $liste_champs);
	}

	public static function save_param($name, $value)
	{
		$cn = get_called_class();
		setcookie($cn.'_'.$name, $value);
		self::$saved_params[$cn.'_'.$name] = $value;
	}

	public static function get_param($name)
	{
		$cn = get_called_class();
		if(isset(self::$saved_params[$cn.'_'.$name]))
			$val = self::$saved_params[$cn.'_'.$name];
		else
			$val = Tools::getCookie($cn.'_'.$name);
		return $val;

	}

	public static function get_xml_value($xml, $tag_name)
	{
		$valeur = '';
		$tag = $xml->getElementsByTagName($tag_name);
		if($tag && $tag->length>0) $valeur = $tag->item(0)->nodeValue;
		return $valeur;
	}

	public static function new_log_batch($idEnreg, $suppr=false, $idMag=0)
	{
		$cn = get_called_class();
		$db = db::getInstance();
  		$db->query('insert into '.db::dbname('log_batch').' (DateLog, NomTable, IdEnregTable, Suppression_O_N, TargetMagId)
			values(CURRENT_TIMESTAMP, "'.db::esc($cn::$table_name).'",'.(int)$idEnreg.', '.($suppr?'1':'0').', '.(int)$idMag.')');
	}

	public static function from_log_batch($col_rech, $id_log_batch, $limit=NB_BATCH_SEND)
	{
		$cn = get_called_class();
		$db = db::getInstance();
		$table_name = db::dbname($cn::$table_name);

		$req = 'Select '.$cn::$unique_id.' as id, '.$cn::liste_champs().', max('.db::dbname('log_batch').'.IdLogBatch) as id_batch,
						'.db::dbname(magasin::$table_name).'.Cle as CleMagasin, '.db::dbname(magasin::$table_name).'.IdMagasin as IdMagasinCloud
						from '.$table_name.'
						left join '.db::dbname('log_batch').' on '.db::dbname('log_batch').'.IdEnregTable='.$table_name.'.'.$cn::$unique_id.' and '.db::dbname('log_batch').'.NomTable="'.db::esc($cn::$table_name).'"
						left join '.db::dbname(magasin::$table_name).' on '.db::dbname(magasin::$table_name).'.IdMagasin='.$table_name.'.IdMagasin
						where '.$table_name.'.'.$col_rech.' in (
								select IdEnregTable from '.db::dbname('log_batch').' where NomTable="'.db::esc($cn::$table_name).'" and IdLogBatch > '.(int)$id_log_batch.' and Suppression_O_N<=0
						) group by '.db::dbname('log_batch').'.IdEnregTable order by id_batch
						limit 0, '.(int)$limit;
		return $db->query($req);
	}

	public static function log_batch_suppression($id_log_batch, $limit=NB_BATCH_SEND)
	{
		$cn = get_called_class();
		$db = db::getInstance();
		return $db->query('select IdLogBatch as id_batch, IdEnregTable as id from '.db::dbname('log_batch').' where NomTable="'.db::esc($cn::$table_name).'" and IdLogBatch > '.(int)$id_log_batch.' and Suppression_O_N>0 limit 0, '.(int)$limit);
	}

	public static function add_query_pagination()
	{
		// il faut obtenir les infos de pagination
		$page = Tools::getValue('p');
		if($page != '') $page = (int)$page;
		else
			$page = (int)self::get_param('page');
		if($page < 0) $page = 0;

		self::save_param('page', $page);
		

		return (' limit '.($page * NB_LIGNES_PAGINATION).', '.NB_LIGNES_PAGINATION);
	}

	public static function found_rows()
	{
		$db = db::getInstance();
		$res = $db->query('SELECT FOUND_ROWS() as nb');
		while($row = $res->fetch_array())
			return $row['nb'];
	}

	public static function delete($id)
	{
		$cn = get_called_class();
		$db = db::getInstance();
		$table_name = db::dbname($cn::$table_name);
		if($db->query('delete from '.$table_name.' where '.$cn::$unique_id.' = '.$id))
		{
			$file_text = $table_name . " : deleted SUCCESS" . "\n";
			file_put_contents('logs/log_batch.txt', $file_text, FILE_APPEND);
		} else {
			$file_text = $table_name . " : deleted ERROR" . "\n";
			file_put_contents('logs/log_batch.txt', $file_text, FILE_APPEND);
		}
		
		self::new_log_batch($id, true);
	}
}

?>
