var ajaxDataRenderer;
var plot2;

$(document).ready(function () {
    DessineGraph();
});

function DessineGraph() {
    //var type = document.getElementById('select_type_chart').value;
    var type = 'line';
    var bg = type == 'line' ? 'transparent' : 'rgba(125, 125, 255, 0.35)';
    console.log(chart);
    if (chart != null) {
        chart.data.datasets.forEach((dataset) => {
            dataset.type = type;
            dataset.backgroundColor = bg;
        });

        chart.update();
    } else {
        chart = new Chart('graph_stat', {
            type: 'bar',
            data: {
                labels: plotLabels,
                datasets: [
                    {
                        label: 'Montant',
                        type: 'line',
                        pointRadius: 5,
                        pointBorderWidth: 1,
                        pointHoverRadius: 8,
                        borderColor: 'rgba(125, 125, 255)',
                        pointBackgroundColor: 'rgba(125, 125, 255)',
                        backgroundColor: bg,
                        borderWidth: 2,
                        data: plotData,
                        maxBarThickness: 35,
                        minBarLength: 2,
                    },
                ],
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                legend: {
                    display: false,
                },
                scales: {
                    x: {},
                    y: {
                        alignLegend: 'center',
                    },
                },
            },
        });
    }
}

function onCheckComparer(checked) {
    if (checked) {
        $('#collapse_comparer').collapse('show');
    } else {
        $('#collapse_comparer').collapse('hide');
    }
}
