<?php

    include('_init.php');
    require_once(GENERAL_CLASSES_DIR.'/magasin.php');
    require_once(GENERAL_CLASSES_DIR.'/config_synchro_mag.php');

    $datas = null;
    $ident_menu = 'magasin';

    if (Tools::getValue('resend') == 'true') {
        if (Tools::getValue('idMag') != null) {
            magasin::resend(Tools::getValue('idMag'), $id);
            header('location: client.php');
        } else {
            magasin::resend($id);
            header('location: magasin.php');
        }
    }

    // enregistrement
    if (Tools::isSubmit('btSave')) {
        $ok = magasin::save($id);

        $id_mag = (0 == $id) ? $ok : $id;

        /**
         * Boucle sur les infos présentes dans le POST
         *
         * Si ce n'est pas une info
         */
        foreach ($_POST as $key => $value) {
            if (false === strpos($key, 'info_synchro_')) {
                continue;
            }

            $is_checked   = ('on' === $value) ? 1 : 0;

            $libelle_info = explode('info_synchro_', $key)[1];

            $id_exists = config_synchro_mag::checkIfExists($id_mag, $libelle_info);

            if (0 === $id_exists) {
                config_synchro_mag::add([
                    "Id_Magasin"   => $id_mag,
                    "Libelle_Info" => $libelle_info,
                    "Is_Checked"   => $is_checked
                ]);
            } else {
                config_synchro_mag::updateIs_Checked($id_exists, $is_checked);
            }
        }

        if ($ok) {
            Tools::addMessage('Magasin enregistré avec succès.<p><strong>Vous devez saisir l\'IdMagasin Cloud à '.$ok.' dans les préférences de KinTPV</strong></p>');
            $id = '';
        } else {
            $datas = array();
            $datas[0] = magasin::get_current_values();
        }
    }

    // suppression
    if (Tools::getValue('delete')) {
        if (magasin::delete(Tools::getValue('delete'))) {
            Tools::addMessage('Magasin supprimé avec succès.');
        }
    }

    if (!$datas && $id !== 0) {
        $datas = magasin::get($id);
        $datas['liste_infos_synchro'] = json_decode(file_get_contents('../config/infos_synchro.json'));
        $datas['liste_categories_synchro'] = json_decode(file_get_contents('../config/categories_synchro.json'));

        if (null != $id) {
            $array_synchro_magasin = config_synchro_mag::getByMagasin($id);

            if ($array_synchro_magasin) {
                foreach ($array_synchro_magasin as $synchro_magasin) {
                    $datas['synchro_magasin'][$synchro_magasin['Libelle_Info']] = $synchro_magasin['Is_Checked'];
                }
            }
        }
    }

    if ($datas == 0 && $id != '') {
        $datas = array();
        $datas = magasin::get_current_values();
    }
    include('_display.php');
