<?php

    include('_init.php');
    require_once(GENERAL_CLASSES_DIR.'/magasin.php');
    require_once(GENERAL_CLASSES_DIR.'/config_synchro_mag.php');

    $datas = null;
    $ident_menu = 'magasin';

    /**
     * Récupération du fichier JSON contenant les différentes infos devant être affichées
     * dans le tableau de configuration des synhros
     */
    $datas['liste_infos_synchro'] = json_decode(file_get_contents('../config/infos_synchro.json'));
    $datas['liste_categories_synchro'] = json_decode(file_get_contents('../config/categories_synchro.json'));

    if (isset($_POST) && !empty($_POST)) {
        foreach ($datas['liste_infos_synchro'] as $info) {
            foreach ($_POST as $post_key => $post_value) {
                if (false !== strpos($post_key, 'check_' . $info->Libelle)) {
                    $is_checked = (false !== strpos($post_key, 'check_' . $info->Libelle) && 'on' === $post_value) ? 1 : 0;

                    $id_exists = config_synchro_mag::checkIfExists(explode('_mag_', $post_key)[1], $info->Libelle);

                    if (0 === $id_exists) {
                        config_synchro_mag::add([
                            "Id_Magasin"   => explode('_mag_', $post_key)[1],
                            "Libelle_Info" => $info->Libelle,
                            "Is_Checked"   => $is_checked
                        ]);
                    } else {
                        config_synchro_mag::updateIs_Checked($id_exists, $is_checked);
                    }
                }
            }
        }

        Tools::addMessage('Configuration des synchronisations enregistrée avec succès.');

        header('location: magasin.php');
    } else {
        $array_infos_synchro          = config_synchro_mag::get();

        foreach ($array_infos_synchro as $info) {
            $datas['infos_synchro']['info_' . $info['Libelle_Info'] . '_mag_' . $info['Id_Magasin']] = $info['Is_Checked'];
        }

        include('_display.php');
    }
