<!doctype html>

{include file='_header.tpl'}

<div id="article">
    <div class="bs-component">
        <h3>Articles</h3>
        
        <div class="row">
            <div class="col-sm-8">
                {include file='pagination.tpl'}
            </div>
            
            <div class="col-sm-2">
                {include file='inputs/select_page_size.tpl'}
            </div>

            <div class="col-sm-2 ms-5">
                <form name="rech_article" action="{$self}">
                    <div class="input-group">
                        <span class="input-group-btn">
                            <button type="button" class="btn btn-default" onclick="on_bn_clear_search()">
                                <span class="glyphicon glyphicon-remove"></span>
                            </button>
                        </span>

                        <input class="form-control" id="search" autocomplete="off" name="search" placeholder="Rechercher un article" value="{$search}">
                        
                        <span class="input-group-btn">
                            <button type="submit" class="btn btn-default" name="bt_rech_article">
                                <span class="glyphicon glyphicon-search"></span>
                            </button>
                        </span>
                    </div>
                </form>
            </div>    
        </div>

        <div class="liste">
            <table class="table table-bordered table-hover" data-bs-toggle="table">
                <thead>
                    <tr>
                        <th data-bs-sortable="true" data-bs-field="Id">#</th>
                        <th data-bs-sortable="true" data-bs-field="IdArticleMag">Id Article Magasin</th>
                        <th data-bs-sortable="true" data-bs-field="NomCatalogue">Nom Catalogue</th>
                        <th data-bs-sortable="true" data-bs-field="CodeBarres">Code-barres</th>
                        <th data-bs-sortable="true" data-bs-field="Magasin">Magasin</th>
                    </tr>
                </thead>
                
                <tbody>
                    {foreach $articles as $article}
                    <tr>
                        <td>{$article['IdArticle']}</td>
                        <td>{$article['IdArticle_magasin']}</td>
                        <td>{$article['NomCatalogue']}</td>
                        <td>{$article['CodeBarre']}</td>
                        <td>{$article['IdMagasinCloud']}</td>
                    </tr>
                    {/foreach}
                </tbody>
            </table>
            {include file='pagination.tpl'}
        </div>
    </div>

</div>

{include file='_footer.tpl'}    