{include file='_header.tpl'}

<script src="js/chart.js"></script>

<div id="dashboard" >
	<div class="row">
		<h3 class="col-sm-10">Tableau de bord</h3>

		<div id="div_display_type" class="col-sm-2" hidden>
			<select name="display_type" class="form-control" oninput="onChangeDisplayType()" id="display_type">
				<option value="graph" {if $displayMode == 'graph'} selected {/if}>Vue graphique</option>
				
				<option value="tab" {if $displayMode == 'tab'} selected {/if}>Vue tableau</option>

				<input type="hidden" name="display_mode" id="display_mode" value="{$displayMode}">
			</select>
		</div>

		<div id="context_magasin" class="col-sm-2">
			<select name="context_magasin" class="form-control" onchange="set_context(this);">
				<option value="0">Tous les magasins</option>
				
				{foreach $magasins as $m}
					<option value="{$m[0]}" {if $context_mag == $m[0]}selected{/if}>{$m[1]}</option>
				{/foreach}
			</select>
		</div>
	</div>

	<div class="row">
		<div class="col-md-5">
			<div class="btn-group btn-group-justified" role="group" aria-label="...">
				<a class="btn btn-default btn-xs{if $periode=='SEMAINE'} btn-success{/if}" onclick="relancer_stats('', '', 'SEMAINE');">Semaine</a>
				
				<a class="btn btn-default btn-xs{if $periode=='MOIS'} btn-success{/if}" onclick="relancer_stats('', '', 'MOIS');">Mois</a>
				
				<a class="btn btn-default btn-xs{if $periode=='ANNEE'} btn-success{/if}" onclick="relancer_stats('', '', 'ANNEE');">Année</a>
			</div>
		</div>

		<div class="col-md-2">
			<h6 class="text-center">Analyse<br />{$titre_stat}
			
			{if $mois}<select class="" id="select_mois" name="mois_analyse" onchange="relancer_stats('', '', '');">{foreach $mois as $m}<option value="{$m.num}" {if $mois_courant == $m.num}selected{/if}>{$m.libelle}</option> {/foreach}</select>{/if}
			
			{if $semaines}<select class="" id="select_semaine" name="semaine_analyse" onchange="relancer_stats('', '', '');">{foreach $semaines as $s}<option value="{$s}" {if $semaine_courante == $s}selected{/if}>{$s}</option> {/foreach}</select>{/if}
			
			<select id="select_annee" class="" name="annee_analyse" onchange="relancer_stats('', '', '');">{foreach $annees as $a}<option value="{$a}" {if $annee_courante == $a} selected {/if}>{$a}</option> {/foreach}</select>

			<div class="input-group" hidden>
				<input type="checkbox" onchange="onCheckComparer(this.checked);" hidden>
				<label for="" hidden>Comparer</label>
			</div>

			<div class="collapse" id="collapse_comparer" hidden>
				<select id="select_annee_comparer" name="comparer_annee_analyse">{foreach $annees as $a}<option value="{$a}" {if $annee_courante-1 == $a}selected{/if}>{$a}</option> {/foreach}</select>

				<button onclick="relancer_stats()">Comparer</button>
			</div>

		</h6>
			
		</div>
		
		<div class="col-md-5">
			<div class="btn-group btn-group-justified" role="group" aria-label="...">
				<a class="btn btn-default btn-xs{if $stat=='VenteTTC'} btn-success{/if}" onclick="relancer_stats('VenteTTC');">Vente TTC</a>
	
				<a class="btn btn-default btn-xs{if $stat=='VenteHT'} btn-success{/if}" onclick="relancer_stats('VenteHT');">Vente HT</a>

				<a class="btn btn-default btn-xs{if $stat=='Marge'} btn-success{/if}" onclick="relancer_stats('Marge');">Marge HT</a>
	
				<a class="btn btn-default btn-xs{if $stat=='Panier'} btn-success{/if}" onclick="relancer_stats('Panier');">Panier Moyen</a>

				<a class="btn btn-default btn-xs{if $stat=='Ticket'} btn-success{/if}" onclick="relancer_stats('Ticket');">Tickets</a>
			</div>
		</div>
	</div>

	<!--<select name="select_type_chart" id="select_type_chart" onChange="DessineGraph()">
		<option value="line">line</option>
		<option value="bar">bar</option>
	</select>-->

	<canvas id="graph_stat" style="width:100%; height: 35vh;" {if $displayMode != '' && $displayMode == "tab"} clas="hidden" {/if}></canvas>
		
	<div id="tab_stat" {if $displayMode != '' && $displayMode == "graph"} hidden {/if}>
		<br>
		
		<!-- TODO : Améliorer cet affichage -->

		<table class="table table-bordered">
			<thead>
				<tr>
					<th>{if $stat == "Ticket"}Nombre de tickets{else}Montant{/if}</th>
					
					<th width="50%">
						{if $regroup == "DATE"}Date{/if}
						
						{if $regroup == "JOUR"}Jour{/if}
						
						{if $regroup == "SEMAINE"}Semaine{/if}
						
						{if $regroup == "MOIS"}Mois{/if}
					</th>
				</tr>
			</thead>
			
			<tbody>
				{foreach $datas as $d}
					{if isset($d['Cumul'])}
						<tr>
							<td>{$d['Cumul']|string_format:"%.2f"}</td>
							
							<td>{$d['absice']}</td>
						</tr>
					{/if}
				{/foreach}
			</tbody>
		</table>
	</div>
		
	<div class="row">
		<div class="col-xs-12">
			<div class="btn-group btn-group-justified" role="group" aria-label="...">
				<a class="btn btn-default btn-xs{if $regroup=='DATE'} btn-success{/if}" onclick="relancer_stats('', 'DATE');">par Date</a>
				
				<a class="btn btn-default btn-xs{if $regroup=='JOUR'} btn-success{/if}" onclick="relancer_stats('', 'JOUR');">par Jour de semaine</a>
				
				<a class="btn btn-default btn-xs{if $regroup=='SEMAINE'} btn-success{/if}" onclick="relancer_stats('', 'SEMAINE');">par Semaine</a>
				
				<a class="btn btn-default btn-xs{if $regroup=='MOIS'} btn-success{/if}" onclick="relancer_stats('', 'MOIS');">par Mois</a>
			</div>
		</div>
	</div>

	<br>			
</div>

<hr />

<div class="row">
	<div class="col-xs-12 text-right"><a href="./" class="btn btn-default btn-xs">Quitter</a></div>
</div>

<script type="text/javascript">
	//let plotdata          = [[{foreach $datas as $d}["{$d.absice}", {$d.Cumul}, "{$d.absice}"],{/foreach}]];
	let plotLabels        = [{foreach $datas as $d}"{$d.absice}",{/foreach}];
	let plotData          = [{foreach $datas as $d}{$d.Cumul},{/foreach}];
	let legende_etiquette = "{$legende_etiquette} : ";
	var formatage         = "{$formatage}";
	var type_stat         = "{$stat}";
	var regroupement      = "{$regroup}";
	var periode           = "{$periode}";
	let chart = null;

	function relancer_stats(stat, regroup, per)
	{
		var annee      = '';
		var mois       = '';
		var semaine    = '';
		var url        = '';
		var comp_annee = '';
		
		if(!stat) stat = type_stat;
		if(!regroup) regroup = regroupement;
		if(!per) per = periode;

		if(per == 'MOIS') {
			var selectmois = $("#select_mois");

			if(selectmois.length > 0) {
				mois = $(selectmois).find('option:selected').val();
			}
		}

		if(per == 'SEMAINE') {
			var selectsemaine = $("#select_semaine");

			if(selectsemaine.length > 0) {
				semaine = $(selectsemaine).find('option:selected').val();
			}
		}

		annee = $("#select_annee").find('option:selected').val();
		displaymode = $("#display_mode").val();

		comp_annee = document.getElementById('select_annee_comparer').value;

		// memorise les dernieres recherches
		type_stat = stat;
		regroupement = regroup;
		periode = per;
		url = "{$self}?stat=" + stat + "&regroup=" + regroup + "&periode=" + per;
		
		if(annee != '') url += '&annee=' + annee;
		
		if(mois != '') url += '&mois=' + mois;
		
		if(semaine != '') url += '&semaine=' + semaine;
		
		if(displaymode != '') url += '&display=' + displaymode;

		if(comp_annee != '') url += '&comp_annee=' + comp_annee;
		
		document.location.href = url;
	}

	/**
	 * Methode onChangeDisplayType
	 * 
	 * Modifie l'affichage entre vue graphique et vue tableau
	 */
	function onChangeDisplayType(type) {
		if (!type) {
			type = document.getElementById('display_type').value;
		}

		if (type == 'graph') {
			document.getElementById('display_mode').value = 'graph';
		} else if (type == 'tab') {
			document.getElementById('display_mode').value = 'tab';
		}

		relancer_stats();
	}
</script>

<script class="include" type="text/javascript" src="js/dashboard.js"></script>
{include file='_footer.tpl'}
