<?php

include('_init.php');
require_once(GENERAL_CLASSES_DIR.'/ticket.php');
require_once(GENERAL_CLASSES_DIR.'/type_ligne.php');

$datas = null;
$rech = '';
$search = '';
$mag = (int)context::get_context('magasin');
$ident_menu = 'ticket';
$total_record = 0;

$reqData = (array) json_decode(trim(file_get_contents('php://input')));

if (!empty($reqData)) {
    ticket::save_param($reqData['saveAction'], $reqData['value']);
}

if ($id<=0) {
    // recherche ticket
    $rech = Tools::getValue('rech');
    if ($rech != '') {
        if ($rech == 'search') {
            $search = Tools::getValue('search');
        }

        ticket::save_param('rech', $rech);
        ticket::save_param('search', $search);
    } else {	// s'il n'y a pas de recherche, il y a peut etre une ancienne recherche memorisée
        $rech = ticket::get_param('rech');
        $search = ticket::get_param('search');
    }
}

if ($rech || $id<=0) {
    switch($rech) {
        case 'dujour':
            $datas = ticket::from_date(date('Y-m-d'));

            $depart_cumul = date('d/m/Y');
            $fin_cumul = date('d/m/Y');

            $total_record = ticket::found_rows();
            break;
        case 'tout':
            $depart_cumul = '00/00/0000';
            $fin_cumul = date('d/m/Y');
            $datas = ticket::get(0);

            $total_record = ticket::found_rows();
            $total_record = ticket::get_count();
            break;

        case 'search':
            break;

        case 'periode':
            $depart_cumul = Tools::getValue('date_depart');
            $fin_cumul = Tools::getValue('date_fin');

            if (!$depart_cumul || !$fin_cumul) {
                $depart_cumul = detail_ticket::get_param('date_depart');
                $fin_cumul = detail_ticket::get_param('date_fin');
            } else {
                detail_ticket::save_param('date_depart', $depart_cumul);
                detail_ticket::save_param('date_fin', $fin_cumul);
            }

            $datas = ticket::from_date($depart_cumul, $fin_cumul);

            $depart_cumul = Tools::dateEnToFr($depart_cumul);
            $fin_cumul = Tools::dateEnToFr($fin_cumul);

            $total_record = (int)ticket::found_rows();
            $total_record = ticket::get_count($depart_cumul, $fin_cumul);
            break;

        default:
            $datas = ticket::get(0);
            $depart_cumul = '00/00/0000';
            $fin_cumul = date('d/m/Y');
            $total_record = ticket::found_rows();
    }


    // On récupère le montant total des ventes pour la période de recherche.
    $totalMontant = ticket::getMontantTotal($depart_cumul, $fin_cumul);
    $smarty->assign('totalMontant', $totalMontant);
    $smarty->assign('date_depart_cumul', $depart_cumul);
    $smarty->assign('date_fin_cumul', $fin_cumul);
} else {
    $datas = ticket::get($id);
    $smarty->assign('types_ligne', type_ligne::liste());
    $smarty->assign('details', ticket::get_details($id));
}

$smarty->assign('page_number', ticket::get_param('page'));

$smarty->assign('context_mag', $mag);
$smarty->assign('search', $search);
$smarty->assign('rech', $rech);
$smarty->assign('dateDepart', '01/'.date('m/Y'));
$smarty->assign('dateFin', date('d/m/Y'));

$smarty->assign('total_record', $total_record);

include('_display.php');
