<?php

/**
* @author      JGE (Kinhelios)
* @copyright   2022 Kinhelios
* @link        https://www.kinhelios.com
* @updated     2022-04-14 - JGE
*/

require_once(GENERAL_CLASSES_DIR.'/cloud_pref.php');

class Kintpv_Log
{
    /**
     * Vérifie la présence du dossier de logs, et si ce n'est le cas, le créé
     */
    public static function check_dir()
    {
        if (! is_dir('logs')) {
            @mkdir('logs');
        }
    }

    /**
     * Insère une nouvelle ligne dans le fichier de logs
     *
     * @param string $text : Texte à insérer.
     */
    public static function log($text)
    {
        // on vérifie d'abord si le dossier des logs existe.
        self::check_dir();

        date_default_timezone_set('Europe/Paris');
        $value = date('d-m-Y H:i:s') . " - {$text}\n";

        file_put_contents('logs/kcloud.log', $value, FILE_APPEND);
    }

    /**
     * Insère les infos de début d'une synchro cloud
     */
    public static function start_log()
    {
        self::check_dir();

        $value = "---------- " . date('d-m-Y H:i:s') . " ----------\n";
        $value .= "Version KintpvCloud : " . cloud_pref::get(PREF_VERSION) . "\n";
        $value .= "Version PHP : " . phpversion() . "\n\n";

        file_put_contents('logs/kcloud.log', $value, FILE_APPEND);
    }

    /**
     * Insère la ligne de fin d'une synchro cloud dans le log
     */
    public static function end_log()
    {
        self::check_dir();

        $value = "-----------------------------------------\n";

        file_put_contents('logs/kcloud.log', $value, FILE_APPEND);
    }
}
