<?php

    require_once(GENERAL_CLASSES_DIR.'/table.php');
    require_once(GENERAL_CLASSES_DIR.'/ip_block.php');
    require_once(GENERAL_CLASSES_DIR.'/client.php');
    require_once(GENERAL_CLASSES_DIR.'/fidelite.php');
    require_once(GENERAL_CLASSES_DIR.'/kintpv_log.php');

    class magasin extends table
    {
        public static $table_name = 'magasin';
        public static $field_list = array('Nom', 'CodePostal', 'Cle', 'Identifiant', 'MotPasse', 'MaxEnvoiBatch');


        public static function get($id='')
        {
            $db = db::getInstance();

            $req = 'select IdMagasin as id, '.self::liste_champs(self::$table_name, self::$field_list).'
							from '.db::dbname(self::$table_name);
            if ($id != '') {
                $req.= ' where IdMagasin='.(int)$id;
            }

            $res = $db->query($req);

            if ($id == '') {
                return $res->fetch_all();
            } else {
                return $res->fetch_array();
            }
        }

        public static function identification($ident, $pass, $cle, &$erreur=null)
        {
            $id = 0;
            $erreur = ip_block::temps_avant_reconnexion();

            if ($erreur <= 0) {
                $db = db::getInstance();

                $req = 'select IdMagasin as id, '.self::liste_champs(self::$table_name, self::$field_list).'
								from '.db::dbname(self::$table_name).'
								where Identifiant="'.db::esc(utf8_encode(rawurldecode($ident))).'" And MotPasse=CONCAT("*", UPPER(SHA1(UNHEX(SHA1("'.db::esc(utf8_encode(rawurldecode($pass))).'"))))) And IdMagasin="'.db::esc(utf8_encode(rawurldecode($cle))).'"';
                $res = $db->query($req);

                $result = $res->fetch_array();

                if ($result) {
                    ip_block::ip_clear();
                    $id = $result['id'];
                } else {
                    ip_block::inc_echec();
                    $erreur = ip_block::temps_avant_reconnexion();
                }
            }

            return $id;
        }

        public static function add($values)
        {
            if (isset($values['Nom']) && isset($values['CodePostal'])) {
                $db = db::getInstance();
                $req = 'insert into '.db::dbname(self::$table_name).' (Nom, CodePostal, Cle, Identifiant, MotPasse, DateCreation, DateModification, MaxEnvoiBatch) values
				("'.db::esc($values['Nom']).'", "'.db::esc($values['CodePostal']).'", "'.db::esc($values['Cle']).'", "'.db::esc($values['Identifiant']).'", CONCAT("*", UPPER(SHA1(UNHEX(SHA1("'.db::esc($values['MotPasse']).'"))))), CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, '.db::esc($values['MaxEnvoiBatch']).')';

                $db->query($req);

                return $db->insert_id;
            } else {
                return false;
            }
        }

        public static function update($id, $values)
        {
            $db = db::getInstance();
            $req = 'update '.db::dbname(self::$table_name).' set
							Nom="'.db::esc($values['Nom']).'",
							CodePostal="'.db::esc($values['CodePostal']).'",
							Cle="'.db::esc($values['Cle']).'",
							Identifiant="'.db::esc($values['Identifiant']).'", ';
            if (isset($values['MotPasse']) && $values['MotPasse'] != '') {
                $req.='MotPasse= CONCAT("*", UPPER(SHA1(UNHEX(SHA1("'.db::esc($values['MotPasse']).'"))))), ';
            }
            $req.= 'DateModification=CURRENT_TIMESTAMP,';
            $req.= 'MaxEnvoiBatch='.(int)db::esc($values['MaxEnvoiBatch']).'
							where IdMagasin='.(int)$id;
            if ($db->query($req)) {
                return $id;
            }

            return false;
        }

        public static function save($id)
        {
            $values = self::get_current_values();

            if ($id <= 0) {
                return self::add($values);
            } else {
                return self::update($id, $values);
            }

            return false;
        }

        public static function delete($id)
        {
            $db = db::getInstance();
            $req = 'delete from '.db::dbname(self::$table_name).'
							where IdMagasin='.(int)$id;
            if ($db->query($req)) {
                return true;
            } else {
                return false;
            }
        }

        public static function get_current_values()
        {
            $values = array();
            $values['id'] = Tools::getValue('id');
            $values['Nom'] = Tools::getValue('Nom');
            $values['CodePostal'] = Tools::getValue('CodePostal');
            $values['Cle'] = Tools::getValue('Cle');
            $values['Identifiant'] = Tools::getValue('Identifiant');
            $values['MotPasse'] = Tools::getValue('MotPasse');
            $values['MaxEnvoiBatch'] = Tools::getValue('MaxEnvoiBatch');

            return $values;
        }

        public static function resend($idMag, $idClient = 0)
        {
            if ($idClient == 0) {
                $clients = client::get(0, false);

                foreach ($clients as $client) {
                    client::new_log_batch($client[0], false, $idMag);
                }

                $fidelites = fidelite::get(0);
                foreach ($fidelites as $fidelite) {
                    fidelite::new_log_batch($fidelite[0], false, $idMag);
                }
            } else {
                client::new_log_batch($idClient, false, $idMag);

                $fidelitesClient = fidelite::get_for_client($idClient);
                foreach ($fidelitesClient as $f) {
                    fidelite::new_log_batch($f['id'], false, $idMag);
                }
            }
        }
    }
