<?php
	include('_init.php');
	require_once(GENERAL_CLASSES_DIR.'/db.php');
	require_once(GENERAL_CLASSES_DIR.'/cmysql.php');
	require_once(GENERAL_CLASSES_DIR.'/tools.php');
	require_once(GENERAL_CLASSES_DIR.'/user.php');

	require(CLASSES_DIR.'/install.php');

	$install = new install();
	
	$step = (int)Tools::getValue('step');
	$next_step = 1;
	$error = '';
	$date = '';
	$dbserv = '';
	$mysqli = '';
	
	// il faut tester la version de php
	if ((version_compare(PHP_VERSION, '5.6.0') < 0 )) 
	{
		$step = -1;
		$error = 'PHP VERSION NOT SUPPORTED';
		$dbserv = $install->GetServerVersion();
		$mysqli = $install->CheckMySQLiExtension();

		$date = date("d-m-Y H:i:s");
		$file_text = "\n--- " . $date . " ---\n" . $error . "\nphpversion : " . phpversion() . "\nserver_info : " . $dbserv . "\nMySQLiExtension : " . $mysqli . "\n";
		file_put_contents('../logs/install_log.txt', $file_text, FILE_APPEND);
	}

	
	if($step == 0)
	{
		if($install->db_config_loaded)	// si nous arrivons � charger les infos, on teste la connexion
			$step = 2;
	}
	
	if($step == 1)
	{
		// r�cup�ration des informations de connexion envoy�es par l'utilisateur (souvent pour une premi�re installation
		$install->set_db_infos(Tools::getValue('host'), Tools::getValue('user'), Tools::getValue('password'), Tools::getValue('db_name'), Tools::getValue('db_prefix'));
		$step = 2;
	}
	if($step == 2)
	{
		if($install->test_db_connexion())
		{
			if($install->save_db_config())
				$step = 3;
			else
			{
				$error = 'DB CONFIG FILE ERROR';
				$next_step = -1; // impossible d'ecrire le fichier de config, on s'arrete la
			}
		}
		else
		{
			$error = 'DB CONNECTION ERROR';
			$next_step = 1;	// retourne demander le mot de passe
		}
	}
	
	if($step == 3)
	{
		$retour = $install->create_db();
		$errors = Tools::getErrors();
		if(count($errors) == 0)
		{
			// il faut vérifier qu'il existe déjé un utilisateur

			if(user::count() == 0)
				$next_step = 4;	// demande d'utilisateur
			else
				$next_step = 100; //(100 = termin�)
			
		}
		else
		{
			$next_step = -1;	// negatif c'est une erreur fatale
			$error = implode("\n", $errors);
		}
	}
	
	if($step == 4)
	{
		include(GENERAL_CONFIG_DIR.'/database.php');
	
		$values = array();
		$values['Email'] = Tools::getValue('Email');
		$values['MotPasse'] = Tools::getValue('MotPasse');

		if(user::add($values))
			$next_step = 100; 
		else
		{
			$next_step = 4;
			$error = 'USER CREATION ERROR';
		}
		
	}
	
	// retour XML
	Tools::header_xml();
	echo '<KINTPV>';
	echo '<NEXT_STEP>'.$next_step.'</NEXT_STEP>';
	echo '<ERROR>'.$error.'</ERROR>';
	echo '</KINTPV>';
	
?>