<?php

    define('GENERAL_CLASSES_DIR', 'classes');
    define('GENERAL_CONFIG_DIR', 'config');

    set_time_limit(0);

    include(GENERAL_CONFIG_DIR.'/database.php');

    require_once(GENERAL_CLASSES_DIR.'/db.php');
    require_once(GENERAL_CLASSES_DIR.'/cmysql.php');
    require_once(GENERAL_CLASSES_DIR.'/tools.php');
    require_once(GENERAL_CLASSES_DIR.'/magasin.php');

    // authentification du magasin
    $erreur = 0;
    $idmagasin = magasin::identification(Tools::getValue('id'), Tools::getValue('pw'), Tools::getValue('mag'), $erreur);
    Tools::header_xml();
    // $result = $res->fecth_assoc();

    if ($idmagasin > 0) {
        require_once(GENERAL_CLASSES_DIR.'/batch.php');

        echo "<SYNCHRO>\n";

        switch(Tools::getValue('action')) {
            case 'get':
                batch::send_batch_limit((int)Tools::getValue('log'), (int)$idmagasin);
                batch::deleteOldBatchs();
                break;
            case 'get_clients_dev':
                batch::send_batch_client(0, 1, 0, 0);
                break;
            case 'send':
                // lecture du contenu envoye
                if (isset($_GET["debug"])) {
                    $postdata = file_get_contents("batch.xml");
                } else {
                    $postdata = file_get_contents("php://input");
                }

                if ($postdata != '') {
                    batch::receive_batch($idmagasin, $postdata);
                }

                batch::flush_batch();

                break;
        }
        echo "</SYNCHRO>";
    } else {
        echo "<IDENTIFICATION>";
        echo "<ERREUR>ERREUR IDENTIFICATION</ERREUR>";
        echo "<RECONNEXION>".$erreur."</RECONNEXION>";
        echo "</IDENTIFICATION>";
    }
