<?php

    include('_init.php');
    require_once(GENERAL_CLASSES_DIR.'/ticket.php');
    require_once(GENERAL_CLASSES_DIR.'/detail_ticket.php');

    define('COOKIE_ANNEE_DASHBOARD', 'ANNEE_DASHBOARD');
    define('COOKIE_MOIS_DASHBOARD', 'MOIS_DASHBOARD');
    define('COOKIE_SEMAINE_DASHBOARD', 'SEMAINE_DASHBOARD');
    define('COOKIE_DISPLAY', 'DISPLAYMODE');

    $smarty->assign('legende_etiquette', 'Montant');
    $smarty->assign('formatage', '%.02f');

    $stat = Tools::getValue('stat');
    $regroup = Tools::getValue('regroup');
    $periode = Tools::getValue('periode');

    $titre_stat = '';
    $ident_menu = 'dashboard';
    $tab_mois = array();
    $tab_semaines = array();

    $annees = ticket::liste_annees();

    if (!in_array(date('Y'), $annees)) {
        $annees[] = date('Y');
    }

    // gestion de l'année de travail (celle passée en paramètre ou l'année courante par defaut)
    if (Tools::getValue('annee')!= '') {
        $annee_courante = Tools::getValue('annee');
        setcookie(COOKIE_ANNEE_DASHBOARD, $annee_courante);
    } else {
        $annee_courante = Tools::getCookie(COOKIE_ANNEE_DASHBOARD);
    }

    if ($annee_courante == '') {
        $annee_courante = date('Y');
    }

    if (Tools::getValue('mois') != '') {
        $mois_courant = Tools::getValue('mois');
        setcookie(COOKIE_MOIS_DASHBOARD, $mois_courant);
    } else {
        $mois_courant = Tools::getCookie(COOKIE_MOIS_DASHBOARD);
    }

    if ($mois_courant == '') {
        $mois_courant = date('m');
    }

    if (Tools::getValue('semaine') != '') {
        $semaine_courante = Tools::getValue('semaine');
        setcookie(COOKIE_SEMAINE_DASHBOARD, $semaine_courante);
    } else {
        $semaine_courante = Tools::getCookie(COOKIE_SEMAINE_DASHBOARD);
    }

    if ($semaine_courante == '') {
        $semaine_courante = date('W');
    }

    if (Tools::getValue('comp_annee') != '') {
    }

    $displayMode = 'graph';

    if (Tools::getValue('display') != '') {
        $displayMode = Tools::getValue('display');
        setcookie(COOKIE_DISPLAY, $displayMode);
    } else {
        $displayMode = Tools::getCookie(COOKIE_DISPLAY);
    }
    if ($displayMode == '') {
        $displayMode = "graph";
    }

    switch($regroup) {
        case 'JOUR':
            break;
        case 'SEMAINE':
            break;
        case 'MOIS':
            break;
        default:
            $regroup = 'DATE';
    }

    switch($periode) {
        case 'SEMAINE':
            Tools::start_end_week($annee_courante, $semaine_courante, $date_depart, $date_fin);
            $titre_stat = 'Semaine ';
            for ($i=1; $i <= 52; $i++) {
                $tab_semaines[] = $i;
            }
            break;
        case 'MOIS':
            $date_depart = $annee_courante.'-'. str_pad($mois_courant, 2, '0', STR_PAD_LEFT) .'-01';

            // il faut connaitre le nombre de jours du mois

            /**
             *! MàJ JG le 03/01/2023 -> Utilisation de cal_days_in_month qui est bien plus sûre que l'ancien appel
             *! qui pouvait retourner le mauvais nombre de jours pour un mois, qui causait une erreur dans le dashboard
             *
             * ? Exemple : 31 jours retournés pour le mois de Juin
             */
            $nb_jours = cal_days_in_month(CAL_GREGORIAN, $mois_courant, $annee_courante);

            $date_fin = $annee_courante.'-'.str_pad($mois_courant, 2, '0', STR_PAD_LEFT).'-'.str_pad($nb_jours, 2, '0', STR_PAD_LEFT);

            // inutile de compléter le titre, le formulaire est assez explicite
            $titre_stat = ''; //'Mois '.Tools::getMonthName($mois_courant);
            for ($i=1; $i <= 12; $i++) {
                $tab_mois[] = array('num'=> $i, 'libelle' => Tools::getMonthName($i));
            }

            break;
        default:
            $date_depart = $annee_courante.'-01-01';
            $date_fin = $annee_courante.'-12-31';
            $periode = 'ANNEE';
            $titre_stat = 'Année';//.$annee_courante;
            break;
    }

    $legende = 'Montant';
    $formatage = '%.02f';

    $mag = (int)context::get_context('magasin');

    switch($stat) {
        case 'Marge':
            $datas = detail_ticket::stats_marge($date_depart, $date_fin, $regroup, $mag);
            break;
        case 'VenteTTC':
            $datas = detail_ticket::stats_vente($date_depart, $date_fin, $regroup, 'TTC', $mag);
            break;
        case 'Panier':
            $datas = ticket::panier_moyen($date_depart, $date_fin, $regroup, $mag);
            break;
        case 'Ticket':
            $datas = ticket::nb_tickets($date_depart, $date_fin, $regroup, $mag);
            $legende = 'Nombre';
            $formatage = '%d';
            break;
        default:
            $datas = detail_ticket::stats_vente($date_depart, $date_fin, $regroup, 'HT', $mag);
            $stat = 'VenteHT';
    }

    if ($regroup == 'JOUR' && $datas) {
        // il faut reformater le resultat pour afficher les jours de semaine
        while ($row = $datas->fetch_array()) {
            for ($i=0; $i < count($row); $i++) {
                $row['absice'] = Tools::GetDayName($row['absice']);
            }
        }
    }
    if ($regroup == 'MOIS' && $datas) {
        while ($row = $datas->fetch_array()) {
            for ($i=0; $i < count($row); $i++) {
                $row['absice'] = Tools::getMonthName($row['absice']);
            }
        }
    }

    $smarty->assign('mois', $tab_mois);
    $smarty->assign('mois_courant', $mois_courant);

    $smarty->assign('semaines', $tab_semaines);
    $smarty->assign('semaine_courante', $semaine_courante);

    $smarty->assign('annees', $annees);
    $smarty->assign('annee_courante', $annee_courante);
    $smarty->assign('context_mag', $mag);
    $smarty->assign('stat', $stat);
    $smarty->assign('regroup', $regroup);
    $smarty->assign('periode', $periode);
    $smarty->assign('legende_etiquette', $legende);
    $smarty->assign('formatage', $formatage);
    $smarty->assign('titre_stat', $titre_stat);
    $smarty->assign('displayMode', $displayMode);


    include('_display.php');
