<?php

    include('_init.php');
    require_once(GENERAL_CLASSES_DIR.'/detail_ticket.php');
    $datas = null;
    $rech = '';
    $search = '';
    $ident_menu = 'detail_ticket';
    $cumuls = '';

    $reqData = (array) json_decode(trim(file_get_contents('php://input')));

    if (!empty($reqData)) {
        detail_ticket::save_param($reqData['saveAction'], $reqData['value']);
    }


    if ($id<=0) {
        // recherche ticket
        $rech = Tools::getValue('rech');
        if ($rech != '') {
            detail_ticket::save_param('rech', $rech);
        } else {	// s'il n'y a pas de recherche, il y a peut etre une ancienne recherche memorisée
            $rech = detail_ticket::get_param('rech');
        }
    }

    if ($rech) {
        switch($rech) {
            case 'dujour':
                $depart_cumul = date('d/m/Y');
                $fin_cumul = $depart_cumul;
                $datas = detail_ticket::from_date(date('Y-m-d'));
                break;
            case 'periode':
                detail_ticket::save_param('rech', $rech);
                $depart_cumul = Tools::getValue('date_depart');
                $fin_cumul = Tools::getValue('date_fin');

                if (!$depart_cumul || !$fin_cumul) {
                    $depart_cumul = detail_ticket::get_param('date_depart');
                    $fin_cumul = detail_ticket::get_param('date_fin');
                } else {
                    detail_ticket::save_param('date_depart', $depart_cumul);
                    detail_ticket::save_param('date_fin', $fin_cumul);
                }
                $datas = detail_ticket::from_date(db::date_to_db($depart_cumul), db::date_to_db($fin_cumul));
                $total_record = detail_ticket::found_rows();

                $depart_cumul = Tools::dateEnToFr($depart_cumul);
                $fin_cumul = Tools::dateEnToFr($fin_cumul);
                break;
            case 'tout':
                $depart_cumul = '00/00/0000';
                $fin_cumul = date('d/m/Y');
                $datas = detail_ticket::get(0);
                $total_record = detail_ticket::found_rows();
        }

        $cumuls = detail_ticket::last_cumul();

        $row = ($cumuls != false) ? $cumuls->fetch_array() : [];

        $smarty->assign('rech', $rech);
        $smarty->assign('cumuls', $row);
    } else {
        // par défaut on affiche tous les details de tickets du mois en cours
        $mois = mktime(0, 0, 0, date('m'), 1, date('Y'));
        $nb_jours = date("t", $mois);

        $depart_cumul = '01/'.date('m/Y');
        $fin_cumul = date('d/m/Y');

        $datas = detail_ticket::from_date(date('Y-m').'-01', date('Y-m').'-'.$nb_jours);
        $smarty->assign('details', ticket::get_details($id));
    }

    $smarty->assign('page_number', detail_ticket::get_param('page'));

    $smarty->assign('context_mag', (int)context::get_context('magasin'));

    $smarty->assign('types_ligne', type_ligne::liste());
    $smarty->assign('date_depart_cumul', $depart_cumul);
    $smarty->assign('date_fin_cumul', $fin_cumul);

    $smarty->assign('dateDepart', '01/'.date('m/Y'));
    $smarty->assign('dateFin', date('d/m/Y'));

    include('_display.php');
