/**
 * @author      JGE (Kinhelios)
 * @copyright   2022 Kinhelios
 * @link        https://www.kinhelios.com
 * @updated     2022-12-27 - JGE
 */

$(function () {
    var inputStart = document.getElementById('div_start_date');

    var startDate = document.getElementById('periode_start_date').value;
    var splitStartDate = startDate.split('/');

    startDate =
        splitStartDate[2] + '-' + splitStartDate[1] + '-' + splitStartDate[0];

    $('#div_start_date').datetimepicker({
        pickTime: false,
    });

    $('#div_end_date').datetimepicker({
        pickTime: false,
        useCurrent: false, //Important! See issue #1075,
        startDate: new Date(startDate),
    });

    $('#div_start_date').on('changeDate', function (e) {
        $('#div_end_date')
            .data('datetimepicker')
            .setStartDate(new Date(e.date));
    });

    $('#div_end_date').on('changeDate', function (e) {});
});

function submitPeriode() {
    var startDate = document.getElementById('periode_start_date').value;
    var splitStartDate = startDate.split('/');

    document.getElementById('periode_start_date').value =
        splitStartDate[2] + '-' + splitStartDate[1] + '-' + splitStartDate[0];

    var endDate = document.getElementById('periode_date_fin').value;
    var splitEndDate = endDate.split('/');

    document.getElementById('periode_date_fin').value =
        splitEndDate[2] + '-' + splitEndDate[1] + '-' + splitEndDate[0];

    document.getElementById('form_modal_periode').submit();
}
