<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <title>KinTPV Cloud</title>
        <meta name="viewport" content="width=device-width, initial-scale=2, maximum-scale=2" user-scalable="no">
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        
        <link rel="stylesheet" href="../bootstrap/css/bootstrap.yeti.min.css" media="screen">
        <link rel="stylesheet" href="../bootstrap/css/bootstrap-datetimepicker.min.css" media="screen">
        <link rel="shortcut icon" type="image/x-icon" href="../img/logo_kintpv_cloud_8.ico" />
        <link rel="stylesheet" href="../css/custom.css" media="screen">
        <link rel="stylesheet" href="../css/admin.css" media="screen">

        <link rel="apple-touch-startup-image" />
        
        <link rel="stylesheet" href="../css/font-awesome/css/all.min.css" media="screen">
        <script type="text/javascript" src="js/jquery.min.js"></script>
        <script type="text/javascript" src="js/jquery.cookie.js"></script>
        <script type="text/javascript" src="js/scripts.js"></script>
    </head>
    <body style="max-height: max-content;">

        <div id="wrapper">
            <nav class="navbar navbar-default navbar-fixed-top" role="navigation">
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-principale" aria-expanded="false">
                        <span class="sr-only">Toggle navigation</span>
                        
                        <span class="icon-bar"></span>
                        
                        <span class="icon-bar"></span>
                        
                        <span class="icon-bar"></span>
                    </button>
                    <a class="navbar-brand" href="dashboard.php"><img src="../img/logo_kintpv_cloud_8_mini.png">KinTPV Cloud</a>
                </div>
                <div class="navbar-collapse collapse" id="navbar-main">
                    <ul class="nav navbar-nav navbar-right">
                        <li><a href="http://www.kintpv.com/" target="_blank">Version {$cloud_version}</a></li>
                        <li id="logout_button"><a href="index.php?logout=1"><i class="fas fa-power-off"></i></a></li>
                    </ul>
                </div>
                {if $page!=''}
                    <div class="collapse navbar-collapse navbar-ex1-collapse" id="navbar-principale">
                        <ul class="nav navbar-nav side-nav">
                            <li class="visible-xs">
                                <a href="index.php?logout=1"><i class="fas fa-power-off"></i> Deconnexion</a>
                            </li>
                            
                            <li {if $page=='dashboard'}class="active"{/if}>
                                <a href="dashboard.php"><i class="fas fa-chart-line"></i> Tableau de bord</a>
                            </li>
                            
                            <li {if $page=='user'}class="active"{/if}>
                                <a href="user.php"><i class="fas fa-users"></i> Utilisateurs</a>
                            </li>
                            
                            <li {if $page=='magasin'}class="active"{/if}>
                                <a href="magasin.php"><i class="fas fa-university"></i> Magasins</a>
                            </li>
                            
                            <li {if $page=="client"}class="active"{/if}>
                                <a href="client.php"><i class="fas fa-child"></i> Clients</a>
                            </li>

                            <li {if $page=="article"}class="active"{/if}>
                                <a href="article.php"><i class="fa fa-table"></i> Articles</a>
                            </li>
                            
                            <li {if $page=='ticket'}class="active"{/if}>
                                <a href="ticket.php"><i class="fas fa-file"></i> Tickets</a>
                            </li>
                            
                            <li {if $page=='detail_ticket'}class="active" {/if}>
                                <a href="detail_ticket.php"><i class="fas fa-list"></i> Details de ticket</a>
                            </li>
                            
                            <li {if $page=='logs'}class="active"{/if}>
                                <a href="logs.php"><i class="fas fa-server"></i> Logs</a>
                            </li>
                            
                            <li {if $page=='batchs'}class="active"{/if}>
                                <a href="batchs.php"><i class="fas fa-clone"></i> Batchs</a>
                            </li>
                            
                            <li {if $page=="preferences"}class="active"{/if}>
                                <a href="preferences.php"><i class="fas fa-cogs"></i> Préférences</a>
                            </li>
                            
                            <li {if $page=='update'}class="active"{/if} id="badge_new_version" style="display: none;">
                                <a href="cloud_update.php"><i class="fas fa-cloud-download-alt"></i> Nouvelle version</a>
                            </li>

                        </ul>
                    </div>
                {/if}
            </nav>
            <div id="page-wrapper">
                <script type="text/javascript" src="js/checkversion.js"></script>
                <script type="text/javascript">
                    $( document ).ready(function() {
                        CheckVersionCloud("{$cloud_version}");
                    });
                </script>
