{include file='_header.tpl'}
<div id="user">
	<div class="bs-component">
		<h3>Magasins</h3>

		{include file='_errors.tpl'}

		{if $id != ''}
			<div class="edit">
				<form class="form-horizontal" name="form_edit" action="{$self}" method="post">
					<input type="hidden" name="id" value="{$id}" />
					
					<div class="row">
						<div class="col-sm-6">
							<div class="form-group">
								<label class="col-sm-4 control-label " for="inputNom">Nom</label>
								
								<div class="col-sm-8">

									<input type="text" class="form-control" id="inputNom" name="Nom" placeholder="" {if isset($Nom)} value="{$Nom}" {/if} required>
								</div>
							</div>
						
							<div class="form-group">
								<label class="col-sm-4 control-label" for="inputCP">Code postal</label>
								
								<div class="col-sm-8">
									<input type="text" class="form-control" id="inputCP" name="CodePostal" placeholder="" {if isset($CodePostal)} value="{$CodePostal}" {/if} required>
								</div>
							</div>
						
							<div class="form-group">
								<label class="col-sm-4 control-label" for="inputIndentifiant">Identifiant</label>
								
								<div class="col-sm-8">
									<input type="text" class="form-control" id="inputIndentifiant" name="Identifiant" placeholder="" {if isset($Identifiant)} value="{$Identifiant}" {/if} required>
								</div>
							</div>
						
							<div class="form-group">
								<label class="col-sm-4 control-label" for="inputMotPasse">Mot de passe</label>
								
								<div class="col-sm-8">
									<input type="password" class="form-control" id="inputMotPasse" name="MotPasse" placeholder="" value="" {if $id<=0}required{/if}>
								</div>
							</div>
						
							<div class="form-group">
								<label class="col-sm-4 control-label" for="inputMaxEnvoiBatch">Nombre max de batchs à envoyer</label>
								
								<div class="col-sm-8">
									<input type="number" min="1" class="form-control" id="inputMaxEnvoiBatch" name="MaxEnvoiBatch" placeholder="Valeur par défaut : 500" {if isset($MaxEnvoiBatch)} value="{$MaxEnvoiBatch}" {/if} required>
								</div>
							</div>
						</div>

						<div class="col-sm-6">
							<table class="table table-striped table-bordered">
								<thead>
									<tr>
										<th class="text-center">Info</th>
										
										<th class="text-center">
											Synchro Oui/Non<br>
											<a href="#" style="font-weight: 500;" onclick="checkAll({$id});">Cocher/Décocher Tout</a>
										</th>
									</tr>
								</thead>

								<tbody>
									{if $liste_infos_synchro}
										{foreach $liste_categories_synchro as $categorie}
											<tr>
												<th colspan="2" >
													{$categorie->Nom}
												</th>
											</tr>

											{foreach $liste_infos_synchro as $info}
											{if $info->Categorie == $categorie->Nom}
												<tr style="background-color: {$categorie->Couleur}";">
													<td class="text-center">{$info->LibelleDisplay}</td>
													
													<td class="text-center">
														{$is_checked = (isset($synchro_magasin["{$info->Libelle}"]) && $id != 0) ? $synchro_magasin["{$info->Libelle}"] : 0}
														
														<input type="checkbox" class="input_check_magasin check_magasin_{$id}" name="info_synchro_{$info->Libelle}"
														
														{if $is_checked == 1} checked {/if}>
													</td>
												</tr>
											{/if}
											{/foreach}
										{/foreach}
									{/if}
								</tbody>
							</table>
						</div>
					</div>
					
					<hr/>

					<div class="text-right">
						<a href="{$self}" class="btn btn-default">Annuler</a>
						
						<input type="submit" class="btn btn-primary" name="btSave" value="Valider" />
					</div>
				</form>
			</div>
		{else}
			<div class="liste">
				<table class="table table-bordered table-hover">
					<thead>
						<tr>
							<th data-field="Id" data-sortable="true">#</th>
							
							<th data-field="Nom" data-sortable="true">Nom</th>
							
							<th data-field="CP" data-sortable="true">Code postal</th>
							
							<th data-field="Action" data-sortable="false">Action</th>
						</tr>
					</thead>
					
					<tbody>
						{foreach $datas as $d}
							{if is_string($d[0]) == true}
								<tr>
									<td>{$d[0]}</td>
									
									<td>{$d[1]}</td>
									
									<td>{$d[2]}</td>
									
									<td>
										<a href="{$self}?id={$d[0]}" class="btn btn-xs btn-default" title="Éditer"><span class="glyphicon glyphicon-pencil"></span></a>
										
										<a href="" data-toggle="modal" data-target="#modalConfirmRenvoi" onclick="onModalRenvoi('{$d[1]}', '{$d[0]}')" class="btn btn-xs btn-default" title="Tout renvoyer à ce magasin"><span class="glyphicon glyphicon-share-alt"></span></a>
										
										<a href="javascript:delete_fiche('{$self}',{$d[0]});" class="btn btn-xs btn-default" title="Supprimer ce magasin"><span class="glyphicon glyphicon-trash"></span></a>
									</td>
								</tr>
							{/if}
						{/foreach}
					</tbody>
				</table>
				
				<hr />
				
				<div class="row">
					<div class="col-xs-1">
						<a href="{$self}?id=0" class="btn btn-primary btn-xs"><span class="glyphicon glyphicon-plus"></span> Ajouter</a>
					</div>
					
					<div class="col-xs-5">
						<a href="sync_magasins.php" class="btn btn-default btn-xs"><span class="glyphicon glyphicon-cog"></span> Synchros</a>
					</div>
					
					<div class="col-xs-6 text-right">
						<a href="./" class="btn btn-default btn-xs">Quitter</a>
					</div>
				</div>
			</div>
		{/if}
	</div>
</div>

<!--
 --- MODAL CONFIRM RENVOI
 -->
<div class="modal fade" id="modalConfirmRenvoi" role="dialog">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h4>Renvoi des données</h4>
			</div>

			<div class="modal-body">
				Désirez-vous réenvoyer toutes les données des clients et fidélités au magasin <b id="renvoiNomMagasin"></b> ?
				
				<br>
				
				<h6>L'envoi sera effectué lors de la prochaine synchronisation du magasin.</h6>
			</div>

			<div class="modal-footer">
				<a class="btn btn-default" data-dismiss="modal">Fermer</a>
				
				<a href="" id="btnConfirmRenvoi" class="btn btn-primary">Confirmer</a>
			</div>
		</div>
	</div>
</div>

<script type="text/javascript">
	function onModalRenvoi(nom, id) {
		document.getElementById('renvoiNomMagasin').innerText = nom;
		btnConfirmRenvoi.href = "{$self}?resend=true&id="+ id;
	}

	/**
	 * Coche / Décoche toutes les checkbox des infos de synchro du magasin
	 * 
	 * param [string] id : ID du magasin en cours d'édition. 
	 */
	function checkAll(id) {
		var checkBoxes   = document.querySelectorAll('.check_magasin_'+id); // Checkboxes des infos à synchro du magasin.
		var nbCheckboxes = checkBoxes.length; // Nombre de checkboxes trovuées dans le formulaire.
		var nbChecked    = document.querySelectorAll('.check_magasin_'+id+':checked').length; // Nombre de checkboxes cochées.

		// Si toutes les checkbox ne sont pas cochées, on les coche toutes, sinon on les décoche toutes.
		if (nbChecked < nbCheckboxes) {
			checkBoxes.forEach(element => {
				element.checked = true;
			});
		} else {
			checkBoxes.forEach(element => {
				element.checked = false;
			});
		}
	}

	/**
	 * Ajoute un handle sur l'événement de validation du formulaire
	 * Cela permet de pouvoir agir sur le formulaire avant son envoi au serveur,
	 *
	 * On y ajoute des champs invisibles pour les checkbox décochées, permettant d'envoyer toutes les valeurs
	 * dans la requête.
	 */
	document.addEventListener('submit', (event) => {
		document.querySelectorAll('.input_check_magasin').forEach(checkbox => {
			if (false === checkbox.checked) {
				var hiddenInput   = document.createElement('input'); // Création d'un objet input.
				hiddenInput.type  = 'text';      // Champ caché de l'interface.
				hiddenInput.name  = checkbox.name; // On applique le nom de la checkbox sur le nouveau champ.
				hiddenInput.value = 'off';         // Valeur à 'off' pour dire que la checkbox est décochée.

				checkbox.name = ''; // On vide le nom de la checkbox pour éviter les doublons dans le $_POST.

				document.querySelector('form').appendChild(hiddenInput); // Ajout du champ dans le formulaire.
			}
		});
	});
</script>

{include file='_footer.tpl'}