{include file='_header.tpl'}

<div id="user">

    <div class="bs-component">
        <form action="{$self}" method="POST">
            <h3>Configurer la synchronisation</h3>
            <h5>Sélectionner les autorisations de synchronisation pour chaque magasin</h5>

            <input type="hidden" name="csrf_token" value="0">

            <div class="liste">
                <table class="table table-striped table-bordered">
                    <thead>
                            <tr>
                                <th class="text-center"></th>
                            
                                {foreach $magasins as $magasin}
                                    <th class="text-center">{$magasin[1]}</th>
                                {/foreach}
                            </tr>
                    </thead>

                    <tbody>
                        <tr>
                            <td></td>
                            {foreach $magasins as $magasin}
                                <td class="text-center"><a href="#" onclick="check_all({$magasin[0]});">Cocher/Décocher Tout</a></td>
                            {/foreach}
                        </tr>

                        {foreach $datas['liste_categories_synchro'] as $categorie}
                            <tr>
                                <th colspan="3">
                                    {$categorie->Nom}
                                </th>
                            </tr>

                            {foreach $datas['liste_infos_synchro'] as $info}
                                {if $info->Categorie == $categorie->Nom}
                                    <tr style="background-color: {$categorie->Couleur};">
                                        <td width="25%">{$info->LibelleDisplay}</td>

                                        {foreach $magasins as $magasin}
                                            <td class="text-center">
                                                {$index = (isset($datas["infos_synchro"]["info_{$info->Libelle}_mag_{$magasin[0]}"])) ? $datas["infos_synchro"]["info_{$info->Libelle}_mag_{$magasin[0]}"] : 0}
                                                <input type="checkbox" name="check_{$info->Libelle}_mag_{$magasin[0]}" class="check_magasin_{$magasin[0]}"
                                                {if $index == 1} checked {/if}>
                                            </td>
                                        {/foreach}
                                    </tr>
                                {/if}
                            {/foreach}
                        {/foreach}
                    </tbody>
                </table>       
            </div>

            <hr>

            <div class="row">
                <div class="col-xs-6 text-left">
                    
                </div>

                <div class="col-xs-6 text-right">
                    <a class="btn btn-default" href="magasin.php"> Quitter</a>
                    
                    <button class="btn btn-primary" type="button" onclick="submit_sync_magasin_form();"> <span class="glyphicon glyphicon-floppy-disk"></span> Enregistrer</button>
                </div>
            </div>      
        </form>
    </div>
</div>

{include file='_footer.tpl'}

<script type="text/javascript">
    function check_all(id)
    {
        var checkboxes = document.querySelectorAll('.check_magasin_'+id);
        var nb_checkboxes = checkboxes.length;
        var nb_checked = document.querySelectorAll('.check_magasin_'+id+':checked').length;

        if (nb_checked < nb_checkboxes) {
            checkboxes.forEach(element => {
                element.checked = true;
            });
        } else {
            checkboxes.forEach(element => {
                element.checked = false;
            });
        }
    }

    /**
     * Validation du formulaire de configuration de la synchronisation des magasins
     */
    function submit_sync_magasin_form()
    {
        // On boucle sur tous les checkbox du formulaire.
        document.querySelectorAll('input[type=checkbox]').forEach(checkbox => {
            /**
             * Si la checkbox n'est pas cochée, on la remplace par un champ caché avec le même nom
             * Cela permet de récupérer la valeur dans le $_POST une fois dans le script PHP
             * */
            if (false === checkbox.checked) {
                var hidden_input = document.createElement('input');
                hidden_input.type  = 'hidden';
                hidden_input.name  = checkbox.name;
                hidden_input.value = 'off';

                document.querySelector('form').appendChild(hidden_input);
                
                //On enleve le nom de la checkbox pour s'assurer que la valeur ne soit pas envoyée.
                checkbox.name = '';
            }
        });

        // Validation du formulaire.
        document.querySelector('form').submit();
    }
</script>