<?php


/**
* @author      JG (Kinhelios)
* @copyright   2023 Kinhelios
* @link        https://www.kinhelios.com
* @updated     2023-03-03 - JG
*/

require_once(GENERAL_CLASSES_DIR . '/config_synchro_mag.php');
require_once(GENERAL_CLASSES_DIR . '/table.php');

class article extends table
{
    public static $table_name = 'article';

    public static $unique_id = 'IdArticle';

    public static $field_list = array(
        'IdArticle',
        'IdArticle_magasin',
        'IdMagasinCloud',
        'NomCatalogue',
        'CodeBarre',
        'IdMagOrgModif',
        'Date_Creation',
        'Date_Modification',
    );

    public static $fieldTypes = array(
        'int',
        'int',
        'int',
        'string',
        'string',
        'int',
        'string',
        'string',
    );

    public static function get($id, $pagination = true)
    {
        $db = db::getInstance();

        $req = 'select ' . ($pagination ? 'SQL_CALC_FOUND_ROWS ' : '') .self::liste_champs(self::$table_name, self::$field_list)
        . ' from ' . db::dbname(self::$table_name);

        $req .= ($id <= 0) ? '' : ' where ' . self::$unique_id . ' = ' . $id;

        if ($pagination && (article::get_param('pageSize') == null || article::get_param('pageSize') != 'All')) {
            $pageSize = article::get_param('pageSize');

            $req .= self::add_query_pagination($pageSize);
        }

        $result = $db->query($req);

        $returnValue = $result->fetch_all();
        $arrayData = [];

        for ($i = 0; $i < $result->num_rows; $i++) {
            foreach ($returnValue[$i] as $key => $value) {
                $arrayData[self::$field_list[$key]] = self::formatFieldValue($key, $value);
            }

            $returnValue[$i] = $arrayData;
        }

        return $returnValue;
    }

    public static function get_by_magasin($idArticleMagasin, $idMagasin)
    {
        $db = db::getInstance();

        $req = 'select IdArticle as id, '.self::liste_champs(self::$table_name, self::$field_list).'
							from '.db::dbname(self::$table_name).'
  						where IdArticle_magasin='.(int)$idArticleMagasin.' and IdMagasinCloud='.(int)$idMagasin;
        $res = $db->query($req);

        return $res->fetch_assoc();
    }

    public static function search($search, $pagination = true)
    {
        $db = db::getInstance();

        $query = 'SELECT ' . ($pagination ? 'SQL_CALC_FOUND_ROWS ' : '') . self::liste_champs(self::$table_name, self::$field_list) . ' from '
        . db::dbname(self::$table_name)
        . " WHERE NomCatalogue LIKE '%" . $search . "%'"
        . " OR CodeBarre LIKE '%" . $search . "%'";

        if ($pagination && (article::get_param('pageSize') == null || article::get_param('pageSize') != 'All')) {
            $pageSize = article::get_param('pageSize');

            $query .= self::add_query_pagination($pageSize);
        }

        $result = $db->query($query);

        $returnValue = $result->fetch_all();
        $arrayData = [];

        for ($i = 0; $i < $result->num_rows; $i++) {
            foreach ($returnValue[$i] as $key => $value) {
                $arrayData[self::$field_list[$key]] = self::formatFieldValue($key, $value);
            }

            $returnValue[$i] = $arrayData;
        }

        return $returnValue;
    }

    public static function save_from_xml($xml, $idMagasin)
    {
        $idArticleCloud = self::get_xml_value($xml, 'IdArticleCloud');
        $idArticle = self::get_xml_value($xml, 'IdArticle');
        $article = null;
        $return = false;

        $article = $idArticleCloud > 0
        ? self::get($idArticleCloud)
        : self::get_by_magasin($idArticle, $idMagasin);

        $return = !$article
            ? self::insert_from_xml($xml, $idMagasin)
            : self::update_from_xml($article[0]['IdArticle'], $xml, $idMagasin);

        return $return;
    }

    public static function insert_from_xml($xml, $idMagasin)
    {
        if (config_synchro_mag::getAutorisationBymagasin($idMagasin, 'CreerArticle')['CreerArticle'] == false) {
            return false;
        }

        $db = db::getInstance();

        $query = 'INSERT INTO ' . db::dbname(self::$table_name) . '('. implode(', ', self::$field_list) .') values (';
        $query .= '0,';
        $query .= db::esc(self::get_xml_value($xml, 'IdArticle')) . ',';
        $query .= db::esc($idMagasin) . ',';
        $query .= "'" . db::esc(self::get_xml_value($xml, 'NomCatalogue')) . "',";
        $query .= "'" . db::esc(self::get_xml_value($xml, 'ArticleCodeBarre')) . "',";
        $query .= db::esc($idMagasin) . ',';
        $query .= "CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);";

        if ($db->query($query)) {
            $id = $db->insert_id;

            $magasinsToCreateBatch = config_synchro_mag::getMagainsByAutorisation('RecevoirModifArticle', 1);

            foreach ($magasinsToCreateBatch as $magasin) {
                if ((int)$magasin[0] > 0 && (int)$magasin[0] != (int)$idMagasin) {
                    self::new_log_batch($id, false, (int)$magasin[0]);
                }
            }

            Kintpv_Log::log(" [Article] Insertion de l'article avec CodeBarre = '" . db::esc(self::get_xml_value($xml, 'ArticleCodeBarre')) ."' --> Succès ");
            return $id;
        } else {
            Kintpv_Log::log(" [Article] Insertion de l'article avec CodeBarre = '" . db::esc(self::get_xml_value($xml, 'ArticleCodeBarre')) ."' --> Erreur (Retour MySQLi : '".$db->error."') ");
            return false;
        }
    }

    public static function update_from_xml($idArticle, $xml, $idMagasin)
    {
        // Si le magasin n'a pas le droit de recevoir des modifs d'article, on quitte ici.
        if (config_synchro_mag::getAutorisationBymagasin($idMagasin, 'ModifierArticle')['ModifierArticle'] == false) {
            return false;
        }

        $db = db::getInstance();

        $query = 'UPDATE ' . db::dbname(self::$table_name) . ' SET ';
        $query .= "NomCatalogue = '" . db::esc(self::get_xml_value($xml, 'NomCatalogue')) . "',";
        $query .= "CodeBarre = '" . db::esc(self::get_xml_value($xml, 'ArticleCodeBarre')) . "',";
        $query .= "IdMagOrgModif = '" . db::esc($idMagasin) . "',";
        $query .= "Date_Modification = CURRENT_TIMESTAMP";
        $query .= ' where IdArticle = ' . $idArticle;

        $db->query("SET sql_mode = ''");
        if ($db->query($query)) {
            Kintpv_Log::log("[Article] Mise à jour de l'article avec CodeBarre = '" . db::esc(self::get_xml_value($xml, 'ArticleCodeBarre')) ."' --> Succès");

            $magasinsToCreateBatch = config_synchro_mag::getMagainsByAutorisation('RecevoirModifArticle', 1);

            foreach ($magasinsToCreateBatch as $magasin) {
                if ((int)$magasin[0] > 0 && (int)$magasin[0] != (int)$idMagasin) {
                    self::new_log_batch($idArticle, false, (int)$magasin[0]);
                }
            }

            return $idArticle;
        } else {
            Kintpv_Log::log("[Article] Mise à jour de l'article avec CodeBarre = '" . db::esc(self::get_xml_value($xml, 'ArticleCodeBarre')) ."' --> Erreur (Retour MySQLi : ".$db->error.")");

            return false;
        }
    }
}
