<?php

require_once(GENERAL_CLASSES_DIR.'/config_synchro_mag.php');

require_once(GENERAL_CLASSES_DIR.'/table.php');

class client extends table
{
    public static $table_name = 'client';
    public static $unique_id = 'IdClient';
    public static $field_list = array(
        'IdClient',
        'IdClientFusion',
        'IdClientMagasin',
        'IdMagasin',
        'Nom',
        'Prenom',
        'Adresse1',
        'Adresse2',
        'Adresse3',
        'Adresse4',
        'CodePostal',
        'Ville',
        'EMail',
        'CodeClient',
        'Civilite',
        'Tel_maison',
        'ExonereTVA_O_N',
        'Inactif_O_N',
        'Tel_portable',
        'Tel_travail',
        'Date_naissance',
        'Commentaire',
        'Societe',
        'NumTVA_Intra',
        'DateFinValiditeAdhesion',
        'IdClient_CB_Auto',
        'Fax',
        'SiteWeb',
        'FACT_IdImprFacture',
        'InfoLibre_Libel',
        'InfoLibre_Valeur',
        'NumCompteCompta',
        'VenteHT_O_N',
        'Titre',
        'IdMagOrgModif',
        'TriggerBatchBloque_O_N',
        'DateCrea_Auto',
        'DateModif_Auto',
        'ClefCodifiee',
        'Prospect_O_N',
        'IdTauxTvaExo',
        'TauxTvaExo',
        'FACT_NbJourPaiement',
        'TEL_RECH_portable',
        'TEL_RECH_maison',
        'TEL_RECH_travail',
        'HeureModif_Auto',
        'WEB_MasquerVenteBoutique_O_N',
        'IdTauxTvaExo',
        'TauxTvaExo',
        'RGPD_Anonyme_Date',
        'RGPD_Anonyme_O_N',
        'RGPD_Contact_eMail_Date',
        'RGPD_Contact_eMail_O_N',
        'RGPD_Contact_Papier_Date',
        'RGPD_Contact_Papier_O_N',
        'RGPD_Contact_SMS_Date',
        'RGPD_Contact_SMS_O_N',
        'RGPD_Contact_TEL_Date',
        'RGPD_Contact_TEL_O_N',
        'RGPD_Photo_DatePrise',
        'RGPD_DatePrevueAno',
        'IdTarif',
        'LibelleTarif',
        'DateCreation',
        'DateModification'
    );

    protected $file;

    public static function get($id, $pagination=true)
    {
        $db = db::getInstance();

        $req = 'select '.($pagination ? 'SQL_CALC_FOUND_ROWS ' : '').'IdClient as id, '.self::liste_champs(self::$table_name, self::$field_list).'
							from '.db::dbname(self::$table_name);
        if ($id > 0) {
            $req.= ' where IdClient='.(int)$id;
        } else {	// quand on liste tout, on exclue    les clients fusionn�s
            $req.= ' Where IdClientFusion = 0 ';
            if ($pagination) {
                if ((client::get_param('pageSize') == null || client::get_param('pageSize') != 'All')) {
                    $pageSize = client::get_param('pageSize');

                    $req .= self::add_query_pagination($pageSize);
                }
            }
        }

        $res = $db->query($req);

        if ($id != "") {
            return $res->fetch_assoc();
        } else {
            return $res->fetch_all();
        }
    }

    public static function get_by_magasin($IdClientMagasin, $IdMagasin)
    {
        $db = db::getInstance();

        $req = 'select IdClient as id, '.self::liste_champs(self::$table_name, self::$field_list).'
							from '.db::dbname(self::$table_name).'
  						where IdClientMagasin='.(int)$IdClientMagasin.' and IdMagasin='.(int)$IdMagasin.'
  						order by IdClientMagasin';
        $res = $db->query($req);

        if ((client::get_param('pageSize') == null || client::get_param('pageSize') != 'All')) {
            $pageSize = client::get_param('pageSize');

            $req .= self::add_query_pagination($pageSize);
        }

        return $res->fetch_assoc();
    }

    public static function search($search, $pagination=true)
    {
        $db = db::getInstance();
        $req = 'select '.($pagination ? 'SQL_CALC_FOUND_ROWS ' : '').'IdClient as id, '.self::liste_champs(self::$table_name, self::$field_list).'
								from '.db::dbname(self::$table_name);
        if ($search != '') {
            $req.= '
	  				where
	  				IdClientFusion=0 and (
						IdClientMagasin='.(int)$search.'
						Or IdClient ="'.db::esc($search).'"
  						Or CodeClient="'.db::esc($search).'"
  						Or Nom like"%'.db::esc($search).'%"
  						Or CodePostal="'.db::esc($search).'"
  						Or EMail="'.db::esc($search).'"
  						Or Societe like"%'.db::esc($search).'%"
  						Or Prenom like"%'.db::esc($search).'%"
  						Or Tel_maison like"%'.db::esc($search).'%"
  						Or Tel_portable like"%'.db::esc($search).'%"
						Or Tel_travail like"%'.db::esc($search).'%"
					)
  					order by IdClientMagasin';
        }
        if ($pagination) {
            if ((client::get_param('pageSize') == null || client::get_param('pageSize') != 'All')) {
                $pageSize = client::get_param('pageSize');

                $req .= self::add_query_pagination($pageSize);
            }
        }
        //die($req);
        return $db->query($req);
    }

    public static function save_from_xml($xml, $id_magasin)
    {
        $db = db::getInstance();
        $IdClientCloud = self::get_xml_value($xml, 'IdClientCloud');
        $IdClientMagasin = self::get_xml_value($xml, 'IdClient_Auto');
        $client = null;

        // si nous recevons un client cloud, il faut forc�ment mettre � jour celui-ci (on ne tient pas compte des id client magasin et le magasin)
        if ($IdClientCloud > 0) {
            $client = self::get($IdClientCloud);
        } else {
            $client = self::get_by_magasin($IdClientMagasin, $id_magasin);
        }

        if (!$client) {// insertion
            return self::insert_from_xml($xml, $id_magasin);
        } else { // modification
            return self::update_from_xml($client['id'], $xml, $id_magasin);
        }
    }

    protected static function insert_from_xml($xml, $id_magasin)
    {
        $id_client = (int)self::get_xml_value($xml, 'IdClientCloud');
        $query = 'insert into '.db::dbname(self::$table_name).'
  							(';
        if ($id_client > 0) {
            $query.= 'IdClient, ';
        }

        $dateNaissance = Tools::dateIsoToEn(self::get_xml_value($xml, 'Date_naissance'));
        if ($dateNaissance == "0000-00-00") {
            $queryDateNaissance = "NULL";
        } else {
            $queryDateNaissance = '"' . $dateNaissance . '"';
        }

        $dateFinValidite = Tools::dateIsoToEn(self::get_xml_value($xml, 'DateFinValiditeAdhesion'));
        if ($dateFinValidite == "0000-00-00") {
            $queryDateFinValidite = "NULL";
        } else {
            $queryDateFinValidite = '"'. $dateFinValidite . '"';
        }



        $query.= 'IdClientMagasin, IdClientReseau, IdMagasin, IdClientFusion, Nom, Prenom, Adresse1, Adresse2, Adresse3, Adresse4,
			CodePostal, Ville, EMail, CodeClient, Civilite, Tel_maison, ExonereTVA_O_N, Inactif_O_N,
			Tel_portable, Tel_travail, Date_naissance, Commentaire, Societe, NumTVA_Intra,
			DateFinValiditeAdhesion, IdClient_CB_Auto, Fax, SiteWeb, FACT_IdImprFacture,
			InfoLibre_Libel, InfoLibre_Valeur, NumCompteCompta, VenteHT_O_N, IdMagOrgModif, TriggerBatchBloque_O_N,
			DateCrea_Auto, DateModif_Auto, ClefCodifiee, Prospect_O_N, IdTauxTvaExo, TauxTvaExo,
			FACT_NbJourPaiement, TEL_RECH_portable, TEL_RECH_maison, TEL_RECH_travail, HeureModif_Auto,
			WEB_MasquerVenteBoutique_O_N, RGPD_Anonyme_Date, RGPD_Anonyme_O_N, RGPD_Contact_eMail_Date,
			RGPD_Contact_eMail_O_N, RGPD_Contact_Papier_Date, RGPD_Contact_Papier_O_N, RGPD_Contact_SMS_date,
			RGPD_Contact_SMS_O_N, RGPD_Contact_TEL_Date, RGPD_Contact_TEL_O_N, RGPD_Photo_DatePrise,
			RGPD_DatePrevueAno, IdTarif, LibelleTarif, DateModification, DateCreation)
			values
			(';

        if ($id_client > 0) {
            $query.= $id_client.', ';
        }

        // BBA 2016-03-01 : On sauvegarde l'id du dernier mag qui a fait la modification dans IdMagOrgModif.
        $query.= (int)self::get_xml_value($xml, 'IdClient_Auto').', '.(int)self::get_xml_value($xml, 'IdClientReseau').','.(int)$id_magasin.',
			'.(int)self::get_xml_value($xml, 'IdClientCloudFusion').',
			"'.db::esc(self::get_xml_value($xml, 'Nom')).'", 
			"'.db::esc(self::get_xml_value($xml, 'Prenom')).'",
			"'.db::esc(self::get_xml_value($xml, 'Adresse1')).'", 
			"'.db::esc(self::get_xml_value($xml, 'Adresse2')).'",
			"'.db::esc(self::get_xml_value($xml, 'Adresse3')).'", 
			"'.db::esc(self::get_xml_value($xml, 'Adresse4')).'",
			"'.db::esc(self::get_xml_value($xml, 'CodePostal')).'", 
			"'.db::esc(self::get_xml_value($xml, 'Ville')).'",
			"'.db::esc(self::get_xml_value($xml, 'EMail')).'", 
			"'.db::esc(self::get_xml_value($xml, 'CodeClient')).'",
			"'.db::esc(self::get_xml_value($xml, 'Civilite')).'", 
			"'.db::esc(self::get_xml_value($xml, 'Tel_maison')).'",
			'.(int)self::get_xml_value($xml, 'ExonereTVA_O_N').', 
			'.(int)self::get_xml_value($xml, 'Inactif_O_N').',
			"'.db::esc(self::get_xml_value($xml, 'Tel_portable')).'", 
			"'.db::esc(self::get_xml_value($xml, 'Tel_travail')).'",
			'.$queryDateNaissance.', 
			"'.db::esc(self::get_xml_value($xml, 'Commentaire')).'",
			"'.db::esc(self::get_xml_value($xml, 'Societe')).'", 
			"'.db::esc(self::get_xml_value($xml, 'NumTVA_Intra')).'",
			'.$queryDateFinValidite.', 
			"'.db::esc(self::get_xml_value($xml, 'IdClient_CB_Auto')).'",
			"'.db::esc(self::get_xml_value($xml, 'Fax')).'", 
			"'.db::esc(self::get_xml_value($xml, 'SiteWeb')).'",
			'.(int)self::get_xml_value($xml, 'FACT_IdImprFacture').', 
			"'.db::esc(self::get_xml_value($xml, 'InfoLibre_Libel')).'",
			"'.db::esc(self::get_xml_value($xml, 'InfoLibre_Valeur')).'", 
			"'.db::esc(self::get_xml_value($xml, 'NumCompteCompta')).'",
			'.(int)self::get_xml_value($xml, 'VenteHT_O_N').', '.$id_magasin.',
			'.(int)self::get_xml_value($xml, 'TriggerBatchBloque_O_N').', 
			"'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateCrea_Auto')).'",
			"'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateModif_Auto')).'", 
			"'.db::esc(self::get_xml_value($xml, 'ClefCodifiee')).'",
			'.(int)self::get_xml_value($xml, 'Prospect_O_N').', 
			'.(int)self::get_xml_value($xml, 'IdTauxTvaExo').',
			'.(float)self::get_xml_value($xml, 'TauxTvaExo').', 
			'.(int)self::get_xml_value($xml, 'FACT_NbJourPaiement').',
			"'.db::esc(self::get_xml_value($xml, 'TEL_RECH_portable')).'", 
			"'.db::esc(self::get_xml_value($xml, 'TEL_RECH_maison')).'",
			"'.db::esc(self::get_xml_value($xml, 'TEL_RECH_travail')).'", 
			"'.Tools::dateIsoToTime(self::get_xml_value($xml, 'HeureModif_Auto')).'",
			'.(int)self::get_xml_value($xml, 'WEB_MasquerVenteBoutique_O_N').',
			"'.Tools::dateIsoToEn(self::get_xml_value($xml, 'RGPD_Anonyme_Date')).'",
			'.(int)self::get_xml_value($xml, 'RGPD_Anonyme_O_N').',
			"'.Tools::dateIsoToEn(self::get_xml_value($xml, 'RGPD_Contact_eMail_Date')).'",
			'.(int)self::get_xml_value($xml, 'RGPD_Contact_eMail_O_N').',
			"'.Tools::dateIsoToEn(self::get_xml_value($xml, 'RGPD_Contact_Papier_Date')).'",
			'.(int)self::get_xml_value($xml, 'RGPD_Contact_Papier_O_N').',
			"'.Tools::dateIsoToEn(self::get_xml_value($xml, 'RGPD_Contact_SMS_Date')).'",
			'.(int)self::get_xml_value($xml, 'RGPD_Contact_SMS_O_N').',
			"'.Tools::dateIsoToEn(self::get_xml_value($xml, 'RGPD_Contact_TEL_Date')).'",
			'.(int)self::get_xml_value($xml, 'RGPD_Contact_TEL_O_N').',
			"'.Tools::dateIsoToEn(self::get_xml_value($xml, 'RGPD_Photo_DatePrise')).'",
			"'.Tools::dateIsoToEn(self::get_xml_value($xml, 'RGPD_DatePrevueAno')).'",
			'.(int)self::get_xml_value($xml, 'IdTarif').',
			"'.db::esc(self::get_xml_value($xml, 'LibelleTarif')).'",
			CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)';
        $db = db::getInstance();
        $db->query("SET sql_mode = ''");

        if ($db->query($query)) {
            $id = $db->insert_id;
            self::new_log_batch($id);
            Kintpv_Log::log(" [Client] Insertion du client avec Code Client = '" . db::esc(self::get_xml_value($xml, 'CodeClient')) ."' --> Succès) ");

            self::save_infos_complement($id, $xml);

            return $id;
        } else {
            Kintpv_Log::log(" [Client] Insertion du client avec Code Client = '" . db::esc(self::get_xml_value($xml, 'CodeClient')) ."' --> Erreur (Retour MySQLi : '".$db->error."') ");
            return false;
        }
    }

    /**
     * Methode update_from_xml
     *
     * Mets à jour un client et ses informations
     *
     * @param int    $id_client.
     * @param string $xml : Contient les données à mettre à jour.
     * @param int    $id_magasin : Magasin dans lequel il doit être mis à jour.
     */
    protected static function update_from_xml($id_client, $xml, $id_magasin)
    {
        // BBA 2016-03-01 : On sauvegarde l'id du dernier mag qui a fait la modification dans IdMagOrgModif.
        // IdClientMagasin='.(int)self::get_xml_value($xml, 'IdClient_Auto').',

        $dateNaissance = Tools::dateIsoToEn(self::get_xml_value($xml, 'Date_naissance'));

        if ($dateNaissance == "0000-00-00") {
            $queryDateNaissance = "NULL";
        } else {
            $queryDateNaissance = '"'.$dateNaissance.'"';
        }

        $dateFinValidite = Tools::dateIsoToEn(self::get_xml_value($xml, 'DateFinValiditeAdhesion'));
        if ($dateFinValidite == "0000-00-00") {
            $queryDateFinValidite = "NULL";
        } else {
            $queryDateFinValidite = '"'.$dateFinValidite.'"';
        }
        $query = 'update '.db::dbname(self::$table_name).' set
  				IdClientReseau='.(int)self::get_xml_value($xml, 'IdClientReseau').',
  				Nom="'.db::esc(self::get_xml_value($xml, 'Nom')).'",
                Prenom="'.db::esc(self::get_xml_value($xml, 'Prenom')).'",
  				Adresse1="'.db::esc(self::get_xml_value($xml, 'Adresse1')).'",
                Adresse2="'.db::esc(self::get_xml_value($xml, 'Adresse2')).'",
  				Adresse3="'.db::esc(self::get_xml_value($xml, 'Adresse3')).'",
                Adresse4="'.db::esc(self::get_xml_value($xml, 'Adresse4')).'",
  				CodePostal="'.db::esc(self::get_xml_value($xml, 'CodePostal')).'",
                Ville="'.db::esc(self::get_xml_value($xml, 'Ville')).'",
  				EMail="'.db::esc(self::get_xml_value($xml, 'EMail')).'",
                CodeClient="'.db::esc(self::get_xml_value($xml, 'CodeClient')).'",
  				Civilite="'.db::esc(self::get_xml_value($xml, 'Civilite')).'",
                Tel_maison="'.db::esc(self::get_xml_value($xml, 'Tel_maison')).'",
  				ExonereTVA_O_N='.(int)self::get_xml_value($xml, 'ExonereTVA_O_N').',
                Inactif_O_N='.(int)self::get_xml_value($xml, 'Inactif_O_N').',
  				Tel_portable="'.db::esc(self::get_xml_value($xml, 'Tel_portable')).'",
                Tel_travail="'.db::esc(self::get_xml_value($xml, 'Tel_travail')).'",
  				Date_naissance='.$queryDateNaissance.',
                Commentaire="'.db::esc(self::get_xml_value($xml, 'Commentaire')).'",
  				Societe="'.db::esc(self::get_xml_value($xml, 'Societe')).'",
                NumTVA_Intra="'.db::esc(self::get_xml_value($xml, 'NumTVA_Intra')).'",
  				DateFinValiditeAdhesion='.$queryDateFinValidite.', 
				IdClient_CB_Auto="'.db::esc(self::get_xml_value($xml, 'IdClient_CB_Auto')).'",
  				Fax="'.db::esc(self::get_xml_value($xml, 'Fax')).'",
                SiteWeb="'.db::esc(self::get_xml_value($xml, 'SiteWeb')).'",
  				FACT_IdImprFacture='.(int)self::get_xml_value($xml, 'FACT_IdImprFacture').',
                InfoLibre_Libel="'.db::esc(self::get_xml_value($xml, 'InfoLibre_Valeur')).'",
  				InfoLibre_Valeur="'.db::esc(self::get_xml_value($xml, 'InfoLibre_Valeur')).'",
                NumCompteCompta="'.db::esc(self::get_xml_value($xml, 'NumCompteCompta')).'",
  				VenteHT_O_N='.(int)self::get_xml_value($xml, 'VenteHT_O_N').',
                DateModification=CURRENT_TIMESTAMP,
  				IdMagOrgModif='.(int)$id_magasin.',
                TriggerBatchBloque_O_N='.(int)self::get_xml_value($xml, 'TriggerBatchBloque_O_N').',
  				DateCrea_Auto="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateCrea_Auto')).'",
                DateModif_Auto="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateModif_Auto')).'",
  				ClefCodifiee="'.db::esc(self::get_xml_value($xml, 'ClefCodifiee')).'",
                Prospect_O_N='.(int)self::get_xml_value($xml, 'Prospect_O_N').',
  				IdTauxTvaExo='.(int)self::get_xml_value($xml, 'IdTauxTvaExo').',
                TauxTvaExo='.(float)self::get_xml_value($xml, 'TauxTvaExo').',
  				FACT_NbJourPaiement='.(int)self::get_xml_value($xml, 'FACT_NbJourPaiement').',
                TEL_RECH_portable="'.db::esc(self::get_xml_value($xml, 'TEL_RECH_portable')).'",
  				TEL_RECH_maison="'.db::esc(self::get_xml_value($xml, 'TEL_RECH_maison')).'",
                TEL_RECH_travail="'.db::esc(self::get_xml_value($xml, 'TEL_RECH_travail')).'",
  				HeureModif_Auto="'.Tools::dateIsoToTime(self::get_xml_value($xml, 'HeureModif_Auto')).'",
                WEB_MasquerVenteBoutique_O_N='.(int)self::get_xml_value($xml, 'WEB_MasquerVenteBoutique_O_N').',
				RGPD_Anonyme_Date="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'RGPD_Anonyme_Date')).'",
				RGPD_Anonyme_O_N='.(int)self::get_xml_value($xml, 'RGPD_Anonyme_O_N').',
				RGPD_Contact_eMail_Date="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'RGPD_Contact_eMail_Date')).'",
				RGPD_Contact_eMail_O_N='.(int)self::get_xml_value($xml, 'RGPD_Contact_eMail_O_N').',
				RGPD_Contact_Papier_Date="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'RGPD_Contact_Papier_Date')).'",
				RGPD_Contact_Papier_O_N='.(int)self::get_xml_value($xml, 'RGPD_Contact_Papier_O_N').',
				RGPD_Contact_SMS_Date="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'RGPD_Contact_SMS_Date')).'",
				RGPD_Contact_SMS_O_N='.(int)self::get_xml_value($xml, 'RGPD_Contact_SMS_O_N').',
				RGPD_Contact_TEL_Date="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'RGPD_Contact_TEL_Date')).'",
				RGPD_Contact_TEL_O_N='.(int)self::get_xml_value($xml, 'RGPD_Contact_TEL_O_N').',
				RGPD_Photo_DatePrise="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'RGPD_Photo_DatePrise')).'",
				RGPD_DatePrevueAno="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'RGPD_DatePrevueAno')).'",
				IdTarif='.(int)self::get_xml_value($xml, 'IdTarif').',
				LibelleTarif="'.db::esc(self::get_xml_value($xml, 'LibelleTarif')).'"

  				Where IdClient='.(int)$id_client;

        $db = db::getInstance();
        $db->query("SET sql_mode = ''");
        if ($db->query($query)) {
            Kintpv_Log::log("[Client] Mise à jour du client avec Code Client = '" . db::esc(self::get_xml_value($xml, 'CodeClient')) ."' --> Succès");

            self::save_infos_complement($id_client, $xml);

            self::new_log_batch($id_client);
            return $id_client;
        } else {
            //$file_text = $db->query($query) . "\n";
            Kintpv_Log::log("[Client] Mise à jour du client avec Code Client = '" . db::esc(self::get_xml_value($xml, 'CodeClient')) ."' --> Erreur (Retour MySQLi : ".$db->error.")");
            return false;
        }
    }

    /**
     * Methode saveInfosComplement
     */
    public static function save_infos_complement($id_client, $xml)
    {
        $array_infos = json_decode(file_get_contents('../config/infos_synchro.json')); // Récupération du fichier JSON des infos_complementaires

        $client = self::get($id_client);

        $content = $xml;
        if (is_string($xml)) {
            $content = new DOMDocument();
            $content->loadXML($xml);
        }

        $config_mag = config_synchro_mag::getAutorisationByMagasin((int)$client['IdMagasin']);

        foreach ($array_infos as $info) {
            $value = self::get_xml_value($content, $info->Balise_XML);

            if ($value != '' && $config_mag[$info->Libelle] == true) { // Si la valeur est présente dans l'xml du client et qu'elle doit etre synchronisée pour ce magasin.
                $data = [
                    'IdClient' => $id_client,
                    'Libelle'  => $info->Libelle,
                    'Valeur'   => $value,
                ];

                client_info_complement::insertOrUpdate($id_client, $data);
                // On recherche si cette info complémentaire a déjà été créée pour ce client et ce magasin. Si oui on met à jour sinon on créé.
            }
        }
    }

    public static function fusionner($id_principal, $liste_secondaires)
    {
        //status par défaut
        //Ne change pas si la fusion échoue
        $status = 'default';

        $db = db::getInstance();

        // premierement, il faut vérifier que le principal existe...
        $c = self::get($id_principal);

        if ($c) {
            //boucle sur la liste des secondaires pour chercher si un des clients est inactif
            foreach ($liste_secondaires as $l) {
                //récupérer valeur Inactif du client
                $query = 'select Inactif_O_N from '.db::dbname(self::$table_name).' where IdClient='.(int)$l;
                $res = $db->query($query);
                $resultInactif = $res->fetch_array();

                foreach ($resultInactif as $key) {
                    //si client inactif
                    if ($key['Inactif_O_N'] == 1) {
                        //retour de status "inactif" et sortie de la fonction
                        $status = 'inactif';
                        return $status;
                        exit;
                    }
                }
            }


            foreach ($liste_secondaires as $l) {
                if ($l != $id_principal) {
                    // modifier les id des tables liées
                    // les tickets
                    $tickets = ticket::get_by_client($l);
                    foreach ($tickets as $t) {
                        ticket::new_log_batch($t['id']);
                    }	// il faut mettre un batch sur tous les tickets pour qu'ils soient retournés aux kintpv
                    $query = 'update '.db::dbname(ticket::$table_name).' set IdClient='.(int)$id_principal.' where IdClient='.(int)$l;
                    $db->query($query);

                    // et la fidelite
                    $fidelite = fidelite::get_for_client($l);
                    foreach ($fidelite as $f) {
                        fidelite::new_log_batch($f['id']);
                    }	// il faut mettre un batch sur toutes les fidelites pour qu'elles soient retourn�es aux kintpv
                    $query = 'update '.db::dbname(fidelite::$table_name).' set IdClient='.(int)$id_principal.' where IdClient='.(int)$l;
                    $db->query($query);

                    // et mise � jour du client
                    $query = 'update '.db::dbname(self::$table_name).' set IdClientFusion='.(int)$id_principal.' where IdClient='.(int)$l;
                    $db->query($query);
                    self::new_log_batch($l);	// batch pour les kintpv
                }
                //status de fusion réussie
                $status = 'succes';
            }
        }

        //retourne le status
        return $status;
    }

    public static function liste_doublons($tab_criteres = array())
    {
        set_time_limit(0);
        $tab_retour = array();
        $cpt=0;
        $groupe=0;
        $champs = '';
        foreach ($tab_criteres as $c) {
            $name = '';
            switch($c) {
                case 'Nom':
                case 'Prenom':
                case 'CodePostal':
                case 'EMail':
                    $name = $c;
            }

            if ($name != '') {
                if ($champs != '') {
                    $champs .= ',';
                }
                $champs.= $c;
            }
        }

        if ($champs != '') {
            // premierement : requete de recherche des doublons
            $req = 'select '.$champs.' from '.db::dbname(self::$table_name).' where IdClientFusion=0 group by ';
            $req.= $champs.' having(count(*)>1)';

            $db = db::getInstance();
            $liste = $db->query($req);

            foreach ($liste as $l) {
                $req = 'select IdClient as id, '.self::liste_champs(self::$table_name, self::$field_list).'
							from '.db::dbname(self::$table_name).'
							where IdClientFusion = 0 ';

                $where = '';
                foreach ($tab_criteres as $c) {
                    $name = '';
                    $value = '';
                    switch($c) {
                        case 'Nom':
                            $value = $l['Nom'];
                            $name = $c;
                            break;
                        case 'Prenom':
                            $value = $l['Prenom'];
                            $name = $c;
                            break;
                        case 'CodePostal':
                            $value = $l['CodePostal'];
                            $name = $c;
                            break;
                        case 'EMail':
                            $value = $l['EMail'];
                            $name = $c;
                            break;
                    }

                    if ($name != '') {
                        $where .= ' and ';
                        $where.= $c.' = "'.db::esc($value).'"';
                    }
                }

                if ($where != '') {
                    $req.= $where;
                    $res = $db->query($req);

                    foreach ($res as $r) {
                        $tab_retour[$cpt] = $r;
                        $tab_retour[$cpt]['groupe'] = $groupe;
                        $cpt++;
                    }
                }

                $groupe++;
            }
        }
        return $tab_retour;
    }
}
