<!--
 - @author      JGE (Kinhelios)
 - @copyright   2022 Kinhelios 
 - @link        https://www.kinhelios.com
 - @updated     2022-12-27 - JG
 -->

<?php

require_once(GENERAL_CLASSES_DIR.'/table.php');

class client_info_complement extends table
{
    public static $tableName = 'client_info_complement'; // Nom de la table;
    public static $unique_id  = 'Id'; // Clé primaire de la table.
    public static $field_list = array( // Liste des champs de la table.
        'Id_Client',          // Id du client à qui appartient l'information.
        'Info_Libelle',       // Information renseignée.
        'Info_Valeur',        // Valeur de l'information.
        'Date_Creation',      // Timestamp à la création de l'enregistrement.
        'Date_Modifitcation', // Timestamp à la modificaton de l'enregistrement.
    );

    /**
     * Récupère les informations complémentaires d'un client
     *
     * @param int $id_client  : Id du client chez qui on récupère les informations.
     * @param string $libelle : (Default : '') Libelle d'une information spécifique à remonter. Si laissé vide on remonte toutes les infos du client.
     */
    public static function get_by_client($id_client, $libelle = '')
    {
        $db = db::getInstance();

        $arrayInfos   = [];
        $fetchRecords = [];

        $query = 'Select * from ' . db::dbname(self::$tableName)
        . ' where `Id_Client` = ' . (int)$id_client;

        $query .= ($libelle != '') ? ' and `Info_Libelle` = "' . db::esc($libelle) . '";' : ';';

        $result = $db->query($query);

        if ($libelle == '') {
            $fetchRecords = $result->fetch_all();

            foreach ($fetchRecords as $record) {
                $info = [];

                for ($i = 0; $i < count($record); $i++) {
                    if ($i == 0) {
                        $info['Id'] = $record[$i];
                        continue;
                    }

                    $info[self::$field_list[$i - 1]] = $record[$i];
                }

                $arrayInfos[] = $info;
            }

            return $arrayInfos;
        } else {
            return $result->fetch_assoc();
        }
    }

    /**
     * Insertion d'une nouvelle information complémentaire pour un client
     *
     * @param int $id_client : Id du client pour qui ajouter une information.
     * @param array $data
     *
     * @return int Id enregistrement inséré.
     */
    public static function insertOrUpdate($idClient, $data)
    {
        $id = self::checkIfExists($idClient, $data['Libelle']);

        if ((int)$id === 0) {
            $insert = self::insert($data);

            if ($insert <= 0) {
                Kintpv_Log::log("Erreur d'enregistrement de client_info_complement '". $data['Libelle'] ."'. Id Client : {$idClient}.");
            }
        } else {
            $update = self::update($id, $data);

            if ($update != 0) {
                Kintpv_Log::log("Erreur de mise à jour de client_info_complement '". $data['Libelle'] ."'. Id Client : {$idClient}.");
            }
        }
    }

    /**
     * Methode checkIfExists
     *
     * Vérifie si un enregistrement existe dans la base.
     *
     * @param int    $idClient : Id du client associé à l'enregistrement.
     * @param string $libelle : Nom de la l'information recherchée.
     *
     * @return int Id de l'enregistrement trouvé ou 0.
     */
    public static function checkIfExists($idClient, $libelle)
    {
        $db = db::getInstance();

        $query = 'Select `Id` from ' . db::dbname(self::$tableName) . " where `Id_Client` = '{$idClient}' and `Info_Libelle` = '"
        . db::esc($libelle) . "';";

        $result = $db->query($query);

        $id = 0;

        if ($result->num_rows != 0) {
            $id = $result->fetch_assoc()['Id'];
        };

        return $id;
    }

    /**
     * Methode insert
     *
     * Créé un nouvel enregistrement dans la table client_info_complement
     *
     * @param array $data : Données à enregistrer.
     * @return int Id du nouvel enregistrement. Zero si non créé.
     */
    public static function insert($data)
    {
        $db = db::getInstance();

        $query = 'Insert into ' . db::dbname(self::$tableName) . '(`Id_Client`, `Info_Libelle`, `Info_Valeur`) values (';
        $query .= $data['IdClient'] . ", '" . db::esc($data['Libelle']) . "', '" . db::esc($data['Valeur']) . "');";

        $result = $db->query($query);

        $return = ($result == true) ? $db->insert_id : -1;

        return $return;
    }

    /**
     * Methode update
     *
     * Mets à jour un enregistrement dans client_info_complement
     *
     * @param int $id : Id de l'enregistrement.
     * @param array $data : Données à mettre à jour.
     */
    public static function update($id, $data)
    {
        $db = db::getInstance();

        $value = self::get_by_client($data['IdClient'], $data['Libelle']);

        if ($value['Info_Valeur'] != $data['Valeur']) {
            $query = "Update " . db::dbname(self::$tableName) . " set `Info_Valeur` = '" . db::esc($data['Valeur'])
            . "' where `Id` = {$id};";

            $result = $db->query($query);

            $return = ($result == true) ? 0 : -1;

            return $return;
        }

        return 0;
    }
}
