<?php

require_once(GENERAL_CLASSES_DIR.'/table.php');
require_once(GENERAL_CLASSES_DIR.'/kintpv_log.php');

class config_synchro_mag extends table
{
    public static $table_name = 'config_synchro_mag';
    public static $field_list = array(
        'Id_Magasin',
        'Libelle_Info',
        'Is_Checked'
    );

    public static function get($id='')
    {
        $db = db::getInstance();

        $req = 'select Id, '.self::liste_champs(self::$table_name, self::$field_list).'
        from ' . db::dbname(self::$table_name);

        if ('' !== $id) {
            $req .= ' where Id = ' . (int)$id;
        }

        $res = $db->query($req);
        if ('' !== $id) {
            return $res->fetch_assoc();
        } else {
            $fetch = $res->fetch_all();
            $array_result = array();

            foreach ($fetch as $k_key => $record) {
                $array_result[$k_key]['Id']           = (int)$record[0];
                $array_result[$k_key]['Id_Magasin']   = (int)$record[1];
                $array_result[$k_key]['Libelle_Info'] = $record[2];
                $array_result[$k_key]['Is_Checked']   = (int)$record[3];
            }

            return $array_result;
        }
    }

    /**
     * Methode getByMagasin
     *
     * Retourne les paramètres de synchronisation d'un magasin
     *
     * @param int $idMagasin.
     * @return array.
     */
    public static function getByMagasin($id_magasin)
    {
        $db = db::getInstance();

        $query = 'select Id, '.self::liste_champs(self::$table_name, self::$field_list).'
        from ' . db::dbname(self::$table_name) . ' where Id_Magasin = ' . (int)$id_magasin;

        $result = $db->query($query);

        if ($result->num_rows > 0) {
            $fetch = $result->fetch_all();
            $array_result = array();

            foreach ($fetch as $k_key => $record) {
                $array_result[$k_key]['Id']           = (int)$record[0];
                $array_result[$k_key]['Id_Magasin']   = (int)$record[1];
                $array_result[$k_key]['Libelle_Info'] = $record[2];
                $array_result[$k_key]['Is_Checked']   = (int)$record[3];
            }

            return $array_result;
        }
    }

    public static function getMagainsByAutorisation($autorisation, $searchValue)
    {
        $db = db::getInstance();

        $query = 'SELECT Id_Magasin FROM ' . db::dbname(self::$table_name)
        . " WHERE Libelle_Info = '" . db::esc($autorisation) . "' And  Is_Checked = " . (int)$searchValue . ';';
        
        $result = $db->query($query);

        return $result->fetch_all();
    }

    /**
     * Methode getAutorisationByMagasin
     *
     * Retourne un tableau contenant pour chaque information (Libelle) son autorisation oui/non à être synchronisée pour ce magasin (Is_Checked)
     *
     * @param int $idMagasin.
     * @return array.
     */
    public static function getAutorisationBymagasin($idMagasin, $autorisation = '')
    {
        $db = db::getInstance();

        $query = 'select Id, '.self::liste_champs(self::$table_name, self::$field_list).'
        from ' . db::dbname(self::$table_name) . ' where Id_Magasin = ' . (int)$idMagasin;

        if ($autorisation != '') {
            $query .= ' and Libelle_Info = "' . $autorisation . '";';
        }

        $result = $db->query($query);

        $arrAutorisations = [];

        if ($result->num_rows > 0) {
            $fetch = $result->fetch_all();
            foreach ($fetch as $k_key => $record) {
                $arrAutorisations[$record[2]] = (bool)$record[3];
            }
        }

        return $arrAutorisations;
    }

    public static function add($values)
    {
        $db = db::getInstance();

        $req = 'insert into '.db::dbname(self::$table_name).' (
        `Id_Magasin`, `Libelle_Info`, `Is_Checked`) values (
        '.(int)$values['Id_Magasin'].',
        "'.db::esc($values['Libelle_Info']).'",
        '.(int)$values['Is_Checked'].'
        )';

        $db->query($req);

        return $db->insert_id;
    }

    /**
     * Methode updateIs_Checked
     *
     * Mets à jour la
     */
    public static function updateIs_Checked($id, $value)
    {
        $db = db::getInstance();

        $req = 'Update ' . db::dbname(self::$table_name) . ' set Is_Checked = ' . (int)$value . ' where Id = ' . (int)$id;

        $db->query($req);

        //Todo : handle des erreurs.
    }

    /**
     * Methode checkIfExists
     *
     * Vérifie si un enregistrement existe dans la base.
     *
     * @param int    $idMagasin.
     * @param string $libelle.
     */
    public static function checkIfExists($idMagasin, $libelle)
    {
        $db = db::getInstance();

        $req = 'Select Id from ' . db::dbname(self::$table_name) . ' where Id_Magasin = ' . (int)$idMagasin . '
        and Libelle_Info = "'.db::esc($libelle).'"';

        $res = $db->query($req);

        $assoc = $res->fetch_assoc();

        if (null != $assoc && isset($assoc['Id'])) {
            return (int)$assoc['Id'];
        } else {
            return 0;
        }
    }
}
