<?php

class Tools
{
    protected static $errors = array();
    protected static $warnings = array();
    protected static $messages = array();

    public static function getValue($name)
    {
        $value = '';

        if (isset($_GET[$name])) {
            $value = $_GET[$name];
        } elseif (isset($_POST[$name])) {
            $value = $_POST[$name];
        }

        return $value;
    }

    public static function getUploadedFile($name)
    {
        $file = false;
        if (isset($_FILES[$name])) {
            $file = $_FILES[$name];
        }

        return $file;
    }

    public static function isSubmit($bt)
    {
        return (
            isset($_POST[$bt]) || isset($_POST[$bt.'_x']) || isset($_POST[$bt.'_y'])
            || isset($_GET[$bt]) || isset($_GET[$bt.'_x']) || isset($_GET[$bt.'_y'])
        );
    }

    public static function addError($error, $type=0)
    {
        switch($type) {
            case 1:
                self::$warnings[] = $error;
                break;
            case 2:
                self::$messages[] = $error;
                break;
            default:
                self::$errors[] = $error;
        }
    }

    public static function addMessage($message)
    {
        self::addError($message, 2);
    }

    public static function addWarning($warning)
    {
        self::addError($warning, 1);
    }

    public static function clearErrors()
    {
        self::$errors = array();
        self::$warnings = array();
        self::$messages = array();
    }

    public static function getErrors()
    {
        return self::$errors;
    }

    public static function getWarnings()
    {
        return self::$warnings;
    }

    public static function getMessages()
    {
        return self::$messages;
    }

    public static function getCookie($name)
    {
        $value = null;

        if (isset($_COOKIE[$name])) {
            $value = $_COOKIE[$name];
        }

        return $value;
    }

    public static function exploseDate($date)
    {
        if ($date == null) return []; 

        $tab_date = explode('/', $date);
        return $tab_date;
    }

    public static function dateFrToEn($date)
    {
        $date_en = '0000-00-00';
        $tab = self::exploseDate($date);
        if (count($tab) >= 3) {
            $date_en = $tab[2]."-".$tab[1]."-".$tab[0];
        }

        return $date_en;
    }

    /**
     * Methode dateEnToFr
     *
     * Convertit une date du format 'aaaa-mm-jj' au format 'jj/mm/aaaa';
     */
    public static function dateEnToFr($date)
    {
        $dateFR = '00/00/0000';

        $expDate = explode('-', $date);

        if (count($expDate) >= 3) {
            $dateFR = $expDate[2] . '/' . $expDate[1] . '/' . $expDate[0];
        }

        return $dateFR;
    }

    public static function dateIsoToEn($date)
    {
        $sep_ISO = strpos($date, 'T');
        $date_formated = '0000-00-00';
        if ($sep_ISO > 0) {
            $date_formated = substr($date, 0, $sep_ISO);
        }
        return $date_formated;
    }

    public static function dateIsoToTime($date)
    {
        $sep_ISO = strpos($date, 'T');
        $time_formated = '00:00:00';
        if ($sep_ISO > 0) {
            $time_formated = substr($date, $sep_ISO+1);
        } else {
            $time_formated = $date;
        }
        return $time_formated;
    }

    public static function getMonthName($number)
    {
        $mois = '';

        switch($number) {
            case 1:
                $mois = 'Janvier';
                break;
            case 2:
                $mois = 'Février';
                break;
            case 3:
                $mois = 'Mars';
                break;
            case 4:
                $mois = 'Avril';
                break;
            case 5:
                $mois = 'Mai';
                break;
            case 6:
                $mois = 'Juin';
                break;
            case 7:
                $mois = 'Juillet';
                break;
            case 8:
                $mois = 'Août';
                break;
            case 9:
                $mois = 'Septembre';
                break;
            case 10:
                $mois = 'Octobre';
                break;
            case 11:
                $mois = 'Novembre';
                break;
            case 12:
                $mois = 'Décembre';
                break;
        }

        return $mois;
    }

    public static function GetMois()
    {
        $tab_mois = array();

        for ($i=1; $i <=12; $i++) {
            $tab_mois[$i]['mois'] = self::getMonthName($i);
            $tab_mois[$i]['num'] = $i;
        }

        return $tab_mois;
    }

    public static function GetDayName($number)
    {
        $day = '';
        switch($number) {
            case '0':
                $day = 'Dimanche';
                break;
            case '1':
                $day = 'Lundi';
                break;
            case '2':
                $day = 'Mardi';
                break;
            case '3':
                $day = 'Mercredi';
                break;
            case '4':
                $day = 'Jeudi';
                break;
            case '5':
                $day = 'Vendredi';
                break;
            case '6':
                $day = 'Samedi';
                break;
            case '7':
                $day = 'Dimanche';
                break;
        }
        return $day;
    }

    public static function header_download($filename, $ext)
    {
        header("Content-type: application/".$ext); // entete de l'extension (pdf, csv...)
        header("Content-Disposition: attachment; filename=\"".$filename."\""); // nom du fichier à télécharger
        header("Cache-control: private");
    }

  public static function header_xml()
  {
      header("Content-type: text/xml");
      echo '<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>'."\n";
  }

    public static function is_email($email)
    {
        if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
            return true;
        } else {
            return false;
        }
    }

    public static function start_end_week($year, $no_week, &$date_start, &$date_end)
    {
        // Récup jour début et fin de la semaine
        $timeStart = strtotime("First Tuesday January {$year} + ".($no_week - 1)." Week");
        $timeEnd   = strtotime("First Tuesday January {$year} + ".$no_week." Week -1 day");


        $date_start = strftime("%Y-%m-%d", $timeStart - (1*3600*24));
        $date_end = strftime("%Y-%m-%d", $timeEnd - (1*3600*24));
    }
}
