<?php
	require_once(GENERAL_CLASSES_DIR.'/table.php');
	require_once(GENERAL_CLASSES_DIR.'/ip_block.php');

	use PHPMailer\PHPMailer\PHPMailer;

	class user extends table
	{
		public static $table_name = 'user';
		public static $field_list = array('Email', 'MotPasse');


		public static function get($id='')
		{
			$db = db::getInstance();

			$req = 'select IdUser as id, '.self::liste_champs(self::$table_name, self::$field_list).'
							from '.db::dbname(self::$table_name);
			if($id != '')
				$req.= ' where IdUser='.(int)$id;
			$res = $db->query($req);

			if($id != "")
				return $res->fetch_assoc();
			else
				return $res->fetch_all();

		}

		public static function login($ident, $password, &$erreur=null)
		{
			$db = db::getInstance();
			
			$tps_reconnexion = ip_block::temps_avant_reconnexion();
			if($tps_reconnexion <= 0)
			{
				$req = 'select IdUser as id
								from '.db::dbname(self::$table_name).'
	  						where Email="'.db::esc($ident).'"
	  						and MotPasse= CONCAT("*", UPPER(SHA1(UNHEX(SHA1("'.db::esc($password).'")))))';
	  		$res = $db->query($req);
			  $result = $res->fetch_array();	  		
	  		if($result)
	  		{
				
	  			ip_block::ip_clear();
	  			return $result['id'];
	  		}
	  		else
	  		{
	  			ip_block::inc_echec();
	  			$erreur = ip_block::temps_avant_reconnexion();
	  		}
	  	}
	  	else
	  		$erreur = $tps_reconnexion;

	  	return false;
		}

		public static function count()
		{
			$nb = 0;
			$count = 0;
			$db = db::getInstance();

			$req = 'select email from '.db::dbname(self::$table_name);
  			$res = $db->query($req);
  			
  		
  			if($res)
  			{
	  			$row_cnt = $res->num_rows;
	  			$nb = $row_cnt;
  			}

  		return $nb;
		}

		public static function add($values)
		{
			if(isset($values['Email']) && isset($values['MotPasse']))
			{
				$db = db::getInstance();
				$req = 'insert into '.db::dbname(self::$table_name).' (Email, MotPasse, Date_Creation, Date_Modification) values
				("'.db::esc($values['Email']).'", CONCAT("*", UPPER(SHA1(UNHEX(SHA1("'.db::esc($values['MotPasse']).'"))))), CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)';

				$db->query($req);
				$id = $db->insert_id;
				return $id ;
			}
			else
				return false;
		}

		public static function update($id, $values)
		{
			$db = db::getInstance();
			$req = 'update '.db::dbname(self::$table_name).' set
							Email="'.db::esc($values['Email']).'", ';
			if(isset($values['MotPasse']) && $values['MotPasse'] != '')
				$req.='MotPasse= CONCAT("*", UPPER(SHA1(UNHEX(SHA1("'.db::esc($values['MotPasse']).'"))))), ';
			$req.= 'Date_Modification=CURRENT_TIMESTAMP
							where IdUser='.(int)$id;
			if($db->query($req))
					return $id;

			return false;

		}

		public static function save($id)
		{
			$values = self::get_current_values();

			if(Tools::is_email($values['Email']))
			{
				if($id <= 0)
					return self::add($values);
				else
					return self::update($id, $values);
			}
			else
				Tools::addError('Email invalide');
			return false;
		}

		public static function delete($id)
		{
			$db = db::getInstance();
			$req = 'delete from '.db::dbname(self::$table_name).'
							where IdUser='.(int)$id;
			if($db->query($req))
				return true;
			else
				return false;
		}

		public static function get_current_values()
		{
			$values = array();
			$values['id'] = Tools::getValue('id');
			$values['Email'] = Tools::getValue('Email');
			$values['MotPasse'] = Tools::getValue('MotPasse');

			return $values;
		}

		public static function send_password($email)
		{
			$ok = false;
			$db = db::getInstance();
			// recherche si un utilisateur existe avec ce mot de passe
			$req = 'select IdUser as id
							from '.db::dbname(self::$table_name).' where Email="'.db::esc($email).'"';
			$res = $db->query($req);
			$result = $res->fetch_array();
			if($result)
			{
				$car_generation = 'abcdefghijklmnopqrstuvwyxz0123456789@!:;,§/?*µ$=+";';
				$pass = '';
				for($i = 0; $i < 8; $i++)
				{
					// On choisit un caractère au hasard dans les caractères autorisés :
					$indice = mt_rand(0,strlen($car_generation)-1);

					// cumul du caractère
					$pass.= $car_generation[$indice];
				}

				$req = 'update '.db::dbname(self::$table_name).' set
							MotPasse=CONCAT("*", UPPER(SHA1(UNHEX(SHA1("'.db::esc($pass).'")))))
							where IdUser='.(int)$result['id'];
				if($db->query($req))
				{
					// envoi du mot de passe par email
					$mail = new PHPMailer;
		    	// expediteur
					$mail->setFrom('noreply@kintpv.com', 'KINTPV Cloud');
					// destinataire
					$mail->addAddress($email, $email);
					// sujet du message
					$mail->Subject ='[KinTPV Cloud] Regénération de mot de passe';
					$mail->Body = 'Bonjour'."\n\n".'Vous avez demandé la génération d\'un nouveau mot de passe. Vous le trouverez ci-dessous : '."\n\n".$pass;
					
					//send the message, check for errors
					if ($mail->send())
						$ok = true;
				}
			}

			return $ok;
		}
	}
?>
