<?php
// KINHELIOS -copyright 2009-
//	   ___________________________________
//	__/ Exemple de script PHP pour KinTPV \___________________________________
//	
//	Cet exemple permet  un serveur PHP d'interroger le logiciel KinTPV, 
//  suivant des mots cls (voir documentation).
//  
//  Dans cet exemple nous demandons  KinTPV de nous envoyer la liste de 
//  tous les articles (retour XML)
//////////////////////////////////////////////////////////////////////////////


//----------------------------------
// INITIALISATION DES CONSTANTES
//----------------------------------
$HOST = ''; //Adresse IP de la machine KinTPV.
$PORT = '8080'; //PC -> Port 80 / MAC -> Port 8080
$CleKinTPV = '69715479632546842663'; //Suivant la cl entre dans KinTPV (20 caractres)

//----------------------------------
// Requte pour la demande  KinTPV
//----------------------------------
$Requete_t = 'ARTICLE_LIRE'; // Pour lire les articles
$Requete_t.= '?CRITERE=IdArticle';
$Requete_t.= '&OPERATEUR=SUP';
$Requete_t.= '&VALEUR=0';

// Ajout de la date et de l'heure courante
$DateHeure = getdate();
$Requete_t.= '&DATE='.$DateHeure["mday"].'/'.$DateHeure["mon"].'/'.$DateHeure["year"];
$Requete_t.= '&HEURE='.$DateHeure["hours"].':'.$DateHeure["minutes"].':'.$DateHeure["seconds"];

// Donne de la demande
$Data_t = '';

// Demande du code KinTPV (KIN_ID)
$KIN_ID_t=KINTPV_GenererCle($Requete_t);

//----------------------------------
// Envoi de la requte avec le code KinTPV (KIN_ID)
//----------------------------------
$Requete_t.= '&KIN_ID='.$KIN_ID_t;
$Reponse_t = KINTPV_EnvoyerRequete($Requete_t,$Data_t);	// reponse xml !	

// Visualisation de la reponse
echo $Reponse_t;
// ===============================================================================
// ===============================================================================



//	   _______________
//	__/ Les fonctions \_______________________________________________________
//	
//	KINTPV_GenererCle		($ChainePourCle)
//	KINTPV_EnvoyerRequete	($fonctionKinTPV,$donnees)
//////////////////////////////////////////////////////////////////////////////

// ===============================================================================
	function KINTPV_GenererCle($ChainePourCle)
	{
		global $CleKinTPV;
		
		// --------------------
		//0. Initialisation
		// --------------------
		$Matrice_a=$CleKinTPV; // chaine de 20 caracteres identique  celle dfinie dans KinTPV
		$KIN_ID_a='000000000'; // chaine de 9 caracteres
		$PositionCle_i=0;
		$ChiffreALaPosition_i=0;
		
		$MaxCarMatrice_i=strlen($Matrice_a);
		$MaxCarCle_i=strlen($KIN_ID_a);
		
		// -----------------------------------------------------------------------------
		//1. On doit boucler caractre par caractre pour la cration de la cl (KIN_ID)
		// -----------------------------------------------------------------------------
		for($i=0;$i<strlen($ChainePourCle);$i++)
		{
			// Recup du code ASCII
			$Car_a=substr($ChainePourCle,$i,1);
			$CodeCar_i=ord($Car_a);
			
			// ---------------------------------------
			//2. Recherche dans la matrice du chiffre
			// ---------------------------------------
			// Calcul de la position
			$PositionCle_i=(($CodeCar_i+$ChiffreALaPosition_i)%$MaxCarMatrice_i)+1;
			
			// Recup du chiffre dans la matrice
			$ChiffreALaPosition_i=intval(substr($Matrice_a,($PositionCle_i-1),1));
			
			// ---------------------------------------
			//3. Cration de la cl (KIN_ID) 
			// ---------------------------------------
			// On doit faire tourner la cl KIN_ID suivant le chiffre rcupr dans la matrice
			// On tourne par la gauche
			if($ChiffreALaPosition_i!=9)
			{
				$ChaineATourner_t=substr($KIN_ID_a,0,$ChiffreALaPosition_i);
				$KIN_ID_a.=$ChaineATourner_t;
				$KIN_ID_a=substr($KIN_ID_a,$ChiffreALaPosition_i,$MaxCarCle_i);
			}
			
			// On ajout le (code ASCII + Chiffre a la position) au KIN_ID
			$KIN_ID_i=intval($KIN_ID_a)+($CodeCar_i+$ChiffreALaPosition_i);
			
			// On retransforme KIN_ID en Chaine
			$KIN_ID_a=strval($KIN_ID_i);
			
			//Ajout des caractres manquants
			if(strlen($KIN_ID_a) < $MaxCarCle_i)
			{
				for($inc=0;$inc < $MaxCarCle_i;$inc++)
				{
					$KIN_ID_a='0'.$KIN_ID_a;
				}
			}
			
			// On ne rcup que 9 caracteres max
			$PosDebut_i=strlen($KIN_ID_a)-$MaxCarCle_i;
			$KIN_ID_a=substr($KIN_ID_a,$PosDebut_i,$MaxCarCle_i);
		}
		
		return $KIN_ID_a;
	}
	
	
// ===============================================================================
	function KINTPV_EnvoyerRequete($fonctionKinTPV,$donnees)
	{
		global $HOST;
		global $PORT;
		
		$sock = fsockopen($HOST, $PORT, $errno, $errstr);
		if (!$sock)
		{
			die("[ERROR] $errstr ($errno)\n");
		}
	
		// ----- ENVOI DES DONNEES -----
		fputs($sock, "POST /KinTPV_Request/".$fonctionKinTPV." HTTP/1.0\r\n");
		fputs($sock, "Host:".$HOST." \r\n");
		fputs($sock, "Content-type: application/x-www-form-urlencoded\r\n");	// dfinition du format
		fputs($sock, "Content-length: " . strlen($donnees) . "\r\n");			// taille
		fputs($sock, "Accept: */*\r\n"); // donnes acceptes par le navigateur
		// On envoi les donnes
		fputs($sock, "\r\n");			// Ligne de sparation
		fputs($sock, "$donnees\r\n");	// Envoi des donnes
		fputs($sock, "\r\n");			// Ligne de sparation
		
	
		// ----- RECEPTION DE LA REPONSE -----
		$headers = "";
		while ($str = trim(fgets($sock, 4096)))
		  $headers .= "$str\n";
		
		$body = "";
		while (!feof($sock))
		  $body .= fgets($sock, 4096);
		
		fclose($sock);
		
		// On retourne le corps de la rponse.
		return $body;
	}


?>