// ----------------------------------------------------
// KINHELIOS
// ----------------------------------------------------
// BBA - 26/01/2011
// ----------------------------------------------------
// Gestion de l'objet PANIER
// ----------------------------------------------------


// ------------------------------------------------------------------------------------------------
// DECLARATION DU L'OBJET PANIER
function obj_panier(cheminTemplate,obj_parent)
{
	//----- "Properties" de l'objet
	
	// Tableau pour la gestion des lignes de panier
	this.panier_liste = new Array();
	this.MontantTotal = 0;
	this.monDoc = obj_parent;
	this.template = ""; 
	
	objCourant = this;
	
	// Pour appeler un fichier externe
//	$.get(cheminTemplate,function(objRetour)
//	{
//		document.gestPrincipal.charge_templatePanier(objRetour);
//	},'html');
	
	this.template = "<div class='PanierLigne' id='PanierLigne__NUM_LIGNE__' onclick='AFF_ArticleChoix(&quot;PANIER&quot;,__ID_ARTICLE__,0,__VTE_QTE__,&quot;__DECLICode__&quot;,__NUM_LIGNE__);return false;'>";
	this.template = this.template + "<p class='LigneBoite LigneNom'>__ART_NOM__</p>";
	this.template = this.template + "<p class='LigneBoite LigneCB'>__ART_CB__</p>";
	this.template = this.template + "<p class='LigneBoite LigneQte'>__VTE_QTE__x</p>";
	this.template = this.template + "<p class='LigneBoite LigneMt'>__VTE_PV__</p>";
	this.template = this.template + "<div class='LigneBoite LigneModif'><img class='img_modif' src='image/chevron.png'></div>";	
	this.template = this.template + "</div>";
}

// ----------------------------------------------------
// METHODE DE L'OBJET PANIER
// ----------------------------------------------------

// ----------------------------------------------------
// Ajout d'une ligne dans le panier
obj_panier.prototype.ajouterArticle = function() 
{
	var LigneAjout = new obj_rech_ligne($('input[name=idArticle]').val(),$('input[name=nomArticle]').val(),$('input[name=codeBarre]').val(),$('input[name=decliLibel]').val(),$('input[name=decliCode]').val(),$('input[name=prixUnitaire]').val(),$('input[name=vteQte]').val(),$('input[name=prixLigne]').val(),false);
	this.panier_liste.push(new obj_panier_ligne(LigneAjout));	 	
}

// ----------------------------------------------------
// Affichage de la liste du panier
obj_panier.prototype.listePanier_Afficher = function()
{
	var LignePanierBase = this.template;
	
	
	
	var LignePanier = "";
	var Tableau = "";
	this.MontantTotal = 0; //"0.00";
		
	var regARTNOM = new RegExp("__ART_NOM__", "g");
	var regARTCB = new RegExp("__ART_CB__", "g");
	var regARTDECLI = new RegExp("__ART_DECLI__", "g");
	var regARTDECLICode = new RegExp("__DECLICode__", "g");
	var regQTE = new RegExp("__VTE_QTE__", "g");
	var regPV = new RegExp("__VTE_PV__", "g");
	var regARTID = new RegExp("__ID_ARTICLE__", "g");
    var regNumLigne = new RegExp("__NUM_LIGNE__", "g");
	
	//++++++++++++++++++++++++++++++++++++++++++++++++
	// On boucle sur chaque ligne pour l'affichage
	for (i=0; i<this.panier_liste.length; i++)
	{
		LignePanier = LignePanierBase;
			
		var DecliRef = this.panier_liste[i].codeBarre;
			
		if(this.panier_liste[i].decliLibel != "")
		{
			DecliRef = "<span class='LigneDecli'>"+this.panier_liste[i].decliLibel + "</span>&nbsp;&nbsp;" + DecliRef;
		}
			
		// Il faut remplacer les variables par leur valeur
		LignePanier=LignePanier.replace(regARTNOM, this.panier_liste[i].nomArticle);
		LignePanier=LignePanier.replace(regARTCB, DecliRef);
		LignePanier=LignePanier.replace(regQTE, this.panier_liste[i].qte);
		var affMt=UTI_Format_Number(this.panier_liste[i].prixLigne);
		LignePanier=LignePanier.replace(regPV, affMt);
		LignePanier=LignePanier.replace(regARTID, this.panier_liste[i].idArticle);
		LignePanier=LignePanier.replace(regARTDECLICode, this.panier_liste[i].decliCode);
      	LignePanier=LignePanier.replace(regNumLigne, i);
		Tableau = Tableau + LignePanier;
			
    	this.MontantTotal = parseFloat(this.MontantTotal)+parseFloat(this.panier_liste[i].prixLigne);
	}
		
	//++++++++++++++++++++++++++++++++++++++++++++++++
	// On remplace dans l'html de base							
	this.monDoc.getElementById("panier_data").innerHTML = Tableau;
	  
	//++++++++++++++++++++++++++++++++++++++++++++++++
	// On affiche le total du panier
	var affMt=UTI_Format_Number(this.MontantTotal);
	this.monDoc.getElementById("panier_montant").innerHTML = affMt;
	    
	//++++++++++++++++++++++++++++++++++++++++++++++++
	// On envoie un message au gestionnaire d'écran
	this.monDoc.gestPrincipal.AFF_Ecran_Init("#bt_retour");
}

// ----------------------------------------------------
// Envoi de la liste du panier
obj_panier.prototype.listePanier_Envoyer = function()
{
	var NbElm = this.panier_liste.length;
	var EnvoiTxt = "";
	var datejour = new Date();
	
	// Vérif si des ligne de panier à envoyer
	if(NbElm > 0)
	{	
		// Num unique pour détection mode vente déportée
		// négatif = vente déportée
		EnvoiTxt=EnvoiTxt+"VT_NumUniqueWeb="+"-99";
	 	
	 	var TXT="&VT_MontantVente=" + this.MontantTotal;
	 	TXT=TXT.replace(".",",");
		EnvoiTxt=EnvoiTxt+TXT;
		
		EnvoiTxt=EnvoiTxt+"&VT_CodeClient="+"";
		
		EnvoiTxt=EnvoiTxt+"&VT_NbDetails="+NbElm;
		EnvoiTxt=EnvoiTxt+"&VT_Date="+datejour.getDate()+"/"+(datejour.getMonth()+1)+"/"+datejour.getFullYear();
		EnvoiTxt=EnvoiTxt+"&VT_Heure="+datejour.getHours()+":"+datejour.getMinutes()+":"+datejour.getSeconds();
				
		EnvoiTxt=EnvoiTxt+"&LV_Nom="+"";
		EnvoiTxt=EnvoiTxt+"&LV_Adresse="+"";
			
		EnvoiTxt=EnvoiTxt+"&CLI_Civilite="+"";
		EnvoiTxt=EnvoiTxt+"&CLI_Prenom="+"";
		EnvoiTxt=EnvoiTxt+"&CLI_Nom="+"";
		EnvoiTxt=EnvoiTxt+"&CLI_Societe="+"";
		EnvoiTxt=EnvoiTxt+"&CLI_Adr1="+"";
		EnvoiTxt=EnvoiTxt+"&CLI_Adr2="+"";
		EnvoiTxt=EnvoiTxt+"&CLI_Adr3="+"";
		EnvoiTxt=EnvoiTxt+"&CLI_Adr4="+"";
		EnvoiTxt=EnvoiTxt+"&CLI_CodePostal="+"";
		EnvoiTxt=EnvoiTxt+"&CLI_Ville="+"";
		EnvoiTxt=EnvoiTxt+"&CLI_DateNaissance="+"";
		EnvoiTxt=EnvoiTxt+"&CLI_TelM="+"";
		EnvoiTxt=EnvoiTxt+"&CLI_TelP="+"";
		EnvoiTxt=EnvoiTxt+"&CLI_TelT="+"";
		EnvoiTxt=EnvoiTxt+"&CLI_Email="+"";
	 			
	 	var RefLigne=0;	
	 			 	
		for (i=0; i<NbElm; i++)
		{
			if(EnvoiTxt!=""){EnvoiTxt=EnvoiTxt+"&";}
				
			RefLigne=i+1
				
			if(RefLigne<10)
			{
				RefLigne="0"+RefLigne
			}
				
				
			EnvoiTxt=EnvoiTxt+"VT_IdArticle_"+RefLigne+"="+this.panier_liste[i].idArticle;
			EnvoiTxt=EnvoiTxt+"&VT_Qte_"+RefLigne+"="+this.panier_liste[i].qte;
			EnvoiTxt=EnvoiTxt+"&VT_PrixVente_"+RefLigne+"="+this.panier_liste[i].prixUnitaire;
			EnvoiTxt=EnvoiTxt+"&VT_CodeBarre_"+RefLigne+"="+this.panier_liste[i].codeBarre;
			EnvoiTxt=EnvoiTxt+"&VT_Reference_"+RefLigne+"="+this.panier_liste[i].idArticle+"-"+this.panier_liste[i].decliCode;
		}
		  
		this.monDoc.gestRequete.REQ_doAjaxFct("panier_data","get","/KinTPV_Request/VT_RECUP",EnvoiTxt,"","","",this);
	}
}

// ----------------------------------------------------
// Vider la liste du panier
obj_panier.prototype.listePanier_Vider = function()
{
	var NbElm = this.panier_liste.length;
	 	
	for (i=0; i<NbElm; i++)
	{
		this.panier_liste.pop();
	}
	
	this.listePanier_Afficher();
}

// ----------------------------------------------------
// Modifier la liste du panier
obj_panier.prototype.listePanier_Modifier = function()
{
	// sauvegarde des modification dans le tableau du panier
	var vIndex=$('input[name=numLigne]').val();
	 	
	this.panier_liste[vIndex].idArticle=$('input[name=idArticle]').val();
	this.panier_liste[vIndex].nomArticle=$('input[name=nomArticle]').val();
	this.panier_liste[vIndex].codeBarre=$('input[name=codeBarre]').val();
	this.panier_liste[vIndex].decliLibel=$('input[name=decliLibel]').val();
	this.panier_liste[vIndex].decliCode=$('input[name=decliCode]').val();
	this.panier_liste[vIndex].prixUnitaire=parseFloat($('input[name=prixUnitaire]').val());
	this.panier_liste[vIndex].qte=$('input[name=vteQte]').val();
	this.panier_liste[vIndex].prixLigne=parseFloat($('input[name=prixLigne]').val());
}


// ------------------------------------------------------------------------------------------------
// DECLARATION DU L'OBJET LIGNE PANIER
function obj_panier_ligne(ligne_rechercheListe)
{
	//----- "Properties" de l'objet
	
	this.idArticle=ligne_rechercheListe.idArticle;
	this.nomArticle=ligne_rechercheListe.nomArticle;
	this.codeBarre=ligne_rechercheListe.codeBarre;
	this.decliLibel=ligne_rechercheListe.decliLibel;
	this.decliCode=ligne_rechercheListe.decliCode;
	this.prixUnitaire=parseFloat(ligne_rechercheListe.prixUnitaire);
	this.qte=ligne_rechercheListe.qte;
	this.prixLigne=parseFloat(ligne_rechercheListe.prixLigne);
}