<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns="http://www.w3.org/2000/svg"
                xmlns:exsl4D="http://www.4D.com"
                xmlns:math="http://exslt.org/math"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                >
  <xsl:output method="xml" encoding="UTF-8" indent="yes" />

  <!-- gradient templates -->
  <xsl:template name="gradient_defs">
    <xsl:param name="grad1_color1" />
    <xsl:param name="grad1_color2" />
    <xsl:param name="grad2_color1" />
    <xsl:param name="grad2_color2" />
    <xsl:param name="grad3_color1" />
    <xsl:param name="grad3_color2" />
    <xsl:param name="grad4_color1" />
    <xsl:param name="grad4_color2" />
    <xsl:param name="shadow_color" select="'black'"/>
    <xsl:param name="x1" select="0"/>
    <xsl:param name="y1" select="0"/>
    <xsl:param name="x2" select="0"/>
    <xsl:param name="y2" select="1"/>
    <xsl:param name="units" select="'objectBoundingBox'"/>
    <linearGradient id="ID_grad1" gradientUnits="{$units}" x1="{$x1}" y1="{$y1}" x2="{$x2}" y2="{$y2}">
      <stop stop-color="{$grad1_color1}"  offset="0"/>
      <stop stop-color="{$grad1_color2}"  offset="1"/>
    </linearGradient>
    <linearGradient id="ID_grad2" gradientUnits="{$units}" x1="{$x1}" y1="{$y1}" x2="{$x2}" y2="{$y2}">
      <stop stop-color="{$grad2_color1}"  offset="0"/>
      <stop stop-color="{$grad2_color2}"  offset="1"/>
    </linearGradient>
    <linearGradient id="ID_grad3" gradientUnits="{$units}" x1="{$x1}" y1="{$y1}" x2="{$x2}" y2="{$y2}">
      <stop stop-color="{$grad3_color1}"  offset="0"/>
      <stop stop-color="{$grad3_color2}"  offset="1"/>
    </linearGradient>
    <linearGradient id="ID_grad4" gradientUnits="{$units}" x1="{$x1}" y1="{$y1}" x2="{$x2}" y2="{$y2}">
      <stop stop-color="{$grad4_color1}"  offset="0"/>
      <stop stop-color="{$grad4_color2}"  offset="1"/>
    </linearGradient>

    <radialGradient id="ID_grad_shadow" gradientUnits="objectBoundingBox" cx="0.5" cy="0.5" fx="0.5" fy="0.5" r="0.49" >
      <stop stop-color="{$shadow_color}"  stop-opacity="1.0" offset="0.5"/>
      <stop stop-color="{$shadow_color}"  stop-opacity="0.0" offset="1"/>
    </radialGradient>
  </xsl:template>



  <!-- filter templates -->
  <xsl:template name="filter_defs">

    <xsl:param name="shadow_deviation" select="3"/>

    <filter id="soft_blur">
      <feGaussianBlur in="SourceGraphic" result="BlurAlpha" stdDeviation="{$shadow_deviation}"/>
    </filter>

	<filter id="pastel">
	  <feGaussianBlur in="SourceAlpha" stdDeviation="2" result="blur"/>
	  <feOffset in="blur" dx="6" dy="6" result="offsetBlur"/>
	 <feComposite in="SourceGraphic" in2="offsetBlur" operator="in" result="specOut"/>
    </filter>

	<filter id="blur_shadow">
		<feGaussianBlur in="SourceAlpha" result="blur" stdDeviation="3"/>
		<feOffset dx="4" dy="2" in="blur" result="offsetBlur"/>
		<feBlend in="SourceGraphic" in2="offsetBlur" mode="normal"/>
	</filter>
	
    <filter filterUnits="objectBoundingBox" id="Shadow" >
      <feGaussianBlur in="SourceAlpha" result="flou" stdDeviation="0"/>
      <feColorMatrix type="matrix" in="SourceAlpha"
           values=" 0 0 0 0 0 
                    0 0 0 0 0
                    0 0 0 0 0 
                    0 0 0 0.3 0" result="flouBlue"/>
      <feOffset dx="4" dy="4" in="flouBlue" result="flouDecalage"/>
      <feBlend mode="normal" in="SourceGraphic" in2="flouDecalage"/>
    </filter>

	<filter id="SaturateMinus" filterUnits="objectBoundingBox" 
            x="0%" y="0%" width="100%" height="100%">
      <feColorMatrix type="saturate" in="SourceGraphic" values="0.5"/>
    </filter>
	<filter id="SaturatePlus" filterUnits="objectBoundingBox" 
            x="0%" y="0%" width="100%" height="100%">
      <feColorMatrix type="saturate" in="SourceGraphic" values="1.4"/>
    </filter>

<!-- gradient templates -->

	<linearGradient id="BlackGradient" >
		<stop offset="0%" style="stop-color:rgb(0,0,0); stop-opacity:0"/>
		<stop offset="100%" style="stop-color:rgb(0,0,0); stop-opacity:0.1"/>
	</linearGradient>
	<linearGradient id="WhiteGradient" x1="0%" x2="100%" y1="0%" y2="0%">
		<stop offset="0%" style="stop-color:rgb(255,255,255); stop-opacity:0.3"/>
		<stop offset="100%" style="stop-color:rgb(255,255,255);stop-opacity:0"/>
	</linearGradient>
	<linearGradient id="WhiteBlackGradient" x1="0%" x2="100%" y1="0%" y2="0%">
		<stop offset="0%" style="stop-color:rgb(255,255,255); stop-opacity:0.15"/>
		<stop offset="100%" style="stop-color:rgb(0,0,0);stop-opacity:0.15"/>
	</linearGradient>
	<linearGradient id="Black0Black1Gradient" x1="0%" x2="0%" y1="0%" y2="100%">
		<stop offset="0%" style="stop-color:rgb(0,0,0); stop-opacity:0"/>
		<stop offset="100%" style="stop-color:rgb(0,0,0);stop-opacity:0.05"/>
	</linearGradient>

  </xsl:template>


  <!-- legend border template -->
  <xsl:template name="legend_border">
    <xsl:param name="x" select="'0%'"/>
    <xsl:param name="y" select="'0%'"/>
    <xsl:param name="rx" select="10"/>
    <xsl:param name="ry" select="10"/>
    <xsl:param name="width" select="'100%'"/>
    <xsl:param name="height" select="'100%'"/>
    <xsl:param name="fill-color" select="'none'" />
    <xsl:param name="fill-opacity" select="1" />
    <xsl:param name="stroke-color" select="'black'" />
    <xsl:param name="stroke-width" select="12" />
    <xsl:param name="shadow_fill_color" select = "'rgb(168,168,168)'"/>
    <xsl:param name="shadow_fill_opacity" select = "1"/>
    <xsl:param name="shadow_shift_x" select = "1"/> 
    <xsl:param name="shadow_shift_y" select = "1"/> 
    <rect id="ID_legend_border_shadow" x="{$x+$shadow_shift_x}" y="{$y+$shadow_shift_y}" width="{$width}" height="{$height}" rx="{$rx}" ry="{$ry}" stroke="none" fill="{$shadow_fill_color}" fill-opacity="{$shadow_fill_opacity}"/> 
    <rect id="ID_legend_border" x="{$x}" y="{$y}" width="{$width}" height="{$height}" stroke="{$stroke-color}" stroke-width="{$stroke-width}" fill="{$fill-color}" fill-opacity="{$fill-opacity}" rx="{$rx}" ry="{$ry}" />
  </xsl:template>

  <!-- legend bullet template -->
  <xsl:template name="legend_bullet">
    <xsl:param name="x" select="'0%'"/>
    <xsl:param name="y" select="'0%'"/>
    <xsl:param name="width" select="'100%'"/>
    <xsl:param name="height" select="'100%'"/>
    <xsl:param name="r" select = "3"/> 
    <xsl:param name="fill" select="'none'"/>
    <xsl:param name="filter" select="'none'" />
    <xsl:param name="id" select="'0'" />  <!-- Added by RL Mai 2011 -->
    <xsl:param name="stroke" select="'black'"/>
    <xsl:param name="stroke-width" select="'1'"/>
	<g id="{$id}" fill="{$fill}">
		<rect x="{$x}" y="{$y}" width="{$width}" height="{$height}" rx="{$r}" ry="{$r}"/>
		<rect x="{$x}" y="{$y}" width="{$width}" height="{$height}" rx="{$r}" ry="{$r}" fill="url(#WhiteBlackGradient)"/>
    	<rect x="{$x}" y="{$y}" width="{$width}" height="{$height}" rx="{$r}" ry="{$r}" fill-opacity="0.3"  filter="url(#SaturateMinus)"/>	
	</g>
  </xsl:template>


  <!-- graph background template -->
  <xsl:template name="graph_background">
    <xsl:param name="x" />
    <xsl:param name="y" />
    <xsl:param name="width" />
    <xsl:param name="height" />
    <xsl:param name="y0" />
    <xsl:param name="top_fill" />
    <xsl:param name="bottom_fill" /> 
    <xsl:param name="r" select = "10"/> 
    <xsl:param name="shadow_fill_color" select = "'rgb(168,168,168)'"/>
    <xsl:param name="shadow_fill_opacity" select = "1"/>
    <xsl:param name="shadow_shift_x" select = "1"/> 
    <xsl:param name="shadow_shift_y" select = "1"/>
 

	  <!-- background shadow (in background) -->
	    <rect id= "ID_background_shadow" x="{$x+$shadow_shift_x}" y="{$y+$shadow_shift_y}" width="{$width}" height="{$height}" rx="{$r}" ry="{$r}" stroke="none" fill="{$shadow_fill_color}" fill-opacity="{$shadow_fill_opacity}" visibility = "visible"/> 
		<g id= "ID_background" fill="{$top_fill}" visibility = "visible">
	  		<!-- background -->
	    	<rect  x="{$x}" y="{$y}" width="{$width}" rx="{$r}" ry="{$r}" height="{$height}" stroke="none" />
	  		<!-- background gradient-->
	    	<rect x="{$x}" y="{$y}" width="{$width}" rx="{$r}" ry="{$r}" height="{$height}" stroke="none" fill="url(#Black0Black1Gradient)"/>
		</g>
	<!-- CliPath for future shadows -->
		<clipPath id="ID_backgroundClipPath">
			<rect  x="{$x}" y="{$y}" width="{$width+1}" height="{$height+1}" rx="{$r}" ry="{$r}" />
		</clipPath>

  </xsl:template>


  <!-- graph circular background template -->
  <xsl:template name="graph_background_c">
    <xsl:param name="x" />
    <xsl:param name="y" />
    <xsl:param name="width" />
    <xsl:param name="height" />
    <xsl:param name="top_fill" />
    <xsl:param name="bottom_fill" /> 

    <xsl:param name="shadow_fill_color" select = "'rgb(168,168,168)'"/>
    <xsl:param name="shadow_fill_opacity" select = "1"/>
    <xsl:param name="shadow_shift_x" select = "1"/> 
    <xsl:param name="shadow_shift_y" select = "1"/> 


	  <!-- background shadow (in background) -->
	    <ellipse id= "ID_background_shadow" cx="{$x+($width div 2)+$shadow_shift_x}" cy="{$y+($height div 2)+$shadow_shift_y}" rx="{$width div 2}" ry="{$height div 2}" stroke="none" fill="{$shadow_fill_color}" fill-opacity="{$shadow_fill_opacity}" visibility = "visible"/> 
	  <!-- background -->
	    <ellipse id="ID_background" cx="{$x+($width div 2)}" cy="{$y+($height div 2)}" rx="{$width div 2}" ry="{$height div 2}" stroke="none" fill="{$top_fill}" visibility = "visible"/>
	  <!-- background gradient-->
	    <ellipse cx="{$x+($width div 2)}" cy="{$y+($height div 2)}" rx="{$width div 2}" ry="{$height div 2}" stroke="none" fill="url(#Black0Black1Gradient)" visibility = "visible"/>
	  <!-- CliPath for future shadows -->
		<clipPath id="ID_backgroundClipPath">
			<ellipse cx="{$x+($width div 2)}" cy="{$y+($height div 2)}" rx="{$width div 2}" ry="{$height div 2}"/>
		</clipPath>

  </xsl:template>


 <!-- Default colors (CUBE DESIGNER 17/08/2011)-->
 <xsl:param name="default_color1" select="'rgb(0,178,195)'"/>
 <xsl:param name="default_color2" select="'rgb(255,195,56)'"/>
 <xsl:param name="default_color3" select="'rgb(87,62,130)'"/>
 <xsl:param name="default_color4" select="'rgb(79,168,57)'"/>
 <xsl:param name="default_color5" select="'rgb(217,87,0)'"/>
 <xsl:param name="default_color6" select="'rgb(29,157,242)'"/>
 <xsl:param name="default_color7" select="'rgb(181,207,50)'"/>
 <xsl:param name="default_color8" select="'rgb(212,58,38)'"/>


  <!-- column bar template -->
    <xsl:template name="bar_r">
    <xsl:param name="bar_index" select="1"/>
    <xsl:param name="x" select="'0%'"/>
    <xsl:param name="y" select="'0%'"/>
    <xsl:param name="width" select="'100%'"/>
    <xsl:param name="height" select="'100%'"/>
    <xsl:param name="r" select="0"/>

	<rect x="{$x}" y="{$y}" width="{$width}" height="{$height}" rx="{$r}" ry="{$r}"/>
	<rect x="{$x}" y="{$y}" width="{$width}" height="{$height}" rx="{$r}" ry="{$r}" fill="url(#WhiteBlackGradient)"/>
    <rect x="{$x}" y="{$y}" width="{$width}" height="{$height}" rx="{$r}" ry="{$r}" fill-opacity="0.3"  filter="url(#SaturateMinus)"/>	
	
  </xsl:template>

  <!-- column bar SHADOW template -->
    <xsl:template name="bar_r_shadow">
    <xsl:param name="bar_index" select="1"/>
    <xsl:param name="x" select="'0%'"/>
    <xsl:param name="y" select="'0%'"/>
    <xsl:param name="width" select="'100%'"/>
    <xsl:param name="height" select="'100%'"/>
    <xsl:param name="r" select="0"/>

    <rect x="{$x}" y="{$y}" width="{$width}" height="{$height}" rx="{$r}" ry="{$r}"/>

  </xsl:template>



  <!-- column bar template rounded TOP-->
    <xsl:template name="bar_r_top">
    <xsl:param name="bar_index" select="1"/>
    <xsl:param name="x" select="'0%'"/>
    <xsl:param name="y" select="'0%'"/>
    <xsl:param name="width" select="'100%'"/>
    <xsl:param name="height" select="'100%'"/>
    <xsl:param name="r" select="8"/>

	<path  d="
		M {$x} {$y+$r}
		s 0 {($r)*(-1)} {$r} {($r)*(-1)}
		l {($width)-($r*2)} 0
		s {$r} 0 {$r} {$r}
		l 0 {($height)-($r)}	
		l {$width*(-1)} 0	
		l 0 {(($height)-$r)*(-1)}
		z"
		/>
	<path  d="
		M {$x} {$y+$r}
		s 0 {($r)*(-1)} {$r} {($r)*(-1)}
		l {($width)-($r*2)} 0
		s {$r} 0 {$r} {$r}
		l 0 {($height)-($r)}	
		l {$width*(-1)} 0	
		l 0 {(($height)-$r)*(-1)}
		z"
		fill="url(#WhiteBlackGradient)"/>
	<path  d="
		M {$x} {$y+$r}
		s 0 {($r)*(-1)} {$r} {($r)*(-1)}
		l {($width)-($r*2)} 0
		s {$r} 0 {$r} {$r}
		l 0 {($height)-($r)}	
		l {$width*(-1)} 0	
		l 0 {(($height)-$r)*(-1)}
		z"
		fill-opacity="0.3"  filter="url(#SaturateMinus)"/>

    </xsl:template>

  <!-- column bar template rounded top SHADOW -->
    <xsl:template name="bar_r_top_shadow">
    <xsl:param name="bar_index" select="1"/>
    <xsl:param name="x" select="'0%'"/>
    <xsl:param name="y" select="'0%'"/>
    <xsl:param name="width" select="'100%'"/>
    <xsl:param name="height" select="'100%'"/>
    <xsl:param name="r" select="8"/>

	<path  d="
		M {$x} {$y+$r}
		s 0 {($r)*(-1)} {$r} {($r)*(-1)}
		l {($width)-($r*2)} 0
		s {$r} 0 {$r} {$r}
		l 0 {($height)-($r)}	
		l {$width*(-1)} 0	
		l 0 {(($height)-$r)*(-1)}
		z"
		/>
    </xsl:template>


  <!-- column bar template rounded BOTTOM-->
    <xsl:template name="bar_r_btm">
    <xsl:param name="bar_index" select="1"/>
    <xsl:param name="x" select="'0%'"/>
    <xsl:param name="y" select="'0%'"/>
    <xsl:param name="width" select="'100%'"/>
    <xsl:param name="height" select="'100%'"/>
    <xsl:param name="r" select="8"/>

	<path  d="
		M {$x} {$y}
		l {$width} 0
		l 0 {($height)-($r)}
		s 0 {$r} {$r*(-1)} {$r}	
		l {(($width)-($r*2))*(-1)} 0
		s {($r)*(-1)} 0 {($r)*(-1)} {($r)*(-1)}
		l 0 {(($height)-$r)*(-1)}
		z"
		/>			
	<path  d="
		M {$x} {$y}
		l {$width} 0
		l 0 {($height)-($r)}
		s 0 {$r} {$r*(-1)} {$r}	
		l {(($width)-($r*2))*(-1)} 0
		s {($r)*(-1)} 0 {($r)*(-1)} {($r)*(-1)}
		l 0 {(($height)-$r)*(-1)}
		z"
		fill="url(#WhiteBlackGradient)"/>	
	<path  d="
		M {$x} {$y}
		l {$width} 0
		l 0 {($height)-($r)}
		s 0 {$r} {$r*(-1)} {$r}	
		l {(($width)-($r*2))*(-1)} 0
		s {($r)*(-1)} 0 {($r)*(-1)} {($r)*(-1)}
		l 0 {(($height)-$r)*(-1)}
		z"
		fill-opacity="0.3"  filter="url(#SaturateMinus)"/>		
    </xsl:template>


  <!-- column bar template rounded BOTTOM-->
    <xsl:template name="bar_r_btm_shadow">
    <xsl:param name="bar_index" select="1"/>
    <xsl:param name="x" select="'0%'"/>
    <xsl:param name="y" select="'0%'"/>
    <xsl:param name="width" select="'100%'"/>
    <xsl:param name="height" select="'100%'"/>
    <xsl:param name="r" select="8"/>

	<path  d="
		M {$x} {$y}
		l {$width} 0
		l 0 {($height)-($r)}
		s 0 {$r} {$r*(-1)} {$r}	
		l {(($width)-($r*2))*(-1)} 0
		s {($r)*(-1)} 0 {($r)*(-1)} {($r)*(-1)}
		l 0 {(($height)-$r)*(-1)}
		z"
		/>			
    </xsl:template>


  <!-- line bullet template -->
  <xsl:template name="line_bullet">
    <xsl:param name="cx" />
    <xsl:param name="cy" />
    <xsl:param name="r" />
	<xsl:variable name="r2" select="$r"/>

    <circle cx="{$cx}" cy="{$cy}" r="{$r2}" fill-opacity="1" />
    <circle cx="{$cx}" cy="{$cy}" r="{$r}" fill="url(#WhiteGradient)"/>
    <circle cx="{$cx}" cy="{$cy}" r="{$r}" fill-opacity="0.4"  filter="url(#SaturateMinus)"/>
    <circle cx="{$cx}" cy="{$cy}" r="{$r}" fill="url(#BlackGradient)"/>

  </xsl:template>


  <!-- line bullet template 2-->
  <xsl:template name="line_bullet_2">
    <xsl:param name="cx" />
    <xsl:param name="cy" />
    <xsl:param name="r" />

	<xsl:variable name="x1" select="($cx)-($r div 2)"/>
	<xsl:variable name="y1" select="($cy)-($r div 2)"/>
	<xsl:variable name="rx" select="$r div 8"/>

	<rect x="{$x1}" y="{$y1}" width="{$r}" height="{$r}" rx="{$rx}" ry="{$rx}"/>
	<rect x="{$x1}" y="{$y1}" width="{$r}" height="{$r}" rx="{$rx}" ry="{$rx}" fill="url(#WhiteBlackGradient)"/>
    <rect x="{$x1}" y="{$y1}" width="{$r}" height="{$r}" rx="{$rx}" ry="{$rx}" fill-opacity="0.3"  filter="url(#SaturateMinus)"/>	
				
  </xsl:template>


  <!-- line template -->
  <xsl:template name="line">
    <xsl:param name="x1" />
    <xsl:param name="y1" />
    <xsl:param name="x2" />
    <xsl:param name="y2" />
    <line x1="{$x1}" y1="{$y1}" x2="{$x2}" y2="{$y2}" fill-opacity="1"/>

  </xsl:template>



  <!-- pie piece template -->
  <xsl:template name="pie">
    <xsl:param name="cx" />
    <xsl:param name="cy" />
    <xsl:param name="ray" />
    <xsl:param name="start" />
    <xsl:param name="end" />
    <xsl:param name="large_arc" />
 	<xsl:param name="shift" />

	<xsl:variable name="pi" select="math:constant('PI',6)"/>
	<xsl:variable name="pi2" select="$pi * 2"/>
	<xsl:variable name="arc" select="exsl4D:max($pi div 20,$end - $start)"/>

    <xsl:variable name="shiftx" select="(math:cos(($end+$start) div 2)) * $shift * ($pi2 div $arc)  "/>
    <xsl:variable name="shifty" select="(math:sin(($end+$start) div 2)) * $shift * ($pi2 div $arc)  "/>
	<xsl:variable name="r"      select="exsl4D:max(1,$ray - ($shift * ($pi2 div $arc)))"/>

    <xsl:variable name="startx" select="math:cos($start)*$r"/>
    <xsl:variable name="starty" select="math:sin($start)*$r"/>
    <xsl:variable name="endx"   select="math:cos($end)*$r"/>
    <xsl:variable name="endy"   select="math:sin($end)*$r"/>

    <path d="M{$cx+$shiftx},{$cy+$shifty} l{$startx},{$starty} A{$r},{$r} 0 {$large_arc},1 {$cx+$endx+$shiftx},{$cy+$endy+$shifty} z" />
    <path d="M{$cx+$shiftx},{$cy+$shifty} l{$startx},{$starty} A{$r},{$r} 0 {$large_arc},1 {$cx+$endx+$shiftx},{$cy+$endy+$shifty} z" fill="url(#WhiteBlackGradient)"/>	
    <path d="M{$cx+$shiftx},{$cy+$shifty} l{$startx},{$starty} A{$r},{$r} 0 {$large_arc},1 {$cx+$endx+$shiftx},{$cy+$endy+$shifty} z" fill-opacity="0.3"  filter="url(#SaturateMinus)"/>

  </xsl:template>


  <!-- pie piece shadow template -->
  <xsl:template name="pie_shadow">
    <xsl:param name="cx" />
    <xsl:param name="cy" />
    <xsl:param name="ray" />
    <xsl:param name="start" />
    <xsl:param name="end" />
    <xsl:param name="large_arc" />
 	<xsl:param name="shift" />

	<xsl:variable name="pi" select="math:constant('PI',6)"/>
	<xsl:variable name="pi2" select="$pi * 2"/>
	<xsl:variable name="arc" select="exsl4D:max($pi div 20,$end - $start)"/>
		
    <xsl:variable name="shiftx" select="(math:cos(($end+$start) div 2)) * $shift * ($pi2 div $arc)  "/>
    <xsl:variable name="shifty" select="(math:sin(($end+$start) div 2)) * $shift * ($pi2 div $arc)  "/>
	<xsl:variable name="r"      select="exsl4D:max(0,$ray - ($shift * ($pi2 div $arc)))"/>

    <xsl:variable name="startx" select="math:cos($start)*$r"/>
    <xsl:variable name="starty" select="math:sin($start)*$r"/>
    <xsl:variable name="endx"   select="math:cos($end)*$r"/>
    <xsl:variable name="endy"   select="math:sin($end)*$r"/>

    <path d="M{$cx+$shiftx},{$cy+$shifty} l{$startx},{$starty} A{$r},{$r} 0 {$large_arc},1 {$cx+$endx+$shiftx},{$cy+$endy+$shifty} z" />

  </xsl:template>


  <!-- circle shadow template -->
  <xsl:template name="circle_shadow">
    <xsl:param name="cx" />
    <xsl:param name="cy" />
    <xsl:param name="r" />
    <xsl:param name="dx" />
    <xsl:param name="dy" />
    <circle cx="{$cx+(($dx*$r) div 100)}" cy="{$cy+(($dy*$r) div 100)}" r="{$r}" fill="url(#ID_grad_shadow)" stroke="none"/>
  </xsl:template>


  <!-- pie piece label template -->
  <xsl:template name="pie_label_percent">
    <xsl:param name="cx" />
    <xsl:param name="cy" />
    <xsl:param name="r" />
    <xsl:param name="sx" />
    <xsl:param name="sy" />
    <xsl:param name="start" />
    <xsl:param name="end" />
    <xsl:param name="pi2" />
    <xsl:param name="format" />

    <xsl:param name="font_size" />
    <xsl:param name="font_descent" />
    <xsl:param name="font_color" />

    <xsl:param name="border_visible" select="1" />
    <xsl:param name="border_margin" select="2" />
    <xsl:param name="border_fill_color" select="'none'" />
    <xsl:param name="border_fill_opacity" select="1" />
    <xsl:param name="border_stroke_color" select="'none'" />
    <xsl:param name="border_stroke_width" select="1" />

    <xsl:variable name="middlex" select="$cx+((math:cos(($start+$end) div 2)*((3*$r) div 2))*$sx)"/>
    <xsl:variable name="middley" select="$cy+((math:sin(($start+$end) div 2)*((3*$r) div 2))*$sy)"/>

    <xsl:call-template name="label_align_middle_shadow">
      <xsl:with-param name="x" select="($cx+$middlex) div 2" />
      <xsl:with-param name="y" select="($cy+$middley) div 2" />
      <xsl:with-param name="text" select="exsl4D:format-number(((($end - $start)*100.0) div $pi2),$format)"/>

      <xsl:with-param name="font_size" select="$font_size"/>
      <xsl:with-param name="font_descent" select="$font_descent"/>
	  <xsl:with-param name="font_color" select="$font_color"/>
	
    </xsl:call-template>


  </xsl:template>


  <!-- label templates -->
  <xsl:template name="label_align_middle">
    <xsl:param name="x" />
    <xsl:param name="y" />
    <xsl:param name="text" />
    
    <xsl:param name="font_size" />
    <xsl:param name="font_descent" />
	<xsl:param name="font_color" />

    <xsl:param name="border_visible" select="1" />
    <xsl:param name="border_margin" select="2" />
    <xsl:param name="border_fill_color" select="'none'" />
    <xsl:param name="border_fill_opacity" select="1" />
    <xsl:param name="border_stroke_color" select="'none'" />
    <xsl:param name="border_stroke_width" select="1" />

    <xsl:variable name="len" select="string-length($text)*($font_size div 2.0)" />
    <xsl:variable name="left" select="$x - $border_margin - ($len div 2)"/>
    <xsl:variable name="top" select="$y - $border_margin - $font_size - $font_descent"/>
    <xsl:variable name="width" select="($border_margin*2) + $len"/>
    <xsl:variable name="height" select="(2*$border_margin) + $font_size + $font_descent"/>

    <xsl:if test="boolean($border_visible)">
      <rect x="{$left}" y="{$top}" width="{$width + 5}" height="{$height - 2}" stroke="{$border_stroke_color}" stroke-width="{$border_stroke_width}" fill="{$border_fill_color}" fill-opacity="{$border_fill_opacity}" rx="0" ry="0" />
    </xsl:if>

    <text text-anchor="middle" x="{$x + 3}" y="{$y - $font_descent - 2}">
      <xsl:value-of select="$text"/>
    </text>

  </xsl:template>



  <!-- label templates with shadow-->
  <xsl:template name="label_align_middle_shadow">
    <xsl:param name="x" />
    <xsl:param name="y" />
    <xsl:param name="text" />
    
    <xsl:param name="font_size" />
    <xsl:param name="font_descent" />
	<xsl:param name="font_color" />

	<!-- TEXT SHADOW -->
	<text text-anchor="middle" fill="black" fill-opacity="0.3" x="{$x + 4}" y="{$y - $font_descent - 1}">
      <xsl:value-of select="$text"/>
    </text>
    
	<!-- TEXT -->
    <text text-anchor="middle" fill="{$font_color}" x="{$x + 3}" y="{$y - $font_descent - 2}">
      <xsl:value-of select="$text"/>
    </text>

  </xsl:template>






  <xsl:template name="label_align_right">
    <xsl:param name="x" />
    <xsl:param name="y" />
    <xsl:param name="text" />

    <xsl:param name="font_size" />
    <xsl:param name="font_descent" />

    <xsl:param name="border_visible" select="1" />
    <xsl:param name="border_margin" select="2" />
    <xsl:param name="border_fill_color" select="'none'" />
    <xsl:param name="border_fill_opacity" select="1" />
    <xsl:param name="border_stroke_color" select="'none'" />
    <xsl:param name="border_stroke_width" select="1" />

    <xsl:variable name="len" select="string-length($text)*($font_size div 2.0)" />
    <xsl:variable name="left" select="$x - $border_margin - $len"/>
    <xsl:variable name="top" select="$y - $border_margin - $font_size - $font_descent"/>
    <xsl:variable name="width" select="($border_margin*2) + $len"/>
    <xsl:variable name="height" select="(2*$border_margin) + $font_size + $font_descent"/>

    <xsl:if test="boolean($border_visible)">
      <rect x="{$left}" y="{$top}" width="{$width}" height="{$height}" stroke="{$border_stroke_color}" stroke-width="{$border_stroke_width}" fill="{$border_fill_color}" fill-opacity="{$border_fill_opacity}" rx="4" ry="4" />
    </xsl:if>
    <text text-anchor="end" x="{$x}" y="{$y - $font_descent}">
      <xsl:value-of select="$text"/>
    </text>
  </xsl:template>

  <xsl:template name="label_align_left">
    <xsl:param name="x" />
    <xsl:param name="y" />
    <xsl:param name="text" />

    <xsl:param name="font_size" />
    <xsl:param name="font_descent" />

    <xsl:param name="border_visible" select="1" />
    <xsl:param name="border_margin" select="2" />
    <xsl:param name="border_fill_color" select="'none'" />
    <xsl:param name="border_fill_opacity" select="1" />
    <xsl:param name="border_stroke_color" select="'none'" />
    <xsl:param name="border_stroke_width" select="1" />

    <xsl:variable name="len" select="string-length($text)*($font_size div 2.0)" />
    <xsl:variable name="left" select="$x - $border_margin"/>
    <xsl:variable name="top" select="$y - $border_margin - $font_size - $font_descent"/>
    <xsl:variable name="width" select="($border_margin*2) + $len"/>
    <xsl:variable name="height" select="(2*$border_margin) + $font_size + $font_descent"/>

    <xsl:if test="boolean($border_visible)">
      <rect x="{$left}" y="{$top}" width="{$width}" height="{$height}" stroke="{$border_stroke_color}" stroke-width="{$border_stroke_width}" fill="{$border_fill_color}" fill-opacity="{$border_fill_opacity}" rx="4" ry="4" />
    </xsl:if>
    <text text-anchor="start" x="{$x}" y="{$y - $font_descent}">
      <xsl:value-of select="$text"/>
    </text>
  </xsl:template>

</xsl:stylesheet>
