<?php
	include('_init.php');
	require_once(GENERAL_CLASSES_DIR.'/ticket.php');
	require_once(GENERAL_CLASSES_DIR.'/detail_ticket.php');
	
	$smarty->assign('legende_etiquette', 'Montant');
	$smarty->assign('formatage', '%.02f');
	
	$stat = Tools::getValue('stat');
	$regroup = Tools::getValue('regroup');
	$periode = Tools::getValue('periode');
	$titre_stat = '';
	$ident_menu = 'dashboard';
	
	switch($regroup)
	{
		case 'JOUR':
			break;
		case 'SEMAINE':
			break;
		case 'MOIS':
			break;
		default :
			$regroup = 'DATE';
	}
	
	switch($periode)
	{
		case 'SEMAINE':
			Tools::start_end_week(date('Y'), date('W'), $date_depart, $date_fin);
			$titre_stat = 'Semaine n° '.date('W');
			break;
		case 'MOIS':
			$date_depart = date('Y-m').'-01';
			// il faut connaitre le nombre de jours du mois
			$mois = mktime( 0, 0, 0, date('m'), 1, date('Y')); 
			$nb_jours = date("t",$mois); 
			$date_fin = date('Y-m').'-'.$nb_jours;
			$titre_stat = 'Mois '.Tools::getMonthName(date('m'));
			break;
		case 'ANNEE':
		default:
			$date_depart = date('Y').'-01-01';
			$date_fin = date('Y').'-12-31';
			$periode = 'ANNEE';
			$titre_stat = 'Année '.date('Y');
			break;
		
	}
	$legende = 'Montant';
	$formatage = '%.02f';
	$mag = (int)context::get_context('magasin');
	
	switch($stat)
	{
		case 'Marge':
			$datas = detail_ticket::stats_marge($date_depart, $date_fin, $regroup, $mag);
			break;
		case 'VenteTTC':
			$datas = detail_ticket::stats_vente($date_depart, $date_fin, $regroup, 'TTC', $mag);
			break;
		case 'Panier':
			$datas = ticket::panier_moyen($date_depart, $date_fin, $regroup, $mag);
			break;
		case 'Ticket':
			$datas = ticket::nb_tickets($date_depart, $date_fin, $regroup, $mag);
			$legende = 'Nombre';
			$formatage = '%d';
			break;
		default:
			$datas = detail_ticket::stats_vente($date_depart, $date_fin, $regroup, 'HT', $mag);
			$stat = 'VenteHT';
	}
	
	if($regroup == 'JOUR')
	{
		// il faut reformater le resultat pour afficher les jours de semaine
		for($i=0; $i < count($datas); $i++)
			$datas[$i]['absice'] = Tools::GetDayName($datas[$i]['absice']);
	}
	if($regroup == 'MOIS')
	{
		for($i=0; $i < count($datas); $i++)
			$datas[$i]['absice'] = Tools::getMonthName($datas[$i]['absice']);
	}
	
	$smarty->assign('context_mag', $mag);
	$smarty->assign('stat', $stat);
	$smarty->assign('regroup', $regroup);
	$smarty->assign('periode', $periode);
	$smarty->assign('legende_etiquette', $legende);
	$smarty->assign('formatage', $formatage);
	$smarty->assign('titre_stat', $titre_stat);
	
	
	include('_display.php');
?>