<?php
	define('BATCH_BACKUP_PATH', 'backup');
	define('NB_JOUR_FLUSH', 7);
	
	require_once(GENERAL_CLASSES_DIR.'/table.php');
	require_once(GENERAL_CLASSES_DIR.'/client.php');
	//require_once(GENERAL_CLASSES_DIR.'/detail_ticket.php');
	require_once(GENERAL_CLASSES_DIR.'/ticket.php');
	require_once(GENERAL_CLASSES_DIR.'/fidelite.php');
	require_once(GENERAL_CLASSES_DIR.'/type_ligne.php');
	require_once(GENERAL_CLASSES_DIR.'/magasin.php');
	
	
	
	
	function set_var_from_xml(&$var, $node, $type='default')
	{
		if($node && $node->length>0)
		{
			switch($type)
			{
			case 'datefr':
				$var->SetDateFr($node->item(0)->nodeValue);
				break;
			case 'dateen':
				$var->SetDateEn($node->item(0)->nodeValue);
				break;
			case 'reel':
				$var = str_replace(',', '.', $node->item(0)->nodeValue);
				break;
			default:
				$var = $node->item(0)->nodeValue;
			}
		}
	}

	class batch extends table
	{
		protected $m_magasin;
		protected static $last_flush=0;
		protected $id_log_batch;
		
		protected $nb_client;
		protected $nb_client_erreur;
		protected $nb_client_delete;
		protected $nb_ticket;
		protected $nb_ticket_erreur;
		protected $nb_ticket_delete;
		protected $nb_detail_ticket;
		protected $nb_detail_ticket_erreur;
		protected $nb_detail_ticket_delete;
		protected $nb_fidelite;
		protected $nb_fidelite_erreur;
		protected $nb_fidelite_delete;
		
		public function __construct($idmagasin)
		{
			$id_log_batch = 0;
			
			$this->m_magasin = $idmagasin;
			
			$query = 'insert into '.db::dbname('log_action_batch').' (DateDepart, IdMagasin) values (CURRENT_TIMESTAMP, '.(int)$this->m_magasin.')';
			$db = db::getInstance();
			if($db->query($query))
  			$this->id_log_batch = $db->last_insert_id();
  	}
		
		public static function sauvegarde_batch(&$content)
		{
			if(!is_dir(BATCH_BACKUP_PATH))
				mkdir(BATCH_BACKUP_PATH);
			
			$filename = BATCH_BACKUP_PATH.'/batch_'.date('YmdHis').'.xml';
			$fd = fopen($filename, 'w');
			if($fd)
			{
				fwrite($fd, $content);
				fclose($fd);
			}
			return $filename;
		}
		
		public static function flush_batch()
		{
			$filename = '';
			$tab_files = array();
			$folder = BATCH_BACKUP_PATH;
			// Search file in the folder
			if (is_dir($folder))
			{
				$folder .= '/';
				if ($dir = opendir($folder))
				{
					while (($file = readdir($dir)) && $filename == '')
					{
						$ext = strtolower(substr($file, -4));

						if ($ext == '.xml')
						{
							// si le fichier depasse le temps prévu de sauvegarde, on le supprime
							if (filemtime($folder.$file) < (time() - (3600 * 24 * NB_JOUR_FLUSH)))
								unlink($folder.$file);
						}
					}
					closedir($dir);
				}
			}
		}
		
		public function update_log_action()
		{
			if($this->id_log_batch > 0)
			{
				$db = db::getInstance();
				$query = 'update '.db::dbname('log_action_batch').' set 
									NbClient='.(int)$this->nb_client.', NbClientErreur='.(int)$this->nb_client_erreur.', NbClientDelete='.(int)$this->nb_client_delete.', 
									NbTicket='.(int)$this->nb_ticket.', NbTicketErreur='.(int)$this->nb_ticket_erreur.', NbTicketDelete='.(int)$this->nb_ticket_delete.', 
									NbDetailTicket='.(int)$this->nb_detail_ticket.', NbDetailTicketErreur='.(int)$this->nb_detail_ticket_erreur.', NbDetailTicketDelete='.(int)$this->nb_detail_ticket_delete.',
									NbFidelite='.(int)$this->nb_fidelite.', NbFideliteErreur='.(int)$this->nb_fidelite_erreur.', NbFideliteDelete='.(int)$this->nb_fidelite_delete.'  
									Where IdLogActionBatch='.(int)$this->id_log_batch;
				$db->query($query);
			} 
		}
		
		public function update_fin_log_action()
		{
			if($this->id_log_batch > 0)
			{
				$db = db::getInstance();
				$query = 'update '.db::dbname('log_action_batch').' set 
									DateFin=CURRENT_TIMESTAMP
									Where IdLogActionBatch='.(int)$this->id_log_batch;
				$db->query($query);
			}
		}
		
		public static function get_log_action()
		{
			$db = db::getInstance();
			return $db->select('select SQL_CALC_FOUND_ROWS DateDepart, DateFin, NbClient, NbClientErreur, NbClientDelete, NbTicket, NbTicketErreur, NbTicketDelete, NbDetailTicket,
													NbDetailTicketErreur, NbDetailTicketDelete, NbFidelite, NbFideliteErreur, NbFideliteDelete,
													'.db::dbname(magasin::$table_name).'.Nom as Magasin
													from '.db::dbname('log_action_batch').'
													left join '.db::dbname(magasin::$table_name).' on '.db::dbname('log_action_batch').'.IdMagasin='.db::dbname(magasin::$table_name).'.IdMagasin
													order by IdLogActionBatch desc'.self::add_query_pagination());
		}
		
		public function import_entetes($xml_tag)
		{
			$tag_type = $xml_tag->getElementsByTagName("FIDELITE_TYPE");
			fidelite::import_types($tag_type);
			
			$tag_type = $xml_tag->getElementsByTagName("FIDELITE_MVT_TYPE");
			fidelite::import_mvt_types($tag_type);
			
			$tag_type = $xml_tag->getElementsByTagName("TYPE_LIGNE_TICKET");
			type_ligne::import_types($tag_type);
			
		}
		
		public function traite_batch($xml_tag)
		{
			$tag_table = $xml_tag->getElementsByTagName("NomTable");
			$retour = -1;		
					
			if($tag_table)
			{
				$table = $tag_table->item(0)->nodeValue;
				
				// recuperation de l'xml de l'enregistrement
				$tag_enreg = $xml_tag->getElementsByTagName("ENREG");
				$tag_suppr = $xml_tag->getElementsByTagName("Suppression_O_N");
				$suppression = 0;
				if($tag_suppr && $tag_suppr->length>0)
				{
					$suppression = (int)$tag_suppr->item(0)->nodeValue;
				}
				
				if($suppression <= 0)
				{
					if($tag_enreg && $tag_enreg->length>0)
					{
						switch($table)
						{
							case "CLIENT_EXP_TOT":
								$retour = $this->traite_client($tag_enreg->item(0));
								if($retour > 0)
									$this->nb_client++;
								else
									$this->nb_client_erreur++;
								break;
							case "TICKET_EXP":
								$retour = $this->traite_ticket($tag_enreg->item(0));
								if($retour > 0)
									$this->nb_ticket++;
								else
									$this->nb_ticket_erreur++;
								break;
							case "TICKET_DETAIL_EXP":
								$retour = $this->traite_detail_ticket($tag_enreg->item(0));
								if($retour > 0)
									$this->nb_detail_ticket++;
								else
									$this->nb_detail_ticket_erreur++;
								break;
							case "FIDELITE_MVT":
								$retour = $this->traite_fidelite($tag_enreg->item(0));
								if($retour > 0)
									$this->nb_fidelite++;
								else
									$this->nb_fidelite_erreur++;
								break;
						}
					}
				}
				else
				{
					// gestion de la suppression
					$retour = $this->suppression($table, $xml_tag);
				}
			}
			return $retour;
		}
		
		
		public function traite_client($xml_tag)
		{
			return client::save_from_xml($xml_tag, $this->m_magasin);
		}
		
		public function traite_detail_ticket($xml_tag)
		{
			return detail_ticket::save_from_xml($xml_tag, $this->m_magasin);
		}
		
		public function traite_ticket($xml_tag)
		{
			return ticket::save_from_xml($xml_tag, $this->m_magasin);
		}
		
		public function traite_fidelite($xml_tag)
		{
			return fidelite::save_from_xml($xml_tag, $this->m_magasin);
		}
		
		protected function suppression($table, $xml_tag)
		{
			$retour = -1;
			$tag_id = $xml_tag->getElementsByTagName("IdEnregistrement");
			if($tag_id && $tag_id->length>0)
			{
				$id_enregistrement = (int)$tag_id->item(0)->nodeValue;
				
				if($id_enregistrement > 0)
				{
					$id_local = 0;
					
					switch($table)
					{
						case "CLIENT_EXP_TOT":
							$id_local = client::get_by_magasin($id_enregistrement, $this->m_magasin);
							if($id_local && $id_local[0]['id'] > 0)
							{
								client::delete($id_local[0]['id']);
								$this->nb_client_delete++;
							}
							$retour = $id_local;
							break;
						case "TICKET_EXP":
							$id_local = ticket::get_by_magasin($id_enregistrement, $this->m_magasin);
							if($id_local && $id_local[0]['id'] > 0)
							{
								ticket::delete($id_local[0]['id']);
								$this->nb_ticket_delete++;
							}
							$retour = $id_local;
							break;
						case "TICKET_DETAIL_EXP":
							$id_local = detail_ticket::get_by_magasin($id_enregistrement, $this->m_magasin);
							if($id_local && $id_local[0]['id'] > 0)
							{
								detail_ticket::delete($id_local[0]['id']);
								$this->nb_detail_ticket_delete++;
							}
							$retour = $id_local;
							break;
						case "FIDELITE_MVT":
							$id_local = fidelite::get_by_magasin($id_enregistrement, $this->m_magasin);
							if($id_local && $id_local[0]['id'] > 0)
							{
								fidelite::delete($id_local[0]['id']);
								$this->nb_fidelite_delete++;
							}
							$retour = $id_local;
							break;
					}
				}
			}
			return $retour;
		}
		
		public static function entete_fiche_batch($table_name, $id_batch)
		{
			$reponse = '<IdBatch>'.$id_batch."</IdBatch>\n";
			$reponse.= '<NomTable>'.utf8_encode($table_name)."</NomTable>\n";
			return $reponse;
		}
		
		public static function balise_fiche_batch($balise, $valeur)
		{
			return '<'.$balise.'>'.htmlspecialchars($valeur).'</'.$balise.'>'."\n";
		}
		
		public static function receive_batch($idmagasin, &$postdata)
		{
			// sauvegarde du batch reçu
			$file_backup = self::sauvegarde_batch($postdata);
			
			// initialisation du moteur xml
			$dom = new DomDocument;
			// chargement de l'arbre xml transmis
		  $OK = $dom->loadXML($postdata);
			// destruction de la variable texte contenant l'xml (liberation de la memoire)
			unset($postdata);
			$contenu_xml = '';
			
			$document =  $dom->documentElement;
			
			if($document)
			{
				$m_batch = new batch($idmagasin);
				
				// lecture des paramètres généraux (type de fildelite...)
				$tag_entete = $document->getElementsByTagName("ENTETE");
				if($tag_entete)
					$m_batch->import_entetes($tag_entete->item(0));
				
				$tag = $document->getElementsByTagName("BATCH");
				if($tag)
				{
					// boucle sur les batch
					for($i=0; $i < $tag->length; $i++)
					{
						// lecture de l'IdBatch
						$tagidbatch = $tag->item($i)->getElementsByTagName("IdBatchCloud");
						$idbatch = -1;
						// si ce batch n'a pas d'Id je ne le traite pas
						if($tagidbatch && $tagidbatch->length>0)
						{
							$idbatch = $tagidbatch->item(0)->nodeValue;
						
							$idcloud = $m_batch->traite_batch($tag->item($i));
							if($idcloud >= 0)
							{
								// si le batch s'est bien pass?n retourne l'Id de batch KinTPV
								echo '<BATCH>';
								echo '<IDBATCH>'.$idbatch.'</IDBATCH>'."\n";
								echo '<IDCLOUD>'.$idcloud.'</IDCLOUD>'."\n";
								echo '</BATCH>';
								self::flush();
							}
						}
					}
					
					$m_batch->update_log_action();
					$m_batch->update_fin_log_action();
				}
			}
		}
		
		public static function send_batch_limit($last_id)
		{
			$limit = NB_BATCH_SEND;
			$db = db::getInstance();
			$req = 'Select IdLogBatch as id, NomTable, IdEnregTable, Suppression_O_N
						from '.db::dbname('log_batch').'
						where IdLogBatch > '.$last_id.'
						order by IdLogBatch
						limit 0, '.(int)$limit;
			$magasins = magasin::get();
			$res = $db->select($req);
			if($res)
			{
				foreach($res as $batch)
				{
					switch($batch['NomTable'])
					{
						case client::$table_name:
							if($batch['Suppression_O_N'] <= 0)
								self::send_batch_client($batch['id'], $batch['IdEnregTable'], $magasins);
							else
								self::send_batch_suppression('CLIENT_EXP_TOT', $batch['id'], $batch['IdEnregTable']);
							break;
							
						case fidelite::$table_name:
							if($batch['Suppression_O_N'] <= 0)
								self::send_batch_fidelite($batch['id'], $batch['IdEnregTable'], $magasins);
							else
								self::send_batch_suppression('FIDELITE_MVT', $batch['id'], $batch['IdEnregTable']);
							break;
					}
				}
			}
		}
		
		public static function send_batch_client($id_batch, $id_client, $magasins)
		{
			$client = client::get($id_client);
			if($client)
			{
				$c = $client[0];
				echo "<BATCH>\n";
				echo self::entete_fiche_batch('CLIENT_EXP_TOT', $id_batch);
				echo self::balise_fiche_batch('Suppression_O_N', '0');
				echo "<ENREG>\n";
				echo self::balise_fiche_batch('IdCloud', $c['id']);
				echo self::balise_fiche_batch('IdCloudFusion', $c['IdClientFusion']);
				echo self::balise_fiche_batch('IdClientMagasin', $c['IdClientMagasin']);
				echo self::balise_fiche_batch('IdMagasinCloud', $c['IdMagasin']);
				echo self::balise_fiche_batch('CleMagasin', $c['IdMagasin']);//self::get_cle_magasin($c['IdMagasin'], $magasins));
				echo self::balise_fiche_batch('Nom', $c['Nom']);
				echo self::balise_fiche_batch('Prenom', $c['Prenom']);
				echo self::balise_fiche_batch('Adresse1', $c['Adresse1']);
				echo self::balise_fiche_batch('Adresse2', $c['Adresse2']);
				echo self::balise_fiche_batch('Adresse3', $c['Adresse3']);
				echo self::balise_fiche_batch('Adresse4', $c['Adresse4']);
				echo self::balise_fiche_batch('CodePostal', $c['CodePostal']);
				echo self::balise_fiche_batch('Ville', $c['Ville']);
				echo self::balise_fiche_batch('IdMagOrgModif', $c['IdMagOrgModif']);
				echo self::balise_fiche_batch('EMail', $c['EMail']);
				echo self::balise_fiche_batch('TriggerBatchBloque_O_N', $c['TriggerBatchBloque_O_N']);
				echo self::balise_fiche_batch('CodeClient', $c['CodeClient']);
				echo self::balise_fiche_batch('Civilite', $c['Civilite']);
				echo self::balise_fiche_batch('DateCrea_Auto', $c['DateCrea_Auto'].'T00:00:00');
				echo self::balise_fiche_batch('Tel_maison', $c['Tel_maison']);
				echo self::balise_fiche_batch('ExonereTVA_O_N', $c['ExonereTVA_O_N']);
				echo self::balise_fiche_batch('Inactif_O_N', $c['Inactif_O_N']);
				echo self::balise_fiche_batch('DateModif_Auto', $c['DateModif_Auto'].'T00:00:00');
				echo self::balise_fiche_batch('ClefCodifiee', $c['ClefCodifiee']);
				echo self::balise_fiche_batch('Tel_portable', $c['Tel_portable']);
				echo self::balise_fiche_batch('Tel_travail', $c['Tel_travail']);
				echo self::balise_fiche_batch('Date_naissance', $c['Date_naissance'].'T00:00:00');
				echo self::balise_fiche_batch('Commentaire', $c['Commentaire']);
				echo self::balise_fiche_batch('Societe', $c['Societe']);
				echo self::balise_fiche_batch('NumTVA_Intra', $c['NumTVA_Intra']);
				echo self::balise_fiche_batch('DateFinValiditeAdhesion', $c['DateFinValiditeAdhesion']);
				echo self::balise_fiche_batch('IdClient_CB_Auto', $c['IdClient_CB_Auto']);
				echo self::balise_fiche_batch('Titre', $c['Titre']);
				echo self::balise_fiche_batch('Fax', $c['Fax']);
				echo self::balise_fiche_batch('SiteWeb', $c['SiteWeb']);
				echo self::balise_fiche_batch('FACT_IdImprFacture', $c['FACT_IdImprFacture']);
				echo self::balise_fiche_batch('InfoLibre_Libel', $c['InfoLibre_Libel']);
				echo self::balise_fiche_batch('InfoLibre_Valeur', $c['InfoLibre_Valeur']);
				echo self::balise_fiche_batch('NumCompteCompta', $c['NumCompteCompta']);
				echo self::balise_fiche_batch('VenteHT_O_N', $c['VenteHT_O_N']);
				echo self::balise_fiche_batch('Prospect_O_N', $c['Prospect_O_N']);
				echo self::balise_fiche_batch('IdTauxTvaExo', $c['IdTauxTvaExo']);
				echo self::balise_fiche_batch('FACT_NbJourPaiement', $c['FACT_NbJourPaiement']);
				echo self::balise_fiche_batch('TEL_RECH_portable', $c['TEL_RECH_portable']);
				echo self::balise_fiche_batch('TEL_RECH_maison', $c['TEL_RECH_maison']);
				echo self::balise_fiche_batch('TEL_RECH_travail', $c['TEL_RECH_travail']);
				echo self::balise_fiche_batch('HeureModif_Auto', $c['HeureModif_Auto']);
				echo self::balise_fiche_batch('WEB_MasquerVenteBoutique_O_N', $c['WEB_MasquerVenteBoutique_O_N']);
				echo "</ENREG>\n";
				echo "</BATCH>\n";
			}
			
		}
		
		public static function send_batch_fidelite($id_batch, $id_fidelite, $magasins)
		{
			$fidelite = fidelite::get($id_fidelite);
			if($fidelite)
			{
				$f = $fidelite[0];
				
				echo "<BATCH>\n";
				echo self::entete_fiche_batch('FIDELITE_MVT', $id_batch);
				echo self::balise_fiche_batch('Suppression_O_N', '0');
				echo "<ENREG>\n";
				echo self::balise_fiche_batch('IdCloud', $f['id']);
				echo self::balise_fiche_batch('IdFideliteMvtMagasin', $f['IdFideliteMvtMagasin']);
				echo self::balise_fiche_batch('CleMagasin', $f['IdMagasin']);//self::get_cle_magasin($f['IdMagasin'], $magasins));
				echo self::balise_fiche_batch('IdMagasinCloud', $f['IdMagasin']);
				echo self::balise_fiche_batch('IdFideliteMvtType', $f['IdFideliteMvtType']);
				echo self::balise_fiche_batch('IdClientCloud', $f['IdClient']);
				echo self::balise_fiche_batch('DateMvt', $f['DateMvt'].'T00:00:00');
				echo self::balise_fiche_batch('Valeur', $f['Valeur']);
				echo self::balise_fiche_batch('Remb_O_N', $f['Remb_O_N']);
				echo self::balise_fiche_batch('Remb_Date', $f['Remb_Date'].'T00:00:00');
				echo self::balise_fiche_batch('Remb_Heure', $f['Remb_Heure']);
				echo self::balise_fiche_batch('Remb_IdClientCloud', $f['Remb_IdClient']);
				echo self::balise_fiche_batch('IdFideliteType', $f['IdFideliteType']);
				echo self::balise_fiche_batch('DateFinValidite', $f['DateFinValidite'].'T00:00:00');
				echo self::balise_fiche_batch('Reste', $f['Reste']);
				echo self::balise_fiche_batch('HeureMvt', $f['HeureMvt']);
				echo self::balise_fiche_batch('TriggerBatchBloque_O_N', $f['TriggerBatchBloque_O_N']);
				echo "</ENREG>\n";
				echo "</BATCH>\n";
			}
		}
		
		public static function get_cle_magasin($id_magasin, $magasins)
		{
			$cle = '';
			for($i=0; $i < count($magasins) && $cle == ''; $i++)
			{
				if($magasins[$i]['id'] == $id_magasin)
					$cle = $magasins[$i]['Cle'];
			}
			
			return $cle;
		}
		
		public static function send_batch_suppression($table_name, $id_batch, $id_cloud)
		{
			echo "<BATCH>\n";
			echo self::entete_fiche_batch($table_name, $id_batch);
			echo self::balise_fiche_batch('Suppression_O_N', '1');
			echo "<ENREG>\n";
			echo self::balise_fiche_batch('IdCloud', $id_cloud);
			echo "</ENREG>\n";
			echo "</BATCH>\n";
		}
		
		public static function send_batch($last_id)
		{
			$limite = NB_BATCH_SEND;
			// retourne les informations client
			$clients = client::from_log_batch('IdClient', $last_id, $limite);
			foreach($clients as $c)
			{
				echo "<BATCH>\n";
				echo self::entete_fiche_batch('CLIENT_EXP_TOT', $c['id_batch']);
				echo self::balise_fiche_batch('Suppression_O_N', '0');
				echo "<ENREG>\n";
				echo self::balise_fiche_batch('IdCloud', $c['id']);
				echo self::balise_fiche_batch('IdCloudFusion', $c['IdClientFusion']);
				echo self::balise_fiche_batch('IdClientMagasin', $c['IdClientMagasin']);
				echo self::balise_fiche_batch('IdMagasinCloud', $c['IdMagasinCloud']);
				echo self::balise_fiche_batch('CleMagasin', $c['CleMagasin']);
				echo self::balise_fiche_batch('Nom', $c['Nom']);
				echo self::balise_fiche_batch('Prenom', $c['Prenom']);
				echo self::balise_fiche_batch('Adresse1', $c['Adresse1']);
				echo self::balise_fiche_batch('Adresse2', $c['Adresse2']);
				echo self::balise_fiche_batch('Adresse3', $c['Adresse3']);
				echo self::balise_fiche_batch('Adresse4', $c['Adresse4']);
				echo self::balise_fiche_batch('CodePostal', $c['CodePostal']);
				echo self::balise_fiche_batch('Ville', $c['Ville']);
				echo self::balise_fiche_batch('IdMagOrgModif', $c['IdMagOrgModif']);
				echo self::balise_fiche_batch('EMail', $c['EMail']);
				echo self::balise_fiche_batch('TriggerBatchBloque_O_N', $c['TriggerBatchBloque_O_N']);
				echo self::balise_fiche_batch('CodeClient', $c['CodeClient']);
				echo self::balise_fiche_batch('Civilite', $c['Civilite']);
				echo self::balise_fiche_batch('DateCrea_Auto', $c['DateCrea_Auto'].'T00:00:00');
				echo self::balise_fiche_batch('Tel_maison', $c['Tel_maison']);
				echo self::balise_fiche_batch('ExonereTVA_O_N', $c['ExonereTVA_O_N']);
				echo self::balise_fiche_batch('Inactif_O_N', $c['Inactif_O_N']);
				echo self::balise_fiche_batch('DateModif_Auto', $c['DateModif_Auto'].'T00:00:00');
				echo self::balise_fiche_batch('ClefCodifiee', $c['ClefCodifiee']);
				echo self::balise_fiche_batch('Tel_portable', $c['Tel_portable']);
				echo self::balise_fiche_batch('Tel_travail', $c['Tel_travail']);
				echo self::balise_fiche_batch('Date_naissance', $c['Date_naissance'].'T00:00:00');
				echo self::balise_fiche_batch('Commentaire', $c['Commentaire']);
				echo self::balise_fiche_batch('Societe', $c['Societe']);
				echo self::balise_fiche_batch('NumTVA_Intra', $c['NumTVA_Intra']);
				echo self::balise_fiche_batch('DateFinValiditeAdhesion', $c['DateFinValiditeAdhesion']);
				echo self::balise_fiche_batch('IdClient_CB_Auto', $c['IdClient_CB_Auto']);
				echo self::balise_fiche_batch('Titre', $c['Titre']);
				echo self::balise_fiche_batch('Fax', $c['Fax']);
				echo self::balise_fiche_batch('SiteWeb', $c['SiteWeb']);
				echo self::balise_fiche_batch('FACT_IdImprFacture', $c['FACT_IdImprFacture']);
				echo self::balise_fiche_batch('InfoLibre_Libel', $c['InfoLibre_Libel']);
				echo self::balise_fiche_batch('InfoLibre_Valeur', $c['InfoLibre_Valeur']);
				echo self::balise_fiche_batch('NumCompteCompta', $c['NumCompteCompta']);
				echo self::balise_fiche_batch('VenteHT_O_N', $c['VenteHT_O_N']);
				echo self::balise_fiche_batch('Prospect_O_N', $c['Prospect_O_N']);
				echo self::balise_fiche_batch('IdTauxTvaExo', $c['IdTauxTvaExo']);
				echo self::balise_fiche_batch('FACT_NbJourPaiement', $c['FACT_NbJourPaiement']);
				echo self::balise_fiche_batch('TEL_RECH_portable', $c['TEL_RECH_portable']);
				echo self::balise_fiche_batch('TEL_RECH_maison', $c['TEL_RECH_maison']);
				echo self::balise_fiche_batch('TEL_RECH_travail', $c['TEL_RECH_travail']);
				echo self::balise_fiche_batch('HeureModif_Auto', $c['HeureModif_Auto']);
				echo self::balise_fiche_batch('WEB_MasquerVenteBoutique_O_N', $c['WEB_MasquerVenteBoutique_O_N']);
				echo "</ENREG>\n";
				echo "</BATCH>\n";
				$limite--;
			}
			
			if($limite > 0)
			{
				$fidelite = fidelite::from_log_batch('IdFideliteMvt', $last_id, $limite);
				foreach($fidelite as $c)
				{
					echo "<BATCH>\n";
					echo self::entete_fiche_batch('FIDELITE_MVT', $c['id_batch']);
					echo self::balise_fiche_batch('Suppression_O_N', '0');
					echo "<ENREG>\n";
					echo self::balise_fiche_batch('IdCloud', $c['id']);
					echo self::balise_fiche_batch('IdFideliteMvtMagasin', $c['IdFideliteMvtMagasin']);
					echo self::balise_fiche_batch('CleMagasin', $c['CleMagasin']);
					echo self::balise_fiche_batch('IdMagasinCloud', $c['IdMagasinCloud']);
					echo self::balise_fiche_batch('IdFideliteMvtType', $c['IdFideliteMvtType']);
					echo self::balise_fiche_batch('IdClientCloud', $c['IdClient']);
					echo self::balise_fiche_batch('DateMvt', $c['DateMvt'].'T00:00:00');
					echo self::balise_fiche_batch('Valeur', $c['Valeur']);
					echo self::balise_fiche_batch('Remb_O_N', $c['Remb_O_N']);
					echo self::balise_fiche_batch('Remb_Date', $c['Remb_Date'].'T00:00:00');
					echo self::balise_fiche_batch('Remb_Heure', $c['Remb_Heure']);
					echo self::balise_fiche_batch('Remb_IdClientCloud', $c['Remb_IdClient']);
					echo self::balise_fiche_batch('IdFideliteType', $c['IdFideliteType']);
					echo self::balise_fiche_batch('DateFinValidite', $c['DateFinValidite'].'T00:00:00');
					echo self::balise_fiche_batch('Reste', $c['Reste']);
					echo self::balise_fiche_batch('HeureMvt', $c['HeureMvt']);
					echo self::balise_fiche_batch('TriggerBatchBloque_O_N', $c['TriggerBatchBloque_O_N']);
					echo "</ENREG>\n";
					echo "</BATCH>\n";
					$limite--;
				}
			}
			
			if($limite > 0)
			{
				// les batch de suppression client
				$suppr = client::log_batch_suppression($last_id, $limite);
				foreach($suppr as $c)
				{
					echo "<BATCH>\n";
					echo self::entete_fiche_batch('CLIENT_EXP_TOT', $c['id_batch']);
					echo self::balise_fiche_batch('Suppression_O_N', '1');
					echo "<ENREG>\n";
					echo self::balise_fiche_batch('IdCloud', $c['id']);
					echo "</ENREG>\n";
					echo "</BATCH>\n";
					$limite--;
				}
			}
			
			if($limite > 0)
			{
				// les batch de suppression fidelite
				$suppr = fidelite::log_batch_suppression($last_id, $limite);
				foreach($suppr as $c)
				{
					echo "<BATCH>\n";
					echo self::entete_fiche_batch('FIDELITE_MVT', $c['id_batch']);
					echo self::balise_fiche_batch('Suppression_O_N', '1');
					echo "<ENREG>\n";
					echo self::balise_fiche_batch('IdCloud', $c['id']);
					echo "</ENREG>\n";
					echo "</BATCH>\n";
					$limite--;
				}
			}
		}
		
		public static function flush()
		{
			if(self::$last_flush <= 0)
				self::$last_flush = time();
				
			if((time() - self::$last_flush) > 30)
			{
				self::$last_flush = time();
				// envoi 4096 caractere pour compléter la chaine et remplir le buffer
				echo str_pad('', 4096);
				@ob_flush();
				flush();
			}
		}
	}
?>