<?php
	require_once(GENERAL_CLASSES_DIR.'/table.php');
	
	class client extends table
	{
		public static $table_name = 'client';
		public static $unique_id = 'IdClient';
		public static $field_list = array('IdClient', 'IdClientFusion', 'IdClientMagasin', 'IdMagasin', 'Nom', 'Prenom', 'Adresse1', 'Adresse2', 'Adresse3', 'Adresse4', 'CodePostal', 'Ville', 'EMail', 'CodeClient', 'Civilite', 'Tel_maison', 'ExonereTVA_O_N', 'Inactif_O_N', 'Tel_portable', 'Tel_travail', 'Date_naissance', 'Commentaire', 'Societe', 'NumTVA_Intra', 'DateFinValiditeAdhesion', 'IdClient_CB_Auto', 'Fax', 'SiteWeb', 'FACT_IdImprFacture', 'InfoLibre_Libel', 'InfoLibre_Valeur', 'NumCompteCompta', 'VenteHT_O_N', 'Titre', 'IdMagOrgModif', 'TriggerBatchBloque_O_N', 'DateCrea_Auto', 'DateModif_Auto', 'ClefCodifiee', 'Prospect_O_N', 'IdTauxTvaExo', 'TauxTvaExo', 'FACT_NbJourPaiement', 'TEL_RECH_portable', 'TEL_RECH_maison', 'TEL_RECH_travail', 'HeureModif_Auto', 'WEB_MasquerVenteBoutique_O_N', 'DateCreation', 'DateModification');
		
		
		public static function get($id, $pagination=true)
		{
			$db = db::getInstance();
			
			$req = 'select '.($pagination?'SQL_CALC_FOUND_ROWS ':'').'IdClient as id, '.self::liste_champs(self::$table_name, self::$field_list).'
							from '.db::dbname(self::$table_name);
  		if($id > 0)
  			$req.= ' where IdClient='.(int)$id;
  		else	// quand on liste tout, on exclue les clients fusionns
  		{
  			$req.= ' Where IdClientFusion = 0 ';
  			if($pagination)
  				$req.= self::add_query_pagination();
  		}
  		return $db->select($req);
		}
		
		public static function get_by_magasin($IdClientMagasin, $IdMagasin)
		{
			$db = db::getInstance();
			
			$req = 'select IdClient as id, '.self::liste_champs(self::$table_name, self::$field_list).'
							from '.db::dbname(self::$table_name).'
  						where IdClientMagasin='.(int)$IdClientMagasin.' and IdMagasin='.(int)$IdMagasin.'
  						order by IdClientMagasin';
  		return $db->select($req);
  	}
  	
  	public static function search($search, $pagination=true)
  	{
  		$db = db::getInstance();
			if($search != '')
			{
				$req = 'select '.($pagination?'SQL_CALC_FOUND_ROWS ':'').'IdClient as id, '.self::liste_champs(self::$table_name, self::$field_list).'
								from '.db::dbname(self::$table_name).'
	  						where 
	  						IdClientFusion=0 and (
	  						IdClientMagasin='.(int)$search.' 
	  						Or CodeClient="'.db::esc($search).'"
	  						Or Nom like"%'.db::esc($search).'%"
	  						Or CodePostal="'.db::esc($search).'"
	  						Or EMail="'.db::esc($search).'"
	  						Or Societe like"%'.db::esc($search).'%"
	  						Or Prenom like"%'.db::esc($search).'%"
	  						Or Tel_maison like"%'.db::esc($search).'%"
	  						Or Tel_portable like"%'.db::esc($search).'%"
	  						Or Tel_travail like"%'.db::esc($search).'%")
	  						order by IdClientMagasin';
	  		if($pagination)
  				$req.= self::add_query_pagination();
	  		return $db->select($req);
	  	}
  	}
  	
  	public static function save_from_xml($xml, $id_magasin)
  	{
  		$db = db::getInstance();
  		$IdClientCloud = self::get_xml_value($xml, 'IdClientCloud');
  		$IdClientMagasin = self::get_xml_value($xml, 'IdClient_Auto');
  		$client = null;
  		
  		if($IdClientCloud > 0)	// si nous recevons un client cloud, il faut forcment mettre  jour celui-ci (on ne tient pas compte des id client magasin et le magasin)
  			$client = self::get($IdClientCloud);
  		else
  			$client = self::get_by_magasin($IdClientMagasin, $id_magasin);
  		
  		if(!$client)// insertion
  			return self::insert_from_xml($xml, $id_magasin);
  		else // modification
  			return self::update_from_xml($client[0]['id'], $xml, $id_magasin);
  	}
  	
  	protected static function insert_from_xml($xml, $id_magasin)
  	{
  		$id_client = (int)self::get_xml_value($xml, 'IdClientCloud');
  		$query = 'insert into '.db::dbname(self::$table_name).'
  							(';
  		if($id_client > 0) $query.= 'IdClient, ';
  		
  		$query.= 'IdClientMagasin, IdClientReseau, IdMagasin, IdClientFusion, Nom, Prenom, Adresse1, Adresse2, Adresse3, Adresse4,
  							 CodePostal, Ville, EMail, CodeClient, Civilite, Tel_maison, ExonereTVA_O_N, Inactif_O_N,
  							 Tel_portable, Tel_travail, Date_naissance, Commentaire, Societe, NumTVA_Intra,
  							 DateFinValiditeAdhesion, IdClient_CB_Auto, Fax, SiteWeb, FACT_IdImprFacture,
  							 InfoLibre_Libel, InfoLibre_Valeur, NumCompteCompta, VenteHT_O_N, IdMagOrgModif, TriggerBatchBloque_O_N,
  							 DateCrea_Auto, DateModif_Auto, ClefCodifiee, Prospect_O_N, IdTauxTvaExo, TauxTvaExo, 
  							 FACT_NbJourPaiement, TEL_RECH_portable, TEL_RECH_maison, TEL_RECH_travail, HeureModif_Auto, 
  							 WEB_MasquerVenteBoutique_O_N, DateModification, DateCreation)
  							 values
  							 (';
  		if($id_client > 0) $query.= $id_client.', '; 
  		
  		// BBA 2016-03-01 : On sauvegarde l'id du dernier mag qui a fait la modification dans IdMagOrgModif.
  		$query.=  (int)self::get_xml_value($xml, 'IdClient_Auto').', '.(int)self::get_xml_value($xml, 'IdClientReseau').','.(int)$id_magasin.',
  							 '.(int)self::get_xml_value($xml, 'IdClientCloudFusion').',
  							 "'.db::esc(self::get_xml_value($xml, 'Nom')).'", "'.db::esc(self::get_xml_value($xml, 'Prenom')).'",
  							 "'.db::esc(self::get_xml_value($xml, 'Adresse1')).'", "'.db::esc(self::get_xml_value($xml, 'Adresse2')).'",
  							 "'.db::esc(self::get_xml_value($xml, 'Adresse3')).'", "'.db::esc(self::get_xml_value($xml, 'Adresse4')).'",
  							 "'.db::esc(self::get_xml_value($xml, 'CodePostal')).'", "'.db::esc(self::get_xml_value($xml, 'Ville')).'",
  							 "'.db::esc(self::get_xml_value($xml, 'EMail')).'", "'.db::esc(self::get_xml_value($xml, 'CodeClient')).'",
  							 "'.db::esc(self::get_xml_value($xml, 'Civilite')).'", "'.db::esc(self::get_xml_value($xml, 'Tel_maison')).'",
  							 '.(int)self::get_xml_value($xml, 'ExonereTVA_O_N').', '.(int)self::get_xml_value($xml, 'Inactif_O_N').',
  							 "'.db::esc(self::get_xml_value($xml, 'Tel_portable')).'", "'.db::esc(self::get_xml_value($xml, 'Tel_travail')).'",
  							 "'.Tools::dateIsoToEn(self::get_xml_value($xml, 'Date_naissance')).'", "'.db::esc(self::get_xml_value($xml, 'Commentaire')).'",
  							 "'.db::esc(self::get_xml_value($xml, 'Societe')).'", "'.db::esc(self::get_xml_value($xml, 'NumTVA_Intra')).'",
  							 "'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateFinValiditeAdhesion')).'", "'.db::esc(self::get_xml_value($xml, 'IdClient_CB_Auto')).'",
  							 "'.db::esc(self::get_xml_value($xml, 'Fax')).'", "'.db::esc(self::get_xml_value($xml, 'SiteWeb')).'",
  							 '.(int)self::get_xml_value($xml, 'FACT_IdImprFacture').', "'.db::esc(self::get_xml_value($xml, 'InfoLibre_Libel')).'",
  							 "'.db::esc(self::get_xml_value($xml, 'InfoLibre_Valeur')).'", "'.db::esc(self::get_xml_value($xml, 'NumCompteCompta')).'",
  							 '.(int)self::get_xml_value($xml, 'VenteHT_O_N').', '.$id_magasin.', 
  							 '.(int)self::get_xml_value($xml, 'TriggerBatchBloque_O_N').', "'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateCrea_Auto')).'",
  							 "'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateModif_Auto')).'", "'.db::esc(self::get_xml_value($xml, 'ClefCodifiee')).'", 
  							 '.(int)self::get_xml_value($xml, 'Prospect_O_N').', '.(int)self::get_xml_value($xml, 'IdTauxTvaExo').',
  							 '.(double)self::get_xml_value($xml, 'TauxTvaExo').', '.(int)self::get_xml_value($xml, 'FACT_NbJourPaiement').',
  							 "'.db::esc(self::get_xml_value($xml, 'TEL_RECH_portable')).'", "'.db::esc(self::get_xml_value($xml, 'TEL_RECH_maison')).'", 
  							 "'.db::esc(self::get_xml_value($xml, 'TEL_RECH_travail')).'", "'.Tools::dateIsoToTime(self::get_xml_value($xml, 'HeureModif_Auto')).'", 
  							 '.(int)self::get_xml_value($xml, 'WEB_MasquerVenteBoutique_O_N').',
  							 CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)';
  		$db = db::getInstance();
  		if($db->query($query))
  		{
  			$id = $db->last_insert_id();
  			self::new_log_batch($id);
  			return $id;
  		}
  		else
  			return false;
  	}
  	
  	protected static function update_from_xml($id_client, $xml, $id_magasin)
  	{
  		// BBA 2016-03-01 : On sauvegarde l'id du dernier mag qui a fait la modification dans IdMagOrgModif.
  		// IdClientMagasin='.(int)self::get_xml_value($xml, 'IdClient_Auto').',
  							
  		$query = 'update '.db::dbname(self::$table_name).' set 
  							IdClientReseau='.(int)self::get_xml_value($xml, 'IdClientReseau').',
  							Nom="'.db::esc(self::get_xml_value($xml, 'Nom')).'", Prenom="'.db::esc(self::get_xml_value($xml, 'Prenom')).'",
  							Adresse1="'.db::esc(self::get_xml_value($xml, 'Adresse1')).'", Adresse2="'.db::esc(self::get_xml_value($xml, 'Adresse2')).'", 
  							Adresse3="'.db::esc(self::get_xml_value($xml, 'Adresse3')).'", Adresse4="'.db::esc(self::get_xml_value($xml, 'Adresse4')).'",
  							CodePostal="'.db::esc(self::get_xml_value($xml, 'CodePostal')).'", Ville="'.db::esc(self::get_xml_value($xml, 'Ville')).'", 
  							EMail="'.db::esc(self::get_xml_value($xml, 'EMail')).'", CodeClient="'.db::esc(self::get_xml_value($xml, 'CodeClient')).'", 
  							Civilite="'.db::esc(self::get_xml_value($xml, 'Civilite')).'", Tel_maison="'.db::esc(self::get_xml_value($xml, 'Tel_maison')).'", 
  							ExonereTVA_O_N='.(int)self::get_xml_value($xml, 'ExonereTVA_O_N').', Inactif_O_N='.(int)self::get_xml_value($xml, 'Inactif_O_N').',
  							Tel_portable="'.db::esc(self::get_xml_value($xml, 'Tel_portable')).'", Tel_travail="'.db::esc(self::get_xml_value($xml, 'Tel_travail')).'", 
  							Date_naissance="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'Date_naissance')).'", Commentaire="'.db::esc(self::get_xml_value($xml, 'Commentaire')).'", 
  							Societe="'.db::esc(self::get_xml_value($xml, 'Societe')).'", NumTVA_Intra="'.db::esc(self::get_xml_value($xml, 'NumTVA_Intra')).'",
  							DateFinValiditeAdhesion="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateFinValiditeAdhesion')).'", IdClient_CB_Auto="'.db::esc(self::get_xml_value($xml, 'IdClient_CB_Auto')).'",
  							Fax="'.db::esc(self::get_xml_value($xml, 'Fax')).'", SiteWeb="'.db::esc(self::get_xml_value($xml, 'SiteWeb')).'", 
  							FACT_IdImprFacture='.(int)self::get_xml_value($xml, 'FACT_IdImprFacture').', InfoLibre_Libel="'.db::esc(self::get_xml_value($xml, 'InfoLibre_Valeur')).'",
  							InfoLibre_Valeur="'.db::esc(self::get_xml_value($xml, 'InfoLibre_Valeur')).'", NumCompteCompta="'.db::esc(self::get_xml_value($xml, 'NumCompteCompta')).'", 
  							VenteHT_O_N='.(int)self::get_xml_value($xml, 'VenteHT_O_N').', DateModification=CURRENT_TIMESTAMP,
  							IdMagOrgModif='.(int)$id_magasin.', TriggerBatchBloque_O_N='.(int)self::get_xml_value($xml, 'TriggerBatchBloque_O_N').',
  							DateCrea_Auto="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateCrea_Auto')).'", DateModif_Auto="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateModif_Auto')).'", 
  							ClefCodifiee="'.db::esc(self::get_xml_value($xml, 'ClefCodifiee')).'", Prospect_O_N='.(int)self::get_xml_value($xml, 'Prospect_O_N').', 
  							IdTauxTvaExo='.(int)self::get_xml_value($xml, 'IdTauxTvaExo').', TauxTvaExo='.(double)self::get_xml_value($xml, 'TauxTvaExo').', 
  							FACT_NbJourPaiement='.(int)self::get_xml_value($xml, 'FACT_NbJourPaiement').', TEL_RECH_portable="'.db::esc(self::get_xml_value($xml, 'TEL_RECH_portable')).'", 
  							TEL_RECH_maison="'.db::esc(self::get_xml_value($xml, 'TEL_RECH_maison')).'", TEL_RECH_travail="'.db::esc(self::get_xml_value($xml, 'TEL_RECH_travail')).'", 
  							HeureModif_Auto="'.Tools::dateIsoToTime(self::get_xml_value($xml, 'HeureModif_Auto')).'", WEB_MasquerVenteBoutique_O_N='.(int)self::get_xml_value($xml, 'WEB_MasquerVenteBoutique_O_N').'
  							Where IdClient='.(int)$id_client;
  		$db = db::getInstance();  
  		if($db->query($query))
  		{
  			self::new_log_batch($id_client);
  			return $id_client;
  		}
  		else
  			return false;
  	}
  	
  	public static function fusionner($id_principal, $liste_secondaires)
  	{
  		$ok = false;
  		$db = db::getInstance();  
  		// premierement, il faut vrifier que le principal existe...
  		$c = self::get($id_principal);
  		
  		if($c)
  		{
  			// il faut boucler sur la liste des secondaires
  			foreach($liste_secondaires as $l)
  			{
  				// inutile de fusionner une fiche sur elle meme
  				if($l != $id_principal)
  				{
	  				// modifier les id des tables lies
	  				// les tickets
	  				$tickets = ticket::get_by_client($l);
	  				foreach($tickets as $t)
	  					ticket::new_log_batch($t['id']);	// il faut mettre un batch sur tous les tickets pour qu'ils soient retourns aux kintpv
	  				$query = 'update '.db::dbname(ticket::$table_name).' set IdClient='.(int)$id_principal.' where IdClient='.(int)$l;
	  				$db->query($query);
	  				
	  				// et la fidelite
	  				$fidelite = fidelite::get_for_client($l);
	  				foreach($fidelite as $f)
	  					fidelite::new_log_batch($f['id']);	// il faut mettre un batch sur toutes les fidelites pour qu'elles soient retournes aux kintpv
	  				$query = 'update '.db::dbname(fidelite::$table_name).' set IdClient='.(int)$id_principal.' where IdClient='.(int)$l;
	  				$db->query($query);
	  				
	  				// et mise  jour du client
	  				$query = 'update '.db::dbname(self::$table_name).' set IdClientFusion='.(int)$id_principal.' where IdClient='.(int)$l;
	  				$db->query($query);
	  				self::new_log_batch($l);	// batch pour les kintpv
	  			}
  			}
  			$ok = true;
  		}
  		
  		return $ok;
  	}
  	
  	public static function delete($id)
  	{
  		
  	}
  	
  	public static function liste_doublons($tab_criteres = array())
  	{
  		$tab_retour = array();
  		$cpt=0;
  		$groupe=0;
  		$champs = '';
  		foreach($tab_criteres as $c)
  		{
  			$name = '';
  			switch($c)
  			{
  				case 'Nom':
  				case 'Prenom':
  				case 'CodePostal':
  				case 'EMail':
  					$name = $c;
  					
  			}
  			
  			if($name != '')
  			{
	  			if($champs != '') $champs .= ',';
	  			$champs.= $c;
	  		}
  		}
  		
  		if($champs != '')
  		{
  			// premierement : requete de recherche des doublons
	  		$req = 'select '.$champs.' from '.db::dbname(self::$table_name).' where IdClientFusion=0 group by ';
	  		$req.= $champs.' having(count(*)>1)';
  			
  			$db = db::getInstance();
  			$liste = $db->select($req);
  			
  			foreach($liste as $l)
  			{
  				$req = 'select IdClient as id, '.self::liste_champs(self::$table_name, self::$field_list).'
							from '.db::dbname(self::$table_name).'
							where IdClientFusion = 0 ';
							
					$where = '';
					foreach($tab_criteres as $c)
  				{
  					$name = '';
  					$value = '';
		  			switch($c)
		  			{
		  				case 'Nom':
		  					$value = $l['Nom'];
		  					$name = $c;
		  					break;
		  				case 'Prenom':
		  					$value = $l['Prenom'];
		  					$name = $c;
		  					break;
		  				case 'CodePostal':
		  					$value = $l['CodePostal'];
		  					$name = $c;
		  					break;
		  				case 'EMail':
		  					$value = $l['EMail'];
		  					$name = $c;
		  					break;
		  			}
		  			
		  			if($name != '')
		  			{
			  			$where .= ' and ';
			  			$where.= $c.' = "'.db::esc($value).'"';
			  		}
  				}
  				
  				if($where != '')
  				{
  					$req.= $where;
  					$res = $db->select($req);
  					
  					foreach($res as $r)
  					{
  						$tab_retour[$cpt] = $r;
  						$tab_retour[$cpt]['groupe'] = $groupe;
  						$cpt++;
  					}
  				}
  				
  				$groupe++;
  			}
  			
  		}
  		return $tab_retour;
  	}
	}
?>