<?php

define('DATABASE_CONFIG_FILE', GENERAL_CONFIG_DIR.'/database.php');

class install
{
	public $db_config_loaded;
	protected $db_prefix;
	protected $db_host;
	protected $db_user;
	protected $db_password;
	protected $db_name;
	
	
	public function __construct()
	{
		// il faut rcuprer les informations de la base de donnes (au cas ou nous serions en mise  jour)
		$this->db_config_loaded = $this->load_db_infos();
	}
	
	protected function load_db_infos()
	{
		$file_db_config = DATABASE_CONFIG_FILE;
		if(is_file($file_db_config))
		{
			$content = file_get_contents($file_db_config);
			
			// recherche des 5 paramtres
			$db_host = $this->get_value_constant('_DB_SERVER_', $content);
			$db_user = $this->get_value_constant('_DB_USER_', $content);
			$db_password = $this->get_value_constant('_DB_PASSWD_', $content);
			$db_name = $this->get_value_constant('_DB_NAME_', $content);
			$db_prefix = $this->get_value_constant('_DB_PREFIX_', $content);
			
			if($db_host != '' && $db_user != '' && $db_name != '')
			{
				$this->set_db_infos($db_host, $db_user, $db_password, $db_name, $db_prefix);
				
				return true;
			}
		}
		
		return false;
	}
	
	public function test_db_connexion()
	{
		if(!defined('_DB_SERVER_'))
		{
			define('_DB_SERVER_', $this->db_host);
			define('_DB_USER_', $this->db_user);
			define('_DB_PASSWD_', $this->db_password);
			define('_DB_NAME_', $this->db_name);
			define('_DB_PREFIX_', $this->db_prefix);
			
			$db = db::getInstance();
			if($db->connexion_ok())
				return true;
		}
		return false;
	}
	
	protected function get_value_constant($name, $file_content)
	{
		$content = '';
		$pos = strpos($file_content, '\''.$name.'\'');
		if(!$pos)
			$pos = strpos($file_content, '"'.$name.'"');
		
		if($pos)
		{
			$dep = $pos+strlen($name)+2;
			
			// recherche du depart de la dclaration
			do
			{
				
				$car = $file_content[$dep];
				$dep++;
			}
			while($car != '"' && $car != '\'' && $dep < strlen($file_content));
			
			if($dep < strlen($file_content))
			{
				$fin = $dep;
				$car = $file_content[$fin];
				while($car != '"' && $car != '\'' && $fin < strlen($file_content))
				{
					$fin++;
					$car = $file_content[$fin];
				}
				
				
				if($fin < strlen($file_content) && $dep < $fin)
					$content = substr($file_content, $dep, $fin-$dep);
			}
		}
		return $content;
	}
	
	public function set_db_infos($host, $user, $password, $db_name, $db_prefix)
	{
		$this->db_prefix = $db_prefix;
		$this->db_host = $host;
		$this->db_user = $user;
		$this->db_password = $password;
		$this->db_name = $db_name;
	}
	
	public function save_db_config()
	{
		if(!is_dir(GENERAL_CONFIG_DIR)) mkdir(GENERAL_CONFIG_DIR);
		
		$fd = fopen(DATABASE_CONFIG_FILE, 'w');
		if($fd)
		{
			fwrite($fd, '<?php'."\n");
			fwrite($fd, 'define(\'_DB_SERVER_\', \''.$this->db_host.'\');'."\n");
			fwrite($fd, 'define(\'_DB_USER_\', \''.$this->db_user.'\');'."\n");
			fwrite($fd, 'define(\'_DB_PASSWD_\', \''.$this->db_password.'\');'."\n");
			fwrite($fd, 'define(\'_DB_NAME_\', \''.$this->db_name.'\');'."\n");
			fwrite($fd, 'define(\'_DB_PREFIX_\', \''.$this->db_prefix.'\');'."\n");
			fwrite($fd, '?>');
			fclose($fd);
			return true;
		}
		return false;
	}
	
	public function create_db()
	{
		$error = '';
		$version = $this->file_version_to_version(cloud_pref::get(PREF_VERSION));
		$db = db::getInstance();
		
		// il faut chercher tous les fichiers SQL depuis cette version
		$tab_files = array();
		$folder = DOSSIER_INSTALL_SQL;
		// Search file in the folder
		if (is_dir($folder))
		{
			$folder .= '/';

			$tab_temp = scandir($folder, 1);

			foreach ($tab_temp as $file)
			{
				$ext = strtolower(substr($file, -3));

				// uniquement les fichiers sql
				if ($ext == 'sql')
				{
					// decompose le nom de fichier
					$file_version = substr($file, 0, strlen($file)-4);
					
					if($this->file_version_to_version($file_version) > $version)
						$tab_files[] = $folder.$file;
				}
			}
		}
		
		if(count($tab_files)>0)
		{
			sort($tab_files, SORT_NATURAL );
			foreach ($tab_files as $f)
			{
				if (!self::install_db_file($f))
				{
					$error .= 'ERROR SQL : '.$f.' : '.$db->message_error()."\n";
				}
			}
		}
		return $error;
	}
	
	protected function file_version_to_version($file_version)
	{
		$version = $file_version;
		$pos_sep = strpos($file_version, '.');
		if($pos_sep)
		{
			$v = substr($file_version, 0, $pos_sep);
			$dec = substr($file_version, $pos_sep+1);
			
			$version = $v + ($dec/10000);
		}
		return $version;
	}
	
	protected function install_db_file($file)
	{
		$db = db::getInstance();
		$content = file_get_contents($file);
		Tools::clearErrors();
		
		if($content)
		{
			$content = str_replace('PREFIX', $this->db_prefix, $content);
			$db->multi_query($content);
			return true;
		}
		return false;
	}
}

?>