<?php
	require_once(GENERAL_CLASSES_DIR.'/table.php');
	require_once(GENERAL_CLASSES_DIR.'/client.php');
	require_once(GENERAL_CLASSES_DIR.'/ticket.php');
	require_once(GENERAL_CLASSES_DIR.'/type_ligne.php');
	
	define('LISTE_TYPE_LIGNE_STAT', '10, 30, 31');
	
	class detail_ticket extends table
	{
		public static $table_name = 'detail_ticket';
		public static $unique_id = 'IdDetailTicket';
		public static $field_list = array('IdTicket', 'IdDetailTicketMagasin', 'NumLigne', 'IdArticle', 'Quantite', 'MontantSansRemiseEuro', 'MontantLigneEuro', 'IdVendeuse', 'IdTypeLigneTicket', 'TauxTVA', 'PrimeVendeurEuro', 'RemiseP_O_N', 'MtRemiseP', 'Solde_O_N', 'Mt_NonSoldeEuro', 'MtRemiseEuro', 'DateModif', 'PrixRevientEuro', 'NumSerie', 'IdLienAcompte', 'MontantSansRemiseEuro_HT', 'Mt_NonSoldeEuro_HT', 'MontantLigneEuro_HT', 'CompteTVA', 'CompteArt', 'MtEcoTaxeHT', 'MtEcoTaxeTTC', 'DateReglement', 'NumSequentielArticle', 'Caisse_IP', 'NumSerieLibel', 'Declinaison_Code', 'IdMagasin', 'EcoTaxeTauxTVA', 'IdMagOrgModif', 'TriggerBatchBloque_O_N', 'Mt_NonSoldeUnitaireEuro_TTC', 'Mt_NonSoldeUnitaireEuro_HT', 'DateValidite', 'TVA_SurMarge_O_N', 'IdTauxTva', 'NumGestRegroup', 'NumGestMenu', 'HeureModif', 'ART_Nom', 'ART_Ref', 'ART_CodeBarre', 'ART_Declinaison', 'ART_LibelFacturation');
		
		protected static function select_complet()
		{
			$nom_table_client = db::dbname(client::$table_name);
			$nom_table_ticket = db::dbname(ticket::$table_name);
			$nom_table_type_ligne = db::dbname(type_ligne::$table_name);
			
			return 'select IdDetailTicket as id, '.self::liste_champs().', 
							'.$nom_table_client.'.Nom, '.$nom_table_client.'.Prenom, '.$nom_table_client.'.IdClientMagasin,
							'.$nom_table_ticket.'.Date_Crea, '.$nom_table_ticket.'.TicketRef
							from '.db::dbname(self::$table_name).'
							left join '.$nom_table_ticket.' on '.$nom_table_ticket.'.IdTicket='.db::dbname(self::$table_name).'.IdTicket 
							left join '.$nom_table_client.' on '.$nom_table_client.'.IdClient='.$nom_table_ticket.'.IdClient 
							left join '.$nom_table_type_ligne.' on '.db::dbname(self::$table_name).'.IdTypeLigneTicket='.$nom_table_type_ligne.'.IdTypeLigne ';
		}
		
		public static function get($id)
		{
			$db = db::getInstance();
			
			$req = self::select_complet();
			if($id > 0) $req.= ' where IdDetailTicket='.(int)$id;
			else
			{
				$mag = (int)context::get_context('magasin');
				if($mag > 0)
					$req.= ' Where '.db::dbname(ticket::$table_name).'.IdMagasin = '.$mag;
				
				$req.= ' order by IdDetailTicket';
			}
			
  		return $db->select($req);
			
		}
		
		public static function get_by_ticket($IdTicket)
		{
			$db = db::getInstance();
			
			$req = self::select_complet().' where '.db::dbname(self::$table_name).'.IdTicket='.(int)$IdTicket.'
  						order by IdDetailTicket';
  		return $db->select($req);
		}
		
		public static function get_by_magasin($IdDetailTicketMagasin, $IdMagasin)
		{
			$db = db::getInstance();
			
			$req = self::select_complet().' where IdDetailTicketMagasin='.(int)$IdDetailTicketMagasin.' and '.db::dbname(self::$table_name).'.IdMagasin='.(int)$IdMagasin.'
  						order by IdDetailTicketMagasin';
  		return $db->select($req);
  	}
  	
  	public static function get_reglements($id_client=0)
  	{
  		$db = db::getInstance();
			
			$req = self::select_complet().' where '.db::dbname(type_ligne::$table_name).'.Type_Principal=2 ';
			if($id_client > 0)
				$req.= ' and '.db::dbname(ticket::$table_name).'.IdClient='.$id_client;
			
  		$req.= ' order by IdDetailTicketMagasin';
  		return $db->select($req);
  	}
  	
  	public static function get_ventes($id_client=0)
  	{
  		$db = db::getInstance();
			
			$req = self::select_complet().' where '.db::dbname(type_ligne::$table_name).'.Type_Principal=1 ';
			if($id_client > 0)
				$req.= ' and '.db::dbname(ticket::$table_name).'.IdClient='.$id_client;
			
  		$req.= ' order by IdDetailTicketMagasin';
  		return $db->select($req);
  	}
  	
  	public static function from_date($date_start_en, $date_fin_en=null)
		{
			$db = db::getInstance();
			$nom_table_ticket = db::dbname(ticket::$table_name);
			$req = self::select_complet();
			$req.= ' where ';
			if($date_fin_en)
				$req.= $nom_table_ticket.'.Date_Crea>="'.db::esc($date_start_en).'" And Date_Crea<="'.db::esc($date_fin_en).'"';
  		else
				$req.= $nom_table_ticket.'.Date_Crea="'.db::esc($date_start_en).'"';
			$mag = (int)context::get_context('magasin');
			if($mag > 0)
				$req.= ' And '.$nom_table_ticket.'.IdMagasin = '.$mag;
			return $db->select($req);
		}
  	
  	public static function save_from_xml($xml, $id_magasin)
  	{
  		$db = db::getInstance();
  		$IdDetailTicketMagasin = self::get_xml_value($xml, 'IdTicket_Detail');
  		$detail = null;
  		
  		if($IdDetailTicketMagasin > 0)
  			$detail = self::get_by_magasin($IdDetailTicketMagasin, $id_magasin);
  		
  		// il faut dduire l'idTicket cloud
  		$ticket = ticket::get_by_magasin(self::get_xml_value($xml, 'IdTicket'), $id_magasin);
  		if($ticket)
  		{
	  		
	  		if(!$detail)// insertion
	  			return self::insert_from_xml($xml, $id_magasin, $ticket[0]['id']);
	  		else // modification
	  			return self::update_from_xml($detail[0]['id'], $xml, $id_magasin, $ticket[0]['id']);
	  	}
  	}
  	
  	protected static function insert_from_xml($xml, $id_magasin, $id_ticket_cloud)
  	{
  		if($id_ticket_cloud > 0)
  		{
  			$query = 'insert into '.db::dbname(self::$table_name).'
	  							(
	  							 IdTicket, IdDetailTicketMagasin, NumLigne, IdArticle, Quantite, 
	  							 MontantSansRemiseEuro, MontantLigneEuro, IdVendeuse, IdTypeLigneTicket, TauxTVA, 
	  							 PrimeVendeurEuro, RemiseP_O_N, MtRemiseP, Solde_O_N, Mt_NonSoldeEuro, MtRemiseEuro, 
	  							 DateModif, PrixRevientEuro, NumSerie, IdLienAcompte, MontantSansRemiseEuro_HT, Mt_NonSoldeEuro_HT, 
	  							 MontantLigneEuro_HT, CompteTVA, CompteArt, MtEcoTaxeHT, MtEcoTaxeTTC, DateReglement, 
	  							 NumSequentielArticle, Caisse_IP, NumSerieLibel, Declinaison_Code, IdMagasin, EcoTaxeTauxTVA, 
	  							 IdMagOrgModif, TriggerBatchBloque_O_N, Mt_NonSoldeUnitaireEuro_TTC, Mt_NonSoldeUnitaireEuro_HT,
	  							 DateValidite, TVA_SurMarge_O_N, IdTauxTva, NumGestRegroup, NumGestMenu, HeureModif, ART_Nom, 
	  							 ART_Ref, ART_CodeBarre, ART_Declinaison, ART_LibelFacturation)
	  							 values
	  							 ('.(int)$id_ticket_cloud.', '.(int)self::get_xml_value($xml, 'IdTicket_Detail').',
	  							 '.(int)self::get_xml_value($xml, 'NumLigne').', '.(int)self::get_xml_value($xml, 'IdArticle').',
	  							 '.db::real(self::get_xml_value($xml, 'Quantite')).', '.db::real(self::get_xml_value($xml, 'MontantSansRemiseEuro')).',
	  							 '.db::real(self::get_xml_value($xml, 'MontantLigneEuro')).', '.(int)self::get_xml_value($xml, 'IdVendeuse').',
	  							 '.(int)self::get_xml_value($xml, 'IdTypeLigneTicket').', '.db::real(self::get_xml_value($xml, 'TauxTVA')).',
	  							 '.db::real(self::get_xml_value($xml, 'PrimeVendeurEuro')).', '.(int)self::get_xml_value($xml, 'RemiseP_O_N').',
	  							 '.db::real(self::get_xml_value($xml, 'MtRemiseP')).', '.(int)self::get_xml_value($xml, 'Solde_O_N').',
	  							 '.db::real(self::get_xml_value($xml, 'Mt_NonSoldeEuro')).', '.db::real(self::get_xml_value($xml, 'MtRemiseEuro')).',
	  							 "'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateModif')).'", '.db::real(self::get_xml_value($xml, 'PrixRevientEuro')).',
	  							 "'.db::esc(self::get_xml_value($xml, 'NumSerie')).'", '.(int)self::get_xml_value($xml, 'IdLienAcompte').',
	  							 '.db::real(self::get_xml_value($xml, 'MontantSansRemiseEuro_HT')).', '.db::real(self::get_xml_value($xml, 'Mt_NonSoldeEuro_HT')).',
	  							 '.db::real(self::get_xml_value($xml, 'MontantLigneEuro_HT')).', "'.db::esc(self::get_xml_value($xml, 'CompteTVA')).'",
	  							 "'.db::esc(self::get_xml_value($xml, 'CompteArt')).'", '.db::real(self::get_xml_value($xml, 'MtEcoTaxeHT')).',
	  							 '.db::real(self::get_xml_value($xml, 'MtEcoTaxeTTC')).', "'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateReglement')).'",
	  							 "'.db::esc(self::get_xml_value($xml, 'NumSequentielArticle')).'", "'.db::esc(self::get_xml_value($xml, 'Caisse_IP')).'",
	  							 "'.db::esc(self::get_xml_value($xml, 'NumSerieLibel')).'", "'.db::esc(self::get_xml_value($xml, 'Declinaison_Code')).'",
	  							 '.(int)$id_magasin.', '.db::real(self::get_xml_value($xml, 'EcoTaxeTauxTVA')).',
	  							 '.(int)self::get_xml_value($xml, 'IdMagOrgModif').', '.(int)self::get_xml_value($xml, 'TriggerBatchBloque_O_N').',
	  							 '.db::real(self::get_xml_value($xml, 'Mt_NonSoldeUnitaireEuro_TTC')).', '.db::real(self::get_xml_value($xml, 'Mt_NonSoldeUnitaireEuro_HT')).',
	  							 "'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateValidite')).'", '.(int)self::get_xml_value($xml, 'TVA_SurMarge_O_N').',
	  							 '.(int)self::get_xml_value($xml, 'IdTauxTva').', '.(int)self::get_xml_value($xml, 'NumGestRegroup').',
	  							 '.(int)self::get_xml_value($xml, 'NumGestMenu').', "'.Tools::dateIsoToTime(self::get_xml_value($xml, 'HeureModif')).'",
	  							 "'.db::esc(self::get_xml_value($xml, 'ART_Nom')).'", "'.db::esc(self::get_xml_value($xml, 'ART_Ref')).'",
	  							 "'.db::esc(self::get_xml_value($xml, 'ART_CodeBarre')).'", "'.db::esc(self::get_xml_value($xml, 'ART_Declinaison')).'",
	  							 "'.db::esc(self::get_xml_value($xml, 'ART_LibelFacturation')).'")';
	  		$db = db::getInstance();
	  		if($db->query($query))
	  		{
	  			$id = $db->last_insert_id();
	  			//self::new_log_batch($id);
	  			return $id;
	  		}
	  	}
	  	return false;
  	}
  	
  	protected static function update_from_xml($id_detail_ticket, $xml, $id_magasin, $id_ticket_cloud)
  	{
  		if($id_ticket_cloud > 0)
  		{
	  		$query = 'update '.db::dbname(self::$table_name).' set 
	  							IdTicket='.(int)$id_ticket_cloud.',
	  							IdDetailTicketMagasin='.(int)self::get_xml_value($xml, 'IdTicket_Detail').', NumLigne='.(int)self::get_xml_value($xml, 'NumLigne').',
	  							IdArticle='.(int)self::get_xml_value($xml, 'IdArticle').', Quantite='.db::real(self::get_xml_value($xml, 'Quantite')).', 
	  							MontantSansRemiseEuro='.db::real(self::get_xml_value($xml, 'MontantSansRemiseEuro')).', MontantLigneEuro='.db::real(self::get_xml_value($xml, 'MontantLigneEuro')).',
	  							IdVendeuse='.(int)self::get_xml_value($xml, 'IdVendeuse').', IdTypeLigneTicket='.(int)self::get_xml_value($xml, 'IdTypeLigneTicket').', 
	  							TauxTVA='.db::real(self::get_xml_value($xml, 'TauxTVA')).', PrimeVendeurEuro='.db::real(self::get_xml_value($xml, 'PrimeVendeurEuro')).', 
	  							RemiseP_O_N='.(int)self::get_xml_value($xml, 'RemiseP_O_N').', MtRemiseP='.db::real(self::get_xml_value($xml, 'MtRemiseP')).', 
	  							Solde_O_N='.(int)self::get_xml_value($xml, 'Solde_O_N').', Mt_NonSoldeEuro='.db::real(self::get_xml_value($xml, 'Mt_NonSoldeEuro')).', 
	  							MtRemiseEuro='.db::real(self::get_xml_value($xml, 'MtRemiseEuro')).',
	  							DateModif="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateModif')).'", PrixRevientEuro='.db::real(self::get_xml_value($xml, 'PrixRevientEuro')).', 
	  							NumSerie="'.db::esc(self::get_xml_value($xml, 'NumSerie')).'", IdLienAcompte='.(int)self::get_xml_value($xml, 'IdLienAcompte').',
	  							MontantSansRemiseEuro_HT='.db::real(self::get_xml_value($xml, 'MontantSansRemiseEuro_HT')).', Mt_NonSoldeEuro_HT='.db::real(self::get_xml_value($xml, 'Mt_NonSoldeEuro_HT')).', 
	  							MontantLigneEuro_HT='.db::real(self::get_xml_value($xml, 'MontantLigneEuro_HT')).', CompteTVA="'.db::esc(self::get_xml_value($xml, 'CompteTVA')).'", 
	  							CompteArt="'.db::esc(self::get_xml_value($xml, 'CompteArt')).'", MtEcoTaxeHT='.db::real(self::get_xml_value($xml, 'MtEcoTaxeHT')).',
	  							MtEcoTaxeTTC='.db::real(self::get_xml_value($xml, 'MtEcoTaxeTTC')).', DateReglement="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateReglement')).'",
	  							NumSequentielArticle="'.db::esc(self::get_xml_value($xml, 'NumSequentielArticle')).'", Caisse_IP="'.db::esc(self::get_xml_value($xml, 'Caisse_IP')).'", 
	  							NumSerieLibel="'.db::esc(self::get_xml_value($xml, 'NumSerieLibel')).'", Declinaison_Code="'.db::esc(self::get_xml_value($xml, 'Declinaison_Code')).'",
	  							IdMagasin='.(int)$id_magasin.', EcoTaxeTauxTVA='.db::real(self::get_xml_value($xml, 'EcoTaxeTauxTVA')).',
	  							IdMagOrgModif='.(int)self::get_xml_value($xml, 'IdMagOrgModif').', TriggerBatchBloque_O_N='.(int)self::get_xml_value($xml, 'TriggerBatchBloque_O_N').',
	  							Mt_NonSoldeUnitaireEuro_TTC='.db::real(self::get_xml_value($xml, 'Mt_NonSoldeUnitaireEuro_TTC')).', Mt_NonSoldeUnitaireEuro_HT='.db::real(self::get_xml_value($xml, 'Mt_NonSoldeUnitaireEuro_HT')).',
	  							DateValidite="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateValidite')).'", TVA_SurMarge_O_N='.(int)self::get_xml_value($xml, 'TVA_SurMarge_O_N').', 
	  							IdTauxTva='.(int)self::get_xml_value($xml, 'IdTauxTva').', NumGestRegroup='.(int)self::get_xml_value($xml, 'NumGestRegroup').',
	  							NumGestMenu='.(int)self::get_xml_value($xml, 'NumGestMenu').', HeureModif="'.Tools::dateIsoToTime(self::get_xml_value($xml, 'HeureModif')).'",
	  							ART_Nom="'.db::esc(self::get_xml_value($xml, 'ART_Nom')).'", ART_Ref="'.db::esc(self::get_xml_value($xml, 'ART_Ref')).'",
	  							ART_CodeBarre="'.db::esc(self::get_xml_value($xml, 'ART_CodeBarre')).'", ART_Declinaison="'.db::esc(self::get_xml_value($xml, 'ART_Declinaison')).'",
	  							ART_LibelFacturation="'.db::esc(self::get_xml_value($xml, 'ART_LibelFacturation')).'"
	  							Where IdDetailTicket='.(int)$id_detail_ticket;
	  		$db = db::getInstance();
	  		if($db->query($query))
	  		{
	  			//self::new_log_batch($id_detail_ticket);
	  			return $id_detail_ticket;
	  		}
	  	}
	  	return false;
  	}
  	
  	public static function stats_vente($date_deb, $date_fin, $regroupement='DATE', $prix='HT', $mag=0)
  	{
  		$nom_table_type_ligne = db::dbname(type_ligne::$table_name);
  		$nom_table_ticket = db::dbname(ticket::$table_name);
  		$order = $nom_table_ticket.'.Date_Crea';
  		switch($regroupement)
  		{
  			case 'JOUR':
  				$champ_regroup = 'DATE_FORMAT('.$nom_table_ticket.'.Date_Crea, "%w")';
  				$order = 'absice';
  				break;
  			case 'SEMAINE':
  				$champ_regroup = 'DATE_FORMAT('.$nom_table_ticket.'.Date_Crea, "%u")';
  				$order = 'absice';
  				break;
  			case 'MOIS':
  				$champ_regroup = 'DATE_FORMAT('.$nom_table_ticket.'.Date_Crea, "%m")';
  				$order = 'absice';
  				break;
  			default:
  				$champ_regroup = 'DATE_FORMAT('.$nom_table_ticket.'.Date_Crea, "%d/%m/%Y")';
  		}
  		
  		switch($prix)
  		{
  			case 'TTC':
  				$champ = 'MontantLigneEuro';
  				break;
  			default:
  				$champ = 'MontantLigneEuro_HT';
  		}
  		
  		$db = db::getInstance();
  		$req = 'Select sum('.$champ.') as Cumul, '.$champ_regroup.' as absice
  							from '.db::dbname(self::$table_name).'
  							left join '.$nom_table_type_ligne.' on '.$nom_table_type_ligne.'.IdTypeLigne='.db::dbname(self::$table_name).'.IdTypeLigneTicket And '.$nom_table_type_ligne.'.Type_Principal=1 ';
  		
  		$req.= ' left join '.$nom_table_ticket.' on '.$nom_table_ticket.'.IdTicket='.db::dbname(self::$table_name).'.IdTicket ';
  		
  		$req.= '	Where '.db::dbname(self::$table_name).'.IdTypeLigneTicket in ('.LISTE_TYPE_LIGNE_STAT.') 
  							And '.$nom_table_ticket.'.Date_Crea >="'.$date_deb.'" and '.$nom_table_ticket.'.Date_Crea <="'.$date_fin.'" ';
  		
  		if($mag > 0) $req.= ' And '.$nom_table_ticket.'.IdMagasin = '.(int)$mag;
  		
  		$req.= '	Group by '.$champ_regroup.'
  							Order by '.$order;
  		return $db->select($req);
  		
  	}
  	
  	public static function stats_marge($date_deb, $date_fin, $regroupement='DATE', $mag=0)
  	{
  		$nom_table_type_ligne = db::dbname(type_ligne::$table_name);
  		$nom_table_ticket = db::dbname(ticket::$table_name);
  		$order = $nom_table_ticket.'.Date_Crea';
  		
  		switch($regroupement)
  		{
  			case 'JOUR':
  				$champ_regroup = 'DATE_FORMAT('.$nom_table_ticket.'.Date_Crea, "%w")';
  				$order = 'absice';
  				break;
  			case 'SEMAINE':
  				$champ_regroup = 'DATE_FORMAT('.$nom_table_ticket.'.Date_Crea, "%u")';
  				$order = 'absice';
  				break;
  			case 'MOIS':
  				$champ_regroup = 'DATE_FORMAT('.$nom_table_ticket.'.Date_Crea, "%m")';
  				$order = 'absice';
  				break;
  			default:
  				$champ_regroup = 'DATE_FORMAT('.$nom_table_ticket.'.Date_Crea, "%d/%m/%Y")';
  		}
  		
  		$db = db::getInstance();
  		$req = 'Select sum(MontantLigneEuro_HT - PrixRevientEuro) as Cumul, '.$champ_regroup.' as absice
  							from '.db::dbname(self::$table_name).'
  							left join '.$nom_table_type_ligne.' on '.$nom_table_type_ligne.'.IdTypeLigne='.db::dbname(self::$table_name).'.IdTypeLigneTicket And '.$nom_table_type_ligne.'.Type_Principal=1 ';
  		
  		$req.= ' left join '.$nom_table_ticket.' on '.$nom_table_ticket.'.IdTicket='.db::dbname(self::$table_name).'.IdTicket ';
  		
  		$req.= '	Where '.db::dbname(self::$table_name).'.IdTypeLigneTicket in ('.LISTE_TYPE_LIGNE_STAT.') 
  							And '.$nom_table_ticket.'.Date_Crea >="'.$date_deb.'" and '.$nom_table_ticket.'.Date_Crea <="'.$date_fin.'" ';
  		
  		if($mag > 0) $req.= ' And '.$nom_table_ticket.'.IdMagasin = '.(int)$mag;
  		
  		$req.= '	Group by '.$champ_regroup.'
  							Order by '.$order;
  		
  		return $db->select($req);
  		
  	}
	}
?>