Create table if not exists PREFIXcloud_pref (
	IdCloudPref int not null primary key auto_increment, 
	Cle varchar(100), 
	Valeur_Str varchar(255), 
	Valeur_Int integer, 
	Date_Modification datetime) DEFAULT CHARSET=utf8;

create table if not exists PREFIXuser (
  IdUser int(11) not null primary key auto_increment,
  Email varchar(50) not null,
  MotPasse varchar(45) not null,
  Date_Creation datetime not null,
  Date_Modification datetime not null,
  unique key indIdentifiant (Email),
  key indMotPasse (MotPasse)) DEFAULT CHARSET=utf8;
  
Create table if not exists PREFIXsession (
  IdSession int(11) not null primary key auto_increment,
  Session char(32) not null,
  IdUser int(11) not null,
  Date_Valid datetime not null,
  key indSession (Session),
  key indSessionUser (IdUser)) DEFAULT CHARSET=utf8;


CREATE TABLE if not exists PREFIXclient (
	IdClient int not null primary key auto_increment,
	IdClientMagasin int not null default 0,
	IdClientReseau int not null default 0,
	IdMagasin int not null default 0,
	IdClientFusion int not null default 0,
	Nom varchar(30),
	Prenom varchar(20),
	Adresse1 varchar(60),
	Adresse2 varchar(60),
	Adresse3 varchar(30),
	Adresse4 varchar(30),
	CodePostal varchar(10),
	Ville varchar(25),
	EMail varchar(40),
	CodeClient varchar(80),
	Civilite varchar(5),
	Tel_maison varchar(30),
	ExonereTVA_O_N int(1) not null default 0,
	Inactif_O_N int(1) not null default 0,
	Tel_portable varchar(30),
	Tel_travail varchar(30),
	Date_naissance date,
	Commentaire text,
	Societe varchar(60),
	NumTVA_Intra varchar(30),
	DateFinValiditeAdhesion date,
	IdClient_CB_Auto varchar(20),
	Fax varchar(30),
	SiteWeb varchar(100),
	FACT_IdImprFacture int not null default 0,
	InfoLibre_Libel varchar(80),
	InfoLibre_Valeur varchar(80),
	NumCompteCompta varchar(10),
	VenteHT_O_N int(1) not null default 0,
	IdPays int not null default 0,
	IdVendeur int not null default 0,
	IdMagOrgModif int not null default 0,
	TriggerBatchBloque_O_N int(1) not null default 0,
	Titre varchar(80),
	IdPrixVenteType int not null default 0,
	DateCrea_Auto date,
	DateModif_Auto date,
	HeureModif_Auto time,
	ClefCodifiee varchar(11),
	Prospect_O_N int(1) not null default 0,
	FACT_NbJourPaiement int not null default 0,
	TEL_RECH_portable varchar(30),
	TEL_RECH_maison varchar(30),
	TEL_RECH_travail varchar(30),
	WEB_MasquerVenteBoutique_O_N int(1) not null default 0,
	IdTauxTvaExo int not null default 0,
	TauxTvaExo double,
	DateModification datetime,
	DateCreation datetime) DEFAULT CHARSET=utf8;

Create Index indCLIENTIdClientMagasin on PREFIXclient (IdClientMagasin);

Create Index indCLIENTIdMagasin on PREFIXclient (IdMagasin);

Create table if not exists PREFIXmagasin (
	IdMagasin int not null primary key auto_increment,
	Nom varchar(30),
	CodePostal varchar(10),
	Cle varchar(80),
	Identifiant varchar(20),
	MotPasse varchar(45),
	DateCreation datetime,
	DateModification datetime) DEFAULT CHARSET=utf8;

Create Index indMAGASINCle on PREFIXmagasin (Cle);

Create table if not exists PREFIXticket (
	IdTicket int not null primary key auto_increment,
	IdClient int not null default 0,
	IdMagasin int not null default 0,
	IdTicketMagasin int not null default 0,
	Date_Crea date,
	Heure_Crea time,
	EnCours_O_N int(1) not null default 0,
	IdVendeuse int not null default 0,
	MontantSoldeEuro double not null default 0,
	IdCaissiere int not null default 0,
	MontantVenteEuro double not null default 0,
	StockTraiter_O_N int(1) not null default 0,
	Commentaire varchar(80),
	DateModif date,
	Groupe int not null default 0,
	ValeurChqFidel double not null default 0,
	Rembt_O_N int(1) not null default 0,
	FinValiditeChqFidel date,
	Facture_Numero int not null default 0,
	Facture_Nom varchar(40),
	Facture_NumIntraClient varchar(30),
	Facture_Date date,
	TicketRef double,
	Livr_Nom varchar(40),
	IdTicket_txt_codeBarre varchar(20),
	Facture_Valider_O_N int(1) not null default 0,
	Caisse_IP varchar(20),
	Facture_Info_Libel text,
	Facture_Info_Valeur text,
	NumCommande varchar(20),
	NumTable int not null default 0,
	IdTicketType int not null default 0,
	AncienNumFacture int not null default 0,
	Facture_date_echeance date,
	Facture_Civilite varchar(5),
	Facture_Prenom varchar(20),
	Facture_Societe varchar(60),
	Facture_Adr1 varchar(60),
	Facture_Adr2 varchar(60),
	Facture_Adr3 varchar(30),
	Facture_Adr4 varchar(30),
	Facture_CP varchar(10),
	Facture_Ville varchar(25),
	Facture_IdPays int not null default 0,
	Livr_Civilite varchar(5),
	Livr_Prenom varchar(20),
	Livr_Societe varchar(60),
	Livr_Adr1 varchar(60),
	Livr_Adr2 varchar(60),
	Livr_Adr3 varchar(30),
	Livr_Adr4 varchar(30),
	Livr_CP varchar(10),
	Livr_Ville varchar(25),
	Livr_IdPays int not null default 0,
	IdMagOrgModif int not null default 0,
	TriggerBatchBloque_O_N int(1) not null default 0,
	EMPL_Libel varchar(80),
	EMPL_Num int not null default 0,
	Livr_Tel varchar(30),
	Livr_CodePorte varchar(255),
	Livr_Date date,
	Livr_Heure time,
	Livr_Info varchar(255),
	DateCreation datetime,
	DateModification datetime) DEFAULT CHARSET=utf8;

Create Index indTICKET_IdClient on PREFIXticket (IdClient);
Create Index indTICKET_IdMagasin on PREFIXticket (IdMagasin);
Create Index indTICKET_Date_Crea on PREFIXticket (Date_Crea);
Create Index indTICKET_Heure_Crea on PREFIXticket (Heure_Crea);

Create table if not exists PREFIXdetail_ticket (
	IdDetailTicket int not null primary key auto_increment,
	IdTicket int not null default 0,
	IdDetailTicketMagasin int not null default 0,
	NumLigne int not null default 0,
	IdArticle int not null default 0,
	Quantite double not null default 0,
	MontantSansRemiseEuro double not null default 0,
	MontantLigneEuro double not null default 0,
	IdVendeuse int not null default 0,
	IdTypeLigneTicket int not null default 0,
	TauxTVA double not null default 0,
	PrimeVendeurEuro double not null default 0,
	RemiseP_O_N int(1) not null default 0,
	MtRemiseP double not null default 0,
	Solde_O_N int(1) not null default 0,
	Mt_NonSoldeEuro double not null default 0,
	MtRemiseEuro double not null default 0,
	DateModif date,
	PrixRevientEuro double not null default 0,
	NumSerie varchar(40),
	IdLienAcompte int not null default 0,
	MontantSansRemiseEuro_HT double not null default 0,
	Mt_NonSoldeEuro_HT double not null default 0,
	MontantLigneEuro_HT double not null default 0,
	CompteTVA varchar(80),
	CompteArt varchar(80),
	MtEcoTaxeHT double not null default 0,
	MtEcoTaxeTTC double not null default 0,
	DateReglement date,
	NumSequentielArticle int not null default 0,
	Caisse_IP varchar(20),
	NumSerieLibel varchar(40),
	Declinaison_Code varchar(255),
	IdMagasin int not null default 0,
	EcoTaxeTauxTVA double not null default 0,
	IdMagOrgModif int not null default 0,
	TriggerBatchBloque_O_N int(1) not null default 0,
	Mt_NonSoldeUnitaireEuro_TTC double not null default 0,
	Mt_NonSoldeUnitaireEuro_HT double not null default 0,
	DateValidite date,
	TVA_SurMarge_O_N int(1) not null default 0,
	IdTauxTva int not null default 0,
	NumGestRegroup int not null default 0,
	NumGestMenu int not null default 0,
	HeureModif time,
	ART_Nom Text,
	ART_Ref varchar(80),
	ART_CodeBarre varchar(80),
	ART_Declinaison varchar(80),
	ART_LibelFacturation Text) DEFAULT CHARSET=utf8;

Create Index indDETAIL_TICKET_IdTicket on PREFIXdetail_ticket (IdTicket);
Create Index indDETAIL_TICKET_NumLigne on PREFIXdetail_ticket (NumLigne);
Create Index indDETAIL_TICKET_IdMagasin on PREFIXdetail_ticket (IdMagasin);


Create table if not exists PREFIXfidelite_type (
	IdFideliteType int not null primary key,
	Libel Text,
	Date_Creation datetime,
	Date_Modification datetime) DEFAULT CHARSET=utf8;
	
Create table if not exists PREFIXfidelite_mvt_type (
	IdFideliteMvtType int not null primary key,
	Libel Text,
	Date_Creation datetime,
	Date_Modification datetime) DEFAULT CHARSET=utf8;
	
Create table if not exists PREFIXfidelite_mvt (
	IdFideliteMvt int not null primary key AUTO_INCREMENT,
	IdFideliteMvtMagasin int not null,
	IdMagasin int not null,
	IdFideliteMvtType int,
	IdClient int not null,
	IdTicket int not null,
	DateMvt date,
	Valeur double,
	Remb_O_N int(1),
	Remb_Date date,
	Remb_Heure time,
	Remb_IdClient int,
	IdFideliteType int not null default 0,
	DateFinValidite date,
	Reste double,
	HeureMvt time,
	TriggerBatchBloque_O_N int(1) not null default 0,
	Date_Creation datetime,
	Date_Modification datetime) DEFAULT CHARSET=utf8;
	
Create Index indFIDELITE_MVTIdClient on PREFIXfidelite_mvt (IdClient);
Create Index indFIDELITE_MVTIdTicket on PREFIXfidelite_mvt (IdTicket);

Create table if not exists PREFIXlog_batch (
	IdLogBatch int not null primary key AUTO_INCREMENT,
	DateLog datetime,
	NomTable varchar(255),
	IdEnregTable int not null) DEFAULT CHARSET=utf8;

Create Index indLogBatchDateLog on PREFIXlog_batch (DateLog);
Create Index indLogBatchNomTable on PREFIXlog_batch (NomTable);
Create Index indLogBatchIdEnregTable on PREFIXlog_batch (IdEnregTable);

Create table if not exists PREFIXtype_ligne_ticket (
	IdTypeLigne int not null primary key,
	Libel Text,
	Type_Principal int not null default 0,
	Date_Creation datetime,
	Date_Modification datetime) DEFAULT CHARSET=utf8;
	
Create table if not exists PREFIXlog_action_batch (
	IdLogActionBatch int not null primary key AUTO_INCREMENT,
	DateDepart datetime,
	DateFin datetime,
	IdMagasin int not null default 0,
	NbClient int not null default 0,
	NbClientErreur int not null default 0,
	NbTicket int not null default 0,
	NbTicketErreur int not null default 0,
	NbDetailTicket int not null default 0,
	NbDetailTicketErreur int not null default 0,
	NbFidelite int not null default 0,
	NbFideliteErreur int not null default 0) DEFAULT CHARSET=utf8;

Insert into PREFIXcloud_pref (Cle, Valeur_Str, Date_Modification) values ('VERSION', '1.0', CURRENT_TIMESTAMP);