<?php
	include('_init.php');
	require_once(GENERAL_CLASSES_DIR.'/detail_ticket.php');
	$datas = null;
	$rech = '';
	$search = '';
	$ident_menu = 'detail_ticket';
	
	if($id<=0)
	{
		// recherche ticket
		$rech = Tools::getValue('rech');
		if($rech != '')
			detail_ticket::save_param('rech', $rech);
		else	// s'il n'y a pas de recherche, il y a peut etre une ancienne recherche memorise
			$rech = detail_ticket::get_param('rech');
		
	}
	
	if($rech)
	{
		switch($rech)
		{
			case 'dujour':
				$depart_cumul = date('d/m/Y');
				$fin_cumul = $depart_cumul;
				$datas = detail_ticket::from_date(date('Y-m-d'));
				break;
			case 'periode':
				detail_ticket::save_param('rech', $rech);
				$depart_cumul = Tools::getValue('date_depart');
				$fin_cumul = Tools::getValue('date_fin');
				if(!$depart_cumul || !$fin_cumul)
				{
					$depart_cumul = detail_ticket::get_param('date_depart');
					$fin_cumul = detail_ticket::get_param('date_fin');
				}
				else
				{
					detail_ticket::save_param('date_depart', $depart_cumul);
					detail_ticket::save_param('date_fin', $fin_cumul);
				}
				$datas = detail_ticket::from_date(db::date_to_db($depart_cumul), db::date_to_db($fin_cumul));
				break;
			case 'tout':
				$depart_cumul = '00/00/0000';
				$fin_cumul = date('d/m/Y');
				$datas = detail_ticket::get(0);
		}
	}
	else
	{
		// par dfaut on affiche tous les details de tickets du mois en cours
		$mois = mktime( 0, 0, 0, date('m'), 1, date('Y')); 
		$nb_jours = date("t",$mois); 
		
		$depart_cumul = '01/'.date('m/Y');
		$fin_cumul = date('d/m/Y');
				
		$datas = detail_ticket::from_date(date('Y-m').'-01', date('Y-m').'-'.$nb_jours);
		$smarty->assign('details', ticket::get_details($id));
	}
	
	$smarty->assign('context_mag', (int)context::get_context('magasin'));
	
	$smarty->assign('types_ligne', type_ligne::liste());
	$smarty->assign('date_depart_cumul', $depart_cumul);
	$smarty->assign('date_fin_cumul', $fin_cumul);
	
	$smarty->assign('date_depart', '01/'.date('m/Y'));
	$smarty->assign('date_fin', date('d/m/Y'));
	
	include('_display.php');
?>