<?php
	require_once(GENERAL_CLASSES_DIR.'/table.php');
	require_once(GENERAL_CLASSES_DIR.'/ip_block.php');
	
	class magasin extends table
	{
		public static $table_name = 'magasin';
		public static $field_list = array('Nom', 'CodePostal', 'Cle', 'Identifiant', 'MotPasse');
		
		
		public static function get($id='')
		{
			$db = db::getInstance();
			
			$req = 'select IdMagasin as id, '.self::liste_champs(self::$table_name, self::$field_list).'
							from '.db::dbname(self::$table_name);
			if($id != '')
				$req.= ' where IdMagasin='.(int)$id;
  		return $db->select($req);
		}
		
		public static function identification($ident, $pass, $cle, &$erreur=null)
		{
			$id = 0;
			$erreur = ip_block::temps_avant_reconnexion();
			if($erreur <= 0)
			{
				$db = db::getInstance();
				
				$req = 'select IdMagasin as id, '.self::liste_champs(self::$table_name, self::$field_list).'
								from '.db::dbname(self::$table_name).'
								where Identifiant="'.db::esc(utf8_encode(rawurldecode($ident))).'" And MotPasse=PASSWORD("'.db::esc(utf8_encode(rawurldecode($pass))).'") And IdMagasin="'.db::esc(utf8_encode(rawurldecode($cle))).'"';
				$res = $db->select($req);
	  		
	  		
	  		if($res)
	  		{
	  			ip_block::ip_clear();
	  			$id = $res[0]['id'];
	  		}
	  		else
	  		{
	  			ip_block::inc_echec();
	  			$erreur = ip_block::temps_avant_reconnexion();
	  		}
	  	}
  		
  		return $id;
		}
		
		public static function add($values)
		{
			if(isset($values['Nom']) && isset($values['CodePostal']))
			{
				$db = db::getInstance();
				$req = 'insert into '.db::dbname(self::$table_name).' (Nom, CodePostal, Cle, Identifiant, MotPasse, DateCreation, DateModification) values
				("'.db::esc($values['Nom']).'", "'.db::esc($values['CodePostal']).'", "'.db::esc($values['Cle']).'", "'.db::esc($values['Identifiant']).'", PASSWORD("'.db::esc($values['MotPasse']).'"), CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)';
				
				$db->query($req);
				
				return $db->last_insert_id();
			}
			else
				return false;
		}
		
		public static function update($id, $values)
		{
			$db = db::getInstance();
			$req = 'update '.db::dbname(self::$table_name).' set
							Nom="'.db::esc($values['Nom']).'",
							CodePostal="'.db::esc($values['CodePostal']).'",
							Cle="'.db::esc($values['Cle']).'",
							Identifiant="'.db::esc($values['Identifiant']).'", ';
			if(isset($values['MotPasse']) && $values['MotPasse'] != '')
				$req.='MotPasse= PASSWORD("'.db::esc($values['MotPasse']).'"), ';
			$req.= 'DateModification=CURRENT_TIMESTAMP
							where IdMagasin='.(int)$id;
			if($db->query($req))
					return $id;
			
			return false;
							
		}
		
		public static function save($id)
		{
			$values = self::get_current_values();
			
			if($id <= 0)
				return self::add($values);
			else
				return self::update($id, $values);
			
			return false;
		}
		
		public static function delete($id)
		{
			$db = db::getInstance();
			$req = 'delete from '.db::dbname(self::$table_name).' 
							where IdMagasin='.(int)$id;
			if($db->query($req))
				return true;
			else
				return false;
		}
		
		public static function get_current_values()
		{
			$values = array();
			$values['id'] = Tools::getValue('id');
			$values['Nom'] = Tools::getValue('Nom');
			$values['CodePostal'] = Tools::getValue('CodePostal');
			$values['Cle'] = Tools::getValue('Cle');
			$values['Identifiant'] = Tools::getValue('Identifiant');
			$values['MotPasse'] = Tools::getValue('MotPasse');
			
			return $values;
		}
	}
?>