<?php
require_once(GENERAL_CLASSES_DIR.'/table.php');

class type_ligne extends table
{
	public static $table_name = 'type_ligne_ticket';
	public static $unique_id = 'IdTypeLigne';
	public static $field_list = array('Libel', 'Type_Principal');
		
	
	
	public static function get($id)
	{
		$lib = false;
		$db = db::getInstance();
		$req = 'select '.self::$unique_id.' as id, '.self::liste_champs(self::$table_name, self::$field_list).'
							from '.db::dbname(self::$table_name).'
  				where '.self::$unique_id.'='.(int)$id;
  	$res = $db->select($req);
  	
  	if($res)
  		$lib = $res[0]['Libel'];
  		
  	return $lib;
	}
	
	public static function liste()
	{
		$liste = false;
		$db = db::getInstance();
		$req = 'select '.self::$unique_id.' as id, '.self::liste_champs(self::$table_name, self::$field_list).'
							from '.db::dbname(self::$table_name).'
  				order by '.self::$unique_id;
  	$res = $db->select($req);
  	
  	foreach($res as $r)
  		$liste[$r['id']] = $r['Libel'];
  		
  	return $liste;
	}
	
	public static function import_types($xml)
  {
		$db = db::getInstance();
		for($i=0; $i < $xml->length; $i++)
		{
			$id = self::get_xml_value($xml->item($i), 'ID');
			$libel = self::get_xml_value($xml->item($i), 'LIBEL');
			$type_principal = self::get_xml_value($xml->item($i), 'TYPE_PRINCIPAL');
			
			$t = self::get($id);
			if($t)
				$q = 'update '.db::dbname('type_ligne_ticket').' set Libel="'.db::esc($libel).'", Type_Principal='.(int)$type_principal.', Date_Modification=CURRENT_TIMESTAMP
							Where IdTypeLigne='.(int)$id;
			else
				$q = 'insert into '.db::dbname('type_ligne_ticket').' (IdTypeLigne, Libel, Type_Principal, Date_Creation, Date_Modification) values (
							'.(int)$id.', "'.db::esc($libel).'", '.(int)$type_principal.', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)';
			$db->query($q);
		}
	}
}

?>