function materialise_fusion(button)
{
	//On vérifie que le bouton survolé est bien actif (fiche client sélectionnée)
	if($(button).prop('disabled') == false)
	{

		vide_fusion(button);

		$(button).parents('tbody').find('tr').has('input:checked').find('td').addClass('success');
		$(button).parents('tbody').find('tr').has('input:checked').find('td:last-child').removeClass('success');
		$(button).addClass('btn-success');
		$(button).parent().addClass('success');
	}

}

function vide_fusion(button)
{
	$(button).parents('tbody').find('td').removeClass('success');
	$(button).parent().removeClass('success');
	$(button).removeClass('btn-success');
}

function check_fusion(check)
{
	$(check).parents('tr').find('button').prop('disabled', !check.checked);
}

function fusionner(button, id)
{
	$("#message_fusion").hide();

	var allVals = [];
	$(button).parents('tbody').find('input:checked').each(function() {
		allVals.push($(this).val());
	});



	if(allVals.length < 2)
	{
		$("#error_fusion p").html('Impossible de fusionner une fiche client seule.');
		$("#error_fusion").show();
		window.alert("Impossible de fusionner une fiche client seule.");
	}
	else
	{
		$("#error_fusion").hide();

		// lancement du traitement de fusion
		var request = $.ajax({
		  url: "client.php",
		  method: "POST",
		  data: { action : "fusionner", c : id, f :  allVals.join()},
		  dataType: "xml"
		});

		request.done(function( xml ) {

			//En fonction du status reçu
			switch($(xml).find('status').text())
			{
				//Status d'un client inactif
				case '0':
					//Affichage message d'erreur sur la page
					$("#error_fusion p").html('Impossible de fusionner un client inactif.');
					$("#error_fusion").show();

					//Afficher un popup du message
					window.alert("Impossible de fusionner un client inactif.");
					break;

				//Status de fusion réussie
				case '1':
					$("#message_fusion p").html('Clients fusionnés avec succès.');
					$("#message_fusion").show();

					//Afficher un popup du message
					window.alert("Clients fusionnés avec succès.");

					// masquer les lignes fusionnées
					var parentTBody = $(button).parents('tbody');

					if(parentTBody)
					{
						parentTBody.find('tr').each(function()
						{
							if($(this).find('input:checked').length > 0)
							$(this).remove();
						});

						// et s'il ne reste qu'une seule ligne ou pas du tout on detruit le tbody
						if(parentTBody.find('tr').length < 2)
							parentTBody.remove();
					}
					break;

				//Satus de fusion échouée
				case '2':
					$("#error_fusion p").html('Erreur durant la fusion des fiches.');
					$("#error_fusion").show();

				//Status par défaut
				default:
					$("#error_fusion p").html('Erreur durant la fusion des fiches.');
					$("#error_fusion").show();
					break;
			}
		});


	}


}
