<?php

	
	class mysql
	{
		
		protected $m_conn_res;
		protected $m_server_name;
		protected $m_ident;
		protected $m_password;
		protected $m_database_name;
		protected $connexion_ok;
		
		
//	----------------------------------------------------------------------
//	myssql
//	~~~~~~~~~~~~~~~
// 	Constructeur
//	----------------------------------------------------------------------
		public function __construct()
		{
			$this->m_server_name 		= '';
			$this->m_ident 					= '';
			$this->m_password 			= '';
			$this->m_database_name 	= '';
			$this->connexion_ok = false;
		}
		
		
		
//	----------------------------------------------------------------------
//	connect
//	~~~~~~~~~~~~~~~
// 	connexion à la base de données
//	----------------------------------------------------------------------		
		public function connect($server, $id, $pass, $database='')
		{
			// conservation des valeurs dans les variables de la classe
			
			$this->m_server_name 		= $server;
			$this->m_ident 					= $id;
			$this->m_password 			= $pass;
			$this->m_database_name 	= $database;
			
			
			$connOk = FALSE;
			
			$this->m_conn_res = @mysqli_connect($this->m_server_name, $id, $pass);
			if($this->m_conn_res && $database != '')
			{
				$connOk = $this->select_db($database);
				$this->connexion_ok = $connOk;
			}
			
			/*if($connOk == FALSE)
			{
				$message = $this->message_error();
			  echo "Unable to connect !\n".$message;
			}*/
			
			return $connOk;//$this->m_conn_res;

		}
		
		public function connexion_ok()
		{
			if($this->connexion_ok)
				return true;
			else
				return false;
		}
		
//	----------------------------------------------------------------------
//	select_db
//	~~~~~~~~~~~~~~~
// 	choix de la base de données
//	----------------------------------------------------------------------				
		public function select_db($database)
		{
			$connOk = FALSE;
			
			if($this->m_conn_res && $database != '')
			{
				$connOk = @mysqli_select_db ($this->m_conn_res, $database);
			}
			
			return $connOk;
		}
		
//	----------------------------------------------------------------------
//	disconnect
//	~~~~~~~~~~~~~~~
// 	deconnexion à la base de données
//	----------------------------------------------------------------------		
		public function disconnect()
		{
			if($this->m_conn_res)
				@mysqli_close($this->m_conn_res);
				//sqlsrv_close( $this->m_conn_res);
		}
		
//	----------------------------------------------------------------------
//	query
//	~~~~~~~~~~~~~~~
// 	requete à la base de données
//	----------------------------------------------------------------------				
		public function query($query)
		{
			$stmt = null;
			if($this->m_conn_res)
			{
                mysqli_query($this->m_conn_res, "SET NAMES UTF8");
				$stmt = mysqli_query($this->m_conn_res, $query);
				if(!$stmt)
				{
					$message = $this->message_error();
					Tools::addError($this->message_error());
					//echo "<div style='border: 1px solid #DDD; background-color: #F0F0F0; color: #555;'>".$message."<br><i>".$query."</i></div>";
			  	//GestionErreur("Error in executing query on ".$this->m_database_name." !\n".$query."\n".$message);
				}
			}
			
			return $stmt;
		}
		
//	----------------------------------------------------------------------
//	multi_query
//	~~~~~~~~~~~~~~~
// 	requete multiples à la base de données
//	----------------------------------------------------------------------				
		public function multi_query($query)
		{
			$retour = false;
			$stmt = null;
			if($this->m_conn_res)
			{
				// pour vider les erreurs précédentes;
				$error = $this->error;
				$stmt = @mysqli_multi_query($this->m_conn_res, $query);
                mysqli_query($this->m_conn_res, "SET NAMES UTF8");
				
				while(mysqli_next_result($this->m_conn_res))mysqli_store_result($this->m_conn_res);
				$message = $this->error;
				
				if($message != '' && $message != $error)
				{
					Tools::addError($message);
					//echo "<div style='border: 1px solid #DDD; background-color: #F0F0F0; color: #555;'>".$message."<br><i>".$query."</i></div>";
			  	//GestionErreur("Error in executing query on ".$this->m_database_name." !\n".$query."\n".$message);
			  	return false;
				}
				else
					$retour = true;
			}
			
			return $retour;
		}
		
		
//	----------------------------------------------------------------------
//	select
//	~~~~~~~~~~~~~~~
// 	requete à la base de données et retourne tous les résultats dans un tableau
//	----------------------------------------------------------------------						
		public function select($query)
		{
			$values = array();
			if($stmt = $this->query($query))
			{
				while($row = $this->fetch_array($stmt, MYSQLI_ASSOC))
				{
					$values[] = $row;
				}
				$this->free($stmt);
			}
			
			return $values;
		}
		
//	----------------------------------------------------------------------
//	fetch_array
//	~~~~~~~~~~~~~~~
// 	retourne dans un tableau une ligne de resultat d'une requete
//	----------------------------------------------------------------------		
		public function fetch_array($stmt, $mode = MYSQLI_BOTH)
		{
			$row = false;
			
			if($stmt != false)
			{
				//$row = sqlsrv_fetch_array($stmt);
				$row = mysqli_fetch_array($stmt, $mode);
			}
			
			return $row;
		}
//	----------------------------------------------------------------------
//	num_rows
//	~~~~~~~~~~~~~~~
// 	retourne le nombre d'enregistrements trouvés dans un select
//	----------------------------------------------------------------------		
		public function num_rows($res)
		{
			$nb = 0;
			
			if($res)
			{
				$nb = mysqli_num_rows($res);
			}
			
			return $nb;
		}
//	----------------------------------------------------------------------
//	rows_affected
//	~~~~~~~~~~~~~~~
// 	retourne le nombre d'enregistrements concernés par un update delete ou insert
//	----------------------------------------------------------------------		
		public function rows_affected()
		{
			$nb = 0;
			
			if($this->m_conn_res)
			{
				//$row = sqlsrv_fetch_array($stmt);
				$nb = mysqli_affected_rows($this->m_conn_res);
			}
			
			return $nb;
		}
//	----------------------------------------------------------------------
//	seek
//	~~~~~~~~~~~~~~~
// 	retourne dans un tableau une ligne de resultat d'une requete
//	----------------------------------------------------------------------		
		public function seek($stmt)
		{
			if($stmt != false)
			{
				mysqli_data_seek($stmt, 0);
			}
		}
		
//	----------------------------------------------------------------------
//	free
//	~~~~~~~~~~~~~~~
// 	libere la variable de resutlat
//	----------------------------------------------------------------------		
		public function free($stmt)
		{
			//sqlsrv_free_stmt($stmt);
			if($stmt)
				mysqli_free_result($stmt);
		}

		public function liste_databases()
		{
			$tab_db = array();
			
			/*if($this->m_conn_res)
			{
				$res = mysql_list_dbs( $this->m_conn_res );
				
				while( $row = mysql_fetch_array( $res ) );
    			$tab_db[] = $row[0];
				
				mysql_free_result($res);
			}*/
			
			return $tab_db;
		}
		
		/*public function create_database($name)
		{
			$ok = FALSE;
			if($this->m_conn_res)
			{
				mysql_query("CREATE DATABASE ".$name) ;
				$ok = TRUE;
			}
			
			return $ok;
		}*/
	}
?>