<?php
	require_once(GENERAL_CLASSES_DIR.'/table.php');
	require_once(GENERAL_CLASSES_DIR.'/client.php');
	require_once(GENERAL_CLASSES_DIR.'/detail_ticket.php');

class ticket extends table
{
		public static $table_name = 'ticket';
		public static $unique_id = 'IdTicket';
		public static $field_list = array('IdClient', 'IdMagasin', 'IdTicketMagasin', 'Date_Crea', 'Heure_Crea', 'EnCours_O_N', 'IdVendeuse', 'MontantSoldeEuro', 'IdCaissiere', 'MontantVenteEuro', 'StockTraiter_O_N', 'Commentaire', 'DateModif', 'Groupe', 'ValeurChqFidel', 'Rembt_O_N', 'FinValiditeChqFidel', 'Facture_Numero', 'Facture_Nom', 'Facture_NumIntraClient', 'Facture_Date', 'TicketRef', 'Livr_Nom', 'IdTicket_txt_codeBarre', 'Facture_Valider_O_N', 'Caisse_IP', 'Facture_Info_Libel', 'Facture_Info_Valeur', 'NumCommande', 'NumTable', 'IdTicketType', 'AncienNumFacture', 'Facture_date_echeance', 'Facture_Civilite', 'Facture_Prenom', 'Facture_Societe', 'Facture_Adr1', 'Facture_Adr2', 'Facture_Adr3', 'Facture_Adr4', 'Facture_CP', 'Facture_Ville', 'Facture_IdPays', 'Livr_Civilite', 'Livr_Prenom', 'Livr_Societe', 'Livr_Adr1', 'Livr_Adr2', 'Livr_Adr3', 'Livr_Adr4', 'Livr_CP', 'Livr_Ville', 'Livr_IdPays', 'DateCreation', 'DateModification');

		protected static function select_complet($pagination=false)
		{
			$nom_table_client = db::dbname(client::$table_name);

			return 'select '.($pagination?'SQL_CALC_FOUND_ROWS ':'').'IdTicket as id, '.self::liste_champs().',
							'.$nom_table_client.'.Nom, '.$nom_table_client.'.Prenom, '.$nom_table_client.'.IdClientMagasin
							from '.db::dbname(self::$table_name).'
							left join '.$nom_table_client.' on '.$nom_table_client.'.IdClient='.db::dbname(self::$table_name).'.IdClient ';
		}

		public static function get($id)
		{
			$db = db::getInstance();

			$req = self::select_complet();
			if($id > 0)
  			$req.= ' where IdTicket='.(int)$id;
  		$res = $db->query($req);

      if($id != "")
        return $res->fetch_assoc();
      else
        return $res->fetch_all();
     
		}

		public static function from_date($date_en)
		{
			$db = db::getInstance();

			$req = self::select_complet();
			$req.= ' where Date_Crea="'.db::esc($date_en).'"';
			$mag = (int)context::get_context('magasin');
			if($mag > 0)
				$req.= ' And '.db::dbname(self::$table_name).'.IdMagasin = '.$mag;
  		return $db->query($req);

		}

		public static function search($search)
		{
			$db = db::getInstance();
			$nom_table_client = db::dbname(client::$table_name);

			$req = self::select_complet(true);
			$req.= ' where (
								IdTicket='.(int)$search.'
								Or IdTicketMagasin='.(int)$search.'
								Or Facture_Numero like "%'.db::esc($search).'%"
								Or TicketRef like "%'.db::esc($search).'%"
								Or '.$nom_table_client.'.Nom like "%'.db::esc($search).'%"
								Or '.$nom_table_client.'.Prenom like "%'.db::esc($search).'%"
							)';
			$mag = (int)context::get_context('magasin');
			if($mag > 0)
				$req.= ' And '.db::dbname(self::$table_name).'.IdMagasin = '.$mag;

			$req.= self::add_query_pagination();

  		return $db->query($req);
		}

		public static function get_by_magasin($IdTicketMagasin, $IdMagasin)
		{
			$db = db::getInstance();

			$req = 'select IdTicket as id, '.self::liste_champs().'
							from '.db::dbname(self::$table_name).'
  						where IdTicketMagasin='.(int)$IdTicketMagasin.' and IdMagasin='.(int)$IdMagasin.'
  						order by IdTicketMagasin';
  		$res = $db->query($req);
      
      return $res->fetch_assoc();
  	}

  	public static function get_by_client($IdClient)
		{
			$db = db::getInstance();

			$req = 'select IdTicket as id, '.self::liste_champs().'
							from '.db::dbname(self::$table_name).'
  						where IdClient='.(int)$IdClient.'
  						order by Date_Crea, Heure_Crea';
  		return $db->query($req);
  	}

  	public static function get_details($id_ticket)
  	{
  		return detail_ticket::get_by_ticket($id_ticket);
  	}

  	public static function save_from_xml($xml, $id_magasin)
  	{
  		$db = db::getInstance();
  		$IdTicketMagasin = self::get_xml_value($xml, 'IdTicket');
  		$ticket = null;

  		if($IdTicketMagasin > 0)
  			$ticket = self::get_by_magasin($IdTicketMagasin, $id_magasin);

  		// recherche du client
  		$id_client = (int)self::get_xml_value($xml, 'IdClient');
  		$id_client_cloud = 0;
  		if($id_client > 0)
  		{
  			$c = client::get_by_magasin($id_client, $id_magasin);
  			if($c) $id_client_cloud = $c['id'];
  		}


  		if(!$ticket)// insertion
  			return self::insert_from_xml($xml, $id_magasin, $id_client_cloud);
  		else // modification
  			return self::update_from_xml($ticket['id'], $xml, $id_magasin, $id_client_cloud);
  	}

  	protected static function insert_from_xml($xml, $id_magasin, $id_client)
  	{

			$dateFinValiditeChq = Tools::dateIsoToEn(self::get_xml_value($xml, 'FinValiditeChqFidel'));
			if($dateFinValiditeChq == "0000-00-00")
				$queryDateFinValiditeChq = "NULL";
			else
				$queryDateFinValiditeChq = '"'.$dateFinValiditeChq.'"';

			$dateFacture = Tools::dateIsoToEn(self::get_xml_value($xml, 'Facture_Date'));
			if($dateFacture == "0000-00-00")
				$queryDateFacture = "NULL";
			else
				$queryDateFacture = '"'.$dateFacture.'"';

			$dateEcheanceFacture = Tools::dateIsoToEn(self::get_xml_value($xml, 'Facture_date_echeance'));
			if($dateEcheanceFacture == "0000-00-00")
				$queryDateEchanceFac = "NULL";
			else
				$queryDateEchanceFac = '"'.$dateEcheanceFacture.'"';

			$dateLivr = Tools::dateIsoToEn(self::get_xml_value($xml, 'Livr_Date'));
			if($dateLivr == "0000-00-00")
				$queryDateLivr = "NULL";
			else
				$queryDateLivr = '"'.$dateLivr.'"';

  		$query = 'insert into '.db::dbname(self::$table_name).'
				(
					IdClient, IdMagasin, IdTicketMagasin, Date_Crea, Heure_Crea, EnCours_O_N, IdVendeuse,
					MontantSoldeEuro, IdCaissiere, MontantVenteEuro, StockTraiter_O_N, Commentaire, DateModif,
					Groupe, ValeurChqFidel, Rembt_O_N, FinValiditeChqFidel, Facture_Numero, Facture_Nom,
					Facture_NumIntraClient, Facture_Date, TicketRef, Livr_Nom, IdTicket_txt_codeBarre,
					Facture_Valider_O_N, Caisse_IP, Facture_Info_Libel, Facture_Info_Valeur, NumCommande, NumTable,
					IdTicketType, AncienNumFacture, Facture_date_echeance, Facture_Civilite, Facture_Prenom,
					Facture_Societe, Facture_Adr1, Facture_Adr2, Facture_Adr3, Facture_Adr4, Facture_CP,
					Facture_Ville, Facture_IdPays, Livr_Civilite, Livr_Prenom, Livr_Societe, Livr_Adr1, Livr_Adr2,
					Livr_Adr3, Livr_Adr4, Livr_CP, Livr_Ville, Livr_IdPays, IdMagOrgModif, TriggerBatchBloque_O_N,
					EMPL_Libel, EMPL_Num, Livr_Tel, Livr_CodePorte, Livr_Date, Livr_Heure, Livr_Info, DateCreation, DateModification)
					values
					('.(int)$id_client.', '.$id_magasin.',
					'.(int)self::get_xml_value($xml, 'IdTicket').', 
					"'.Tools::dateIsoToEn(self::get_xml_value($xml, 'Date_Crea')).'",
					"'.Tools::dateIsoToTime(self::get_xml_value($xml, 'Heure_Crea')).'", 
					'.(int)self::get_xml_value($xml, 'EnCours_O_N').',
					'.(int)self::get_xml_value($xml, 'IdVendeuse').', 
					'.db::real(self::get_xml_value($xml, 'MontantSoldeEuro')).',
					'.(int)self::get_xml_value($xml, 'IdCaissiere').', 
					'.db::real(self::get_xml_value($xml, 'MontantVenteEuro')).',
					'.(int)self::get_xml_value($xml, 'StockTraiter_O_N').',
					"'.db::esc(self::get_xml_value($xml, 'Commentaire')).'",
					"'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateModif')).'", 
					'.(int)self::get_xml_value($xml, 'Groupe').',
					'.db::real(self::get_xml_value($xml, 'ValeurChqFidel')).', 
					'.(int)self::get_xml_value($xml, 'Rembt_O_N').',
					'.$queryDateFinValiditeChq.', 
					"'.db::esc(self::get_xml_value($xml, 'Facture_Numero')).'",
					"'.db::esc(self::get_xml_value($xml, 'Facture_Nom')).'", 
					"'.db::esc(self::get_xml_value($xml, 'Facture_NumIntraClient')).'",
					'.$queryDateFacture.', 
					"'.db::esc(self::get_xml_value($xml, 'TicketRef')).'",
					"'.db::esc(self::get_xml_value($xml, 'Livr_Nom')).'", 
					'.(int)self::get_xml_value($xml, 'IdTicket_txt_codeBarre').',
					'.(int)self::get_xml_value($xml, 'Facture_Valider_O_N').', 
					"'.db::esc(self::get_xml_value($xml, 'Caisse_IP')).'",
					"'.db::esc(self::get_xml_value($xml, 'Facture_Info_Libel')).'", 
					"'.db::esc(self::get_xml_value($xml, 'Facture_Info_Valeur')).'",
					"'.db::esc(self::get_xml_value($xml, 'NumCommande')).'", 
					'.(int)self::get_xml_value($xml, 'NumTable').',
					'.(int)self::get_xml_value($xml, 'IdTicketType').', 
					"'.db::esc(self::get_xml_value($xml, 'AncienNumFacture')).'",
					'.$queryDateEchanceFac.', 
					"'.db::esc(self::get_xml_value($xml, 'Facture_Civilite')).'",
					"'.db::esc(self::get_xml_value($xml, 'Facture_Prenom')).'", 
					"'.db::esc(self::get_xml_value($xml, 'Facture_Societe')).'",
					"'.db::esc(self::get_xml_value($xml, 'Facture_Adr1')).'", 
					"'.db::esc(self::get_xml_value($xml, 'Facture_Adr2')).'",
					"'.db::esc(self::get_xml_value($xml, 'Facture_Adr3')).'", 
					"'.db::esc(self::get_xml_value($xml, 'Facture_Adr4')).'",
					"'.db::esc(self::get_xml_value($xml, 'Facture_CP')).'", 
					"'.db::esc(self::get_xml_value($xml, 'Facture_Ville')).'",
					'.(int)self::get_xml_value($xml, 'Facture_IdPays').', 
					"'.db::esc(self::get_xml_value($xml, 'Livr_Civilite')).'",
					"'.db::esc(self::get_xml_value($xml, 'Livr_Prenom')).'", 
					"'.db::esc(self::get_xml_value($xml, 'Livr_Societe')).'",
					"'.db::esc(self::get_xml_value($xml, 'Livr_Adr1')).'", 
					"'.db::esc(self::get_xml_value($xml, 'Livr_Adr2')).'",
					"'.db::esc(self::get_xml_value($xml, 'Livr_Adr3')).'", 
					"'.db::esc(self::get_xml_value($xml, 'Livr_Adr4')).'",
					"'.db::esc(self::get_xml_value($xml, 'Livr_CP')).'", 
					"'.db::esc(self::get_xml_value($xml, 'Livr_Ville')).'",
					'.(int)self::get_xml_value($xml, 'Livr_IdPays').', 
					'.(int)self::get_xml_value($xml, 'IdMagOrgModif').',
					'.(int)self::get_xml_value($xml, 'TriggerBatchBloque_O_N').', 
					"'.db::esc(self::get_xml_value($xml, 'EMPL_Libel')).'",
					'.(int)self::get_xml_value($xml, 'EMPL_Num').', 
					"'.db::esc(self::get_xml_value($xml, 'Livr_Tel')).'",
					"'.db::esc(self::get_xml_value($xml, 'Livr_CodePorte')).'", 
					'.$queryDateLivr.',
					"'.Tools::dateIsoToTime(self::get_xml_value($xml, 'Livr_Heure')).'", 
					"'.db::esc(self::get_xml_value($xml, 'Livr_Info')).'",
					CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)';
  		$db = db::getInstance();
  		if($db->query($query))
  		{
  			$id = $db->insert_id;
  			//self::new_log_batch($id);
			$file_text = "[Ticket] Insertion du ticket avec IdTicket = '".(int)self::get_xml_value($xml, 'IdTicket') ." --> Succès \n";
			file_put_contents('logs/log_batch.txt', $file_text, FILE_APPEND);
  			return $id;
  		}
  		else
		{
			$file_text = "[Ticket] Insertion du ticket avec IdTicket = '".(int)self::get_xml_value($xml, 'IdTicket') ." --> Error (Retour MySQLi : ".$db->error.") \n";
			file_put_contents('logs/log_batch.txt', $file_text, FILE_APPEND);
  			return false;
		}
  	}

  	protected static function update_from_xml($id_ticket, $xml, $id_magasin, $id_client)
  	{
			$dateFinValiditeChq = Tools::dateIsoToEn(self::get_xml_value($xml, 'FinValiditeChqFidel'));
			if($dateFinValiditeChq == "0000-00-00")
				$queryDateFinValiditeChq = "NULL";
			else
				$queryDateFinValiditeChq = '"'.$dateFinValiditeChq.'"';

			$dateFacture = Tools::dateIsoToEn(self::get_xml_value($xml, 'Facture_Date'));
			if($dateFacture == "0000-00-00")
				$queryDateFacture = "NULL";
			else
				$queryDateFacture = '"'.$dateFacture.'"';

			$dateEcheanceFacture = Tools::dateIsoToEn(self::get_xml_value($xml, 'Facture_date_echeance'));
			if($dateEcheanceFacture == "0000-00-00")
				$queryDateEchanceFac = "NULL";
			else
				$queryDateEchanceFac = '"'.$dateEcheanceFacture.'"';

			$dateLivr = Tools::dateIsoToEn(self::get_xml_value($xml, 'Livr_Date'));
			if($dateLivr == "0000-00-00")
				$queryDateLivr = "NULL";
			else
				$queryDateLivr = '"'.$dateLivr.'"';

  		$query = 'update '.db::dbname(self::$table_name).' set
  							IdClient='.(int)$id_client.',
								IdTicketMagasin='.(int)self::get_xml_value($xml, 'IdTicket').', 
								Date_Crea="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'Date_Crea')).'",
								Heure_Crea="'.Tools::dateIsoToTime(self::get_xml_value($xml, 'Heure_Crea')).'", 
								EnCours_O_N='.(int)self::get_xml_value($xml, 'EnCours_O_N').',
								IdVendeuse='.(int)self::get_xml_value($xml, 'IdVendeuse').', 
								MontantSoldeEuro='.db::real(self::get_xml_value($xml, 'MontantSoldeEuro')).',
								IdCaissiere='.(int)self::get_xml_value($xml, 'IdCaissiere').', 
								MontantVenteEuro='.db::real(self::get_xml_value($xml, 'MontantVenteEuro')).',
								StockTraiter_O_N='.db::real(self::get_xml_value($xml, 'StockTraiter_O_N')).', 
								Commentaire="'.db::esc(self::get_xml_value($xml, 'Commentaire')).'",
								DateModif="'.Tools::dateIsoToEn(self::get_xml_value($xml, 'DateModif')).'", 
								Groupe='.(int)self::get_xml_value($xml, 'Groupe').',
								ValeurChqFidel='.db::real(self::get_xml_value($xml, 'ValeurChqFidel')).', 
								Rembt_O_N='.(int)self::get_xml_value($xml, 'Rembt_O_N').',
								FinValiditeChqFidel='.$queryDateFinValiditeChq.', 
								Facture_Numero="'.db::esc(self::get_xml_value($xml, 'Facture_Numero')).'",
								Facture_Nom="'.db::esc(self::get_xml_value($xml, 'Facture_Nom')).'", 
								Facture_NumIntraClient="'.db::esc(self::get_xml_value($xml, 'Facture_NumIntraClient')).'",
								Facture_Date='.$queryDateFacture.', 
								TicketRef="'.db::esc(self::get_xml_value($xml, 'TicketRef')).'",
								Livr_Nom="'.db::esc(self::get_xml_value($xml, 'Livr_Nom')).'", 
								IdTicket_txt_codeBarre='.(int)self::get_xml_value($xml, 'IdTicket_txt_codeBarre').',
								Facture_Valider_O_N='.(int)self::get_xml_value($xml, 'Facture_Valider_O_N').', 
								Caisse_IP="'.db::esc(self::get_xml_value($xml, 'Caisse_IP')).'",
								Facture_Info_Libel='.(int)self::get_xml_value($xml, 'Facture_Info_Libel').', 
								Facture_Info_Valeur="'.db::esc(self::get_xml_value($xml, 'Facture_Info_Valeur')).'",
								NumCommande="'.db::esc(self::get_xml_value($xml, 'NumCommande')).'", 
								NumTable='.(int)self::get_xml_value($xml, 'NumTable').',
								IdTicketType='.(int)self::get_xml_value($xml, 'IdTicketType').', 
								AncienNumFacture="'.db::esc(self::get_xml_value($xml, 'AncienNumFacture')).'",
								Facture_date_echeance='.$queryDateEchanceFac.', 
								Facture_Civilite="'.db::esc(self::get_xml_value($xml, 'Facture_Civilite')).'",
								Facture_Prenom="'.db::esc(self::get_xml_value($xml, 'Facture_Prenom')).'", 
								Facture_Societe="'.db::esc(self::get_xml_value($xml, 'Facture_Societe')).'",
								Facture_Adr1="'.db::esc(self::get_xml_value($xml, 'Facture_Adr1')).'", 
								Facture_Adr2="'.db::esc(self::get_xml_value($xml, 'Facture_Adr2')).'",
								Facture_Adr3="'.db::esc(self::get_xml_value($xml, 'Facture_Adr3')).'", 
								Facture_Adr4="'.db::esc(self::get_xml_value($xml, 'Facture_Adr4')).'",
								Facture_CP="'.db::esc(self::get_xml_value($xml, 'Facture_CP')).'", 
								Facture_Ville="'.db::esc(self::get_xml_value($xml, 'Facture_Ville')).'",
								Facture_IdPays='.(int)self::get_xml_value($xml, 'Facture_IdPays').', 
								Livr_Civilite="'.db::esc(self::get_xml_value($xml, 'Livr_Civilite')).'",
								Livr_Prenom="'.db::esc(self::get_xml_value($xml, 'Livr_Prenom')).'", 
								Livr_Societe="'.db::esc(self::get_xml_value($xml, 'Livr_Societe')).'",
								Livr_Adr1="'.db::esc(self::get_xml_value($xml, 'Livr_Adr1')).'", 
								Livr_Adr2="'.db::esc(self::get_xml_value($xml, 'Livr_Adr2')).'",
								Livr_Adr3="'.db::esc(self::get_xml_value($xml, 'Livr_Adr3')).'", 
								Livr_Adr4="'.db::esc(self::get_xml_value($xml, 'Livr_Adr4')).'",
								Livr_CP="'.db::esc(self::get_xml_value($xml, 'Livr_CP')).'", 
								Livr_Ville="'.db::esc(self::get_xml_value($xml, 'Livr_Ville')).'",
  							Livr_IdPays='.(int)self::get_xml_value($xml, 'Facture_IdPays').',
								IdMagOrgModif='.(int)self::get_xml_value($xml, 'IdMagOrgModif').', 
								TriggerBatchBloque_O_N='.(int)self::get_xml_value($xml, 'TriggerBatchBloque_O_N').',
								EMPL_Libel="'.db::esc(self::get_xml_value($xml, 'EMPL_Libel')).'", 
								EMPL_Num='.(int)self::get_xml_value($xml, 'EMPL_Num').',
								Livr_Tel="'.db::esc(self::get_xml_value($xml, 'Livr_Tel')).'", 
								Livr_CodePorte="'.db::esc(self::get_xml_value($xml, 'Livr_CodePorte')).'",
								Livr_Date='.$queryDateLivr.', 
								Livr_Heure="'.Tools::dateIsoToTime(self::get_xml_value($xml, 'Livr_Heure')).'",
  							Livr_Info="'.db::esc(self::get_xml_value($xml, 'Livr_Info')).'",
  							DateModification=CURRENT_TIMESTAMP
  							Where IdTicket='.(int)$id_ticket;
  		$db = db::getInstance();
  		if($db->query($query))
  		{
  			//self::new_log_batch($id_ticket);
			$file_text = "[Ticket] Mise à jour du ticket avec IdTicket = '".(int)self::get_xml_value($xml, 'IdTicket') ." --> Succès \n";
			file_put_contents('logs/log_batch.txt', $file_text, FILE_APPEND);
  			return $id_ticket;
  		}
  		else
		{
			$file_text = "[Ticket] Mise à jour du ticket avec IdTicket = '".(int)self::get_xml_value($xml, 'IdTicket') ." --> Error (Retour MySQLi : ".$db->error.") \n";
			file_put_contents('logs/log_batch.txt', $file_text, FILE_APPEND);
  			return false;
		}
  	}

  	public static function panier_moyen($date_deb, $date_fin, $regroupement='DATE', $mag=0)
  	{
  		$order = 'Date_Crea';

  		switch($regroupement)
  		{
  			case 'JOUR':
  				$champ_regroup = 'DATE_FORMAT(Date_Crea, "%w")';
  				$order = 'absice';
  				break;
  			case 'SEMAINE':
  				$champ_regroup = 'DATE_FORMAT(Date_Crea, "%u")';
  				$order = 'absice';
  				break;
  			case 'MOIS':
  				$champ_regroup = 'DATE_FORMAT(Date_Crea, "%m")';
  				$order = 'absice';
  				break;
  			default:
  				$champ_regroup = 'DATE_FORMAT(Date_Crea, "%d/%m/%Y")';
  		}

  		$db = db::getInstance();
  		$req = 'Select sum(MontantVenteEuro)/count(IdTicket) as Cumul, '.$champ_regroup.' as absice
  							from '.db::dbname(self::$table_name).'
  							Where Date_Crea >="'.$date_deb.'" and Date_Crea <="'.$date_fin.'" ';
  		if($mag > 0) $req.= ' And IdMagasin='.(int)$mag;
  		$req.= '	Group by '.$champ_regroup.'
  							Order by '.$order;
  		return $db->query($req);

  	}

  	public static function nb_tickets($date_deb, $date_fin, $regroupement='DATE', $mag=0)
  	{
  		$order = 'Date_Crea';

  		switch($regroupement)
  		{
  			case 'JOUR':
  				$champ_regroup = 'DATE_FORMAT(Date_Crea, "%w")';
  				$order = 'absice';
  				break;
  			case 'SEMAINE':
  				$champ_regroup = 'DATE_FORMAT(Date_Crea, "%u")';
  				$order = 'absice';
  				break;
  			case 'MOIS':
  				$champ_regroup = 'DATE_FORMAT(Date_Crea, "%m")';
  				$order = 'absice';
  				break;
  			default:
  				$champ_regroup = 'DATE_FORMAT(Date_Crea, "%d/%m/%Y")';
  		}

  		$db = db::getInstance();
  		$req = 'Select count(IdTicket) as Cumul, '.$champ_regroup.' as absice
  							from '.db::dbname(self::$table_name).'
  							Where Date_Crea >="'.$date_deb.'" and Date_Crea <="'.$date_fin.'" ';
  		if($mag > 0) $req.= ' And IdMagasin = '.(int)$mag;

  		$req.= '	Group by '.$champ_regroup.'
  							Order by '.$order;
  		return $db->query($req);

  	}

	public static function liste_annees()
	{
		$retour = array();
		$db = db::getInstance();
  		$req = 'SELECT distinct(YEAR(Date_Crea)) as annee from '.db::dbname(self::$table_name).' order by annee';
        $liste = $db->query($req);
		foreach($liste as $a)
		{
			$retour[] = $a['annee'];
		}

		return $retour;
	}
}

?>
