<?php

	function unzip($file)
	{

		$zip=zip_open(realpath(".")."/".$file);
		if(!is_resource($zip)) {return("Impossible de décompresser '{$file}' : ".zipFileErrMsg($zip));}
				
		$e='';
		
		while($zip_entry=zip_read($zip)) 
		{
			$zdir=dirname(zip_entry_name($zip_entry));
			$zname=zip_entry_name($zip_entry);
			
			if(!zip_entry_open($zip,$zip_entry,"r")) {$e.="Erreur d'extraction du fichier '{$zname}'";continue;}
			if(!is_dir($zdir)) mkdirr($zdir,0777);
			
			$zip_fs=zip_entry_filesize($zip_entry);
			if(empty($zip_fs)) continue;
			
			$zz=zip_entry_read($zip_entry,$zip_fs);
			
			$z=fopen($zname,"w");
			fwrite($z,$zz);
			fclose($z);
			zip_entry_close($zip_entry);
		
		} 
		zip_close($zip);
		
		return($e);
	} 
	
	function zipFileErrMsg($errno) 
	{
	  // using constant name as a string to make this function PHP4 compatible
	  $zipFileFunctionsErrors = array(
	    'ZIPARCHIVE::ER_MULTIDISK' => 'Multi-disk zip archives not supported.',
	    'ZIPARCHIVE::ER_RENAME' => 'Renaming temporary file failed.',
	    'ZIPARCHIVE::ER_CLOSE' => 'Closing zip archive failed', 
	    'ZIPARCHIVE::ER_SEEK' => 'Seek error',
	    'ZIPARCHIVE::ER_READ' => 'Read error',
	    'ZIPARCHIVE::ER_WRITE' => 'Write error',
	    'ZIPARCHIVE::ER_CRC' => 'CRC error',
	    'ZIPARCHIVE::ER_ZIPCLOSED' => 'Containing zip archive was closed',
	    'ZIPARCHIVE::ER_NOENT' => 'No such file.',
	    'ZIPARCHIVE::ER_EXISTS' => 'File already exists',
	    'ZIPARCHIVE::ER_OPEN' => 'Can\'t open file', 
	    'ZIPARCHIVE::ER_TMPOPEN' => 'Failure to create temporary file.', 
	    'ZIPARCHIVE::ER_ZLIB' => 'Zlib error',
	    'ZIPARCHIVE::ER_MEMORY' => 'Memory allocation failure', 
	    'ZIPARCHIVE::ER_CHANGED' => 'Entry has been changed',
	    'ZIPARCHIVE::ER_COMPNOTSUPP' => 'Compression method not supported.', 
	    'ZIPARCHIVE::ER_EOF' => 'Premature EOF',
	    'ZIPARCHIVE::ER_INVAL' => 'Invalid argument',
	    'ZIPARCHIVE::ER_NOZIP' => 'Not a zip archive',
	    'ZIPARCHIVE::ER_INTERNAL' => 'Internal error',
	    'ZIPARCHIVE::ER_INCONS' => 'Zip archive inconsistent', 
	    'ZIPARCHIVE::ER_REMOVE' => 'Can\'t remove file',
	    'ZIPARCHIVE::ER_DELETED' => 'Entry has been deleted',
	  );
	  $errmsg = 'unknown';
	  foreach ($zipFileFunctionsErrors as $constName => $errorMessage) 
	  {
	    if (defined($constName) and constant($constName) === $errno) 
	    {
	      return 'Zip File Function error: '.$errorMessage;
	    }
	  }
  	return 'Zip File Function error: unknown';
	}

	
	function mkdirr($pn,$mode=null) 
	{
		if(is_dir($pn)||empty($pn)) return true;
		$pn=str_replace(array('/', ''),DIRECTORY_SEPARATOR,$pn);
		
		if(is_file($pn)) {trigger_error('mkdirr() File exists', E_USER_WARNING);return false;}
		
		$next_pathname=substr($pn,0,strrpos($pn,DIRECTORY_SEPARATOR));
		if(mkdirr($next_pathname,$mode)) {if(!file_exists($pn)) {return mkdir($pn,$mode);} }
		return false;
	}

	$erreur = unzip('kintpvcloud.zip');
	
	if(!isset($silent))
	{
	
		header("Content-type: text/xml");
		echo '<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>'."\n";
		echo '<install>';
		echo '<ok>'.(($erreur!='')?'0':'1').'</ok>';
		echo '<message>'.$erreur.'</message>';
		echo '</install>';
	}
?>